/// <reference path='../../typings/lodash/lodash.d.ts' />

import _ = require('lodash');
import assert = require('assert');
import java = require('../tsJavaModule');
import Java = java.Java;

// We intentionally have two different classes named Thing, so it is necessary to refer
// to the specific class we want with the full class path. But Typescript makes it easy
// to declare a type alias, which shortens some code in the scenarios code below.
// Unfortunately, Typescript does not allow import aliases in function scope.
import Thing = Java.com.redseal.featureset.Thing;

Java.ensureJvm().then(() => {
  var Arrays = Java.importClass('java.util.Arrays');

  var SomeClass = Java.importClass('com.redseal.featureset.SomeClass');
  var something: Java.SomeInterface = new SomeClass();
  var clazz: Java.java.lang.Class = something.getClass();
var methods: Java.java.lang.reflect.Method[] = clazz.getDeclaredMethods();
assert.ok(_.isArray(methods));
assert.ok(methods.length > 0);
_.forEach(methods, (method: Java.Method) => assert.ok(Java.instanceOf(method, 'java.lang.reflect.Method')));
});
