/// <reference path='../../typings/lodash/lodash.d.ts' />

import _ = require('lodash');
import assert = require('assert');
import java = require('../tsJavaModule');
import Java = java.Java;

// We intentionally have two different classes named Thing, so it is necessary to refer
// to the specific class we want with the full class path. But Typescript makes it easy
// to declare a type alias, which shortens some code in the scenarios code below.
// Unfortunately, Typescript does not allow import aliases in function scope.
import Thing = Java.com.redseal.featureset.Thing;

Java.ensureJvm().then(() => {
  var Arrays = Java.importClass('java.util.Arrays');

  var SomeClass = Java.importClass('com.redseal.featureset.SomeClass');
  var something: Java.SomeInterface = new SomeClass();
  var arr: string[] = something.getList();
assert.ok(_.isArray(arr));
assert.deepEqual(arr, [ 'a', 'b', 'c' ]);
});
