/// <reference path='../../typings/lodash/lodash.d.ts' />
var _ = require('lodash');
var assert = require('assert');
var java = require('../tsJavaModule');
var Java = java.Java;
Java.ensureJvm().then(function () {
    var Arrays = Java.importClass('java.util.Arrays');
    var SomeClass = Java.importClass('com.redseal.featureset.SomeClass');
    var something = new SomeClass();
    var things = something.getThings();
    assert.ok(_.isArray(things));
    assert.strictEqual(things.length, 2);
    var thing1d = things[1];
    assert.ok(_.isArray(thing1d));
    assert.strictEqual(thing1d.length, 3);
    var thingStrs = _.map(things, function (thing1d) { return _.map(thing1d, function (thing) { return thing.toString(); }); });
    assert.deepEqual(thingStrs, [['Thing0', 'Thing1', 'Thing2'], ['Thing3', 'Thing4', 'Thing5']]);
});
//# sourceMappingURL=Getting_2d_array_of_non_primitive_type.js.map