var assert = require('assert');
var java = require('../tsJavaModule');
var Java = java.Java;
Java.ensureJvm().then(function () {
    var Arrays = Java.importClass('java.util.Arrays');
    var SomeClass = Java.importClass('SomeClass');
    var obj = new SomeClass(); // intentionally drop type information
    assert.throws(function () { return Java.asInstanceOf(obj, 'Bogus'); }, /java.lang.NoClassDefFoundError/);
    assert.throws(function () { return Java.asInstanceOf(obj, 'java.lang.Objct'); }, /java.lang.NoClassDefFoundError/);
    // ambiguous
    assert.throws(function () { return Java.asInstanceOf(obj, 'Thing'); }, /java.lang.NoClassDefFoundError/);
    // A valid classname, but not an inherited type
    assert.throws(function () { return Java.asInstanceOf(obj, 'com.redseal.featureset.Thing'); }, /asInstanceOf fails, obj is not a/);
});
//# sourceMappingURL=asInstanceOf_negative_test_cases.js.map