
import assert = require('assert');
import java = require('../tsJavaModule');
import Java = java.Java;

Java.ensureJvm().then(() => {
  var Arrays = Java.importClass('java.util.Arrays');
  var SomeClass: Java.SomeClass.Static = Java.importClass('SomeClass');
var obj: any = new SomeClass();   // intentionally drop type information

assert.throws(() => Java.asInstanceOf(obj, 'Bogus'), /java.lang.NoClassDefFoundError/);
assert.throws(() => Java.asInstanceOf(obj, 'java.lang.Objct'), /java.lang.NoClassDefFoundError/);

// ambiguous
assert.throws(() => Java.asInstanceOf(obj, 'Thing'), /java.lang.NoClassDefFoundError/);

// A valid classname, but not an inherited type
assert.throws(() => Java.asInstanceOf(obj, 'com.redseal.featureset.Thing'), /asInstanceOf fails, obj is not a/);
});
