var assert = require('assert');
var java = require('../tsJavaModule');
var Java = java.Java;
Java.ensureJvm().then(function () {
    var Arrays = Java.importClass('java.util.Arrays');
    var SomeClass = Java.importClass('SomeClass');
    var obj = new SomeClass(); // intentionally drop type information
    var some1 = Java.asInstanceOf(obj, 'java.lang.Object');
    assert.strictEqual(some1.getClass().getName(), 'com.redseal.featureset.SomeClass');
    var some2 = Java.asInstanceOf(obj, 'com.redseal.featureset.SomeInterface');
    assert.strictEqual(some2.getClass().getName(), 'com.redseal.featureset.SomeClass');
    var some3 = Java.asInstanceOf(obj, 'com.redseal.featureset.SomeAbstractClass');
    assert.strictEqual(some3.getClass().getName(), 'com.redseal.featureset.SomeClass');
    var some4 = Java.asInstanceOf(obj, 'com.redseal.featureset.SomeClass');
    assert.strictEqual(some4.getClass().getName(), 'com.redseal.featureset.SomeClass');
});
//# sourceMappingURL=asInstanceOf_with_fully_qualified_class_name.js.map