var assert = require('assert');
var java = require('../tsJavaModule');
var Java = java.Java;
Java.ensureJvm().then(function () {
    var Arrays = Java.importClass('java.util.Arrays');
    var SomeClass = Java.importClass('SomeClass');
    var obj = new SomeClass(); // intentionally drop type information
    var some1 = Java.asInstanceOf(obj, 'Object');
    assert.strictEqual(some1.getClass().getName(), 'com.redseal.featureset.SomeClass');
    var some2 = Java.asInstanceOf(obj, 'SomeInterface');
    assert.strictEqual(some2.getClass().getName(), 'com.redseal.featureset.SomeClass');
    var some3 = Java.asInstanceOf(obj, 'SomeAbstractClass');
    assert.strictEqual(some3.getClass().getName(), 'com.redseal.featureset.SomeClass');
    var some4 = Java.asInstanceOf(obj, 'SomeClass');
    assert.strictEqual(some4.getClass().getName(), 'com.redseal.featureset.SomeClass');
});
//# sourceMappingURL=asInstanceOf_with_valid_short_class_name.js.map