/// <reference path='../../typings/lodash/lodash.d.ts' />
var _ = require('lodash');
var assert = require('assert');
var java = require('../tsJavaModule');
var Java = java.Java;
Java.ensureJvm().then(function () {
    var AnEnum = Java.importClass('com.redseal.featureset.AnEnum');
    var enums = AnEnum.values();
    assert.ok(_.isArray(enums));
    var ids = _.map(enums, function (e) { return e.toString(); });
    assert.deepEqual(ids, ['mingus', 'monk', 'miles']);
});
//# sourceMappingURL=values.js.map