/// <reference path='../../typings/lodash/lodash.d.ts' />

import _ = require('lodash');
import assert = require('assert');
import java = require('../tsJavaModule');
import Java = java.Java;

Java.ensureJvm().then(() => {
  var AnEnum = Java.importClass('com.redseal.featureset.AnEnum');
  var enums: Java.AnEnum[] = AnEnum.values();
assert.ok(_.isArray(enums));
var ids: string[] = _.map(enums, (e: Java.AnEnum) => e.toString());
assert.deepEqual(ids, [ 'mingus', 'monk', 'miles' ]);
});
