
import assert = require('assert');
import BluePromise = require('bluebird');
import java = require('../tsJavaModule');
import Java = java.Java;

Java.ensureJvm().then(() => {
  var list: Java.ArrayList = Java.newInstance('java.util.ArrayList');
list.add('a');
list.add(42);
list.add(true);
var results: Java.object_t[] = [];
Java.forEach(list.iterator(), (item: Java.object_t): BluePromise<void> => {
  results.push(item);
  return BluePromise.resolve();
})
.then(() => assert.deepEqual(results, ['a', 42, true]));
});
