var assert = require('assert');
var java = require('../tsJavaModule');
var Java = java.Java;
Java.ensureJvm().then(function () {
    assert.strictEqual(false, Java.isJavaObject({}));
    assert.strictEqual(false, Java.isJavaObject({ a: 1 }));
    assert.strictEqual(false, Java.isJavaObject('a string'));
    assert.strictEqual(false, Java.isJavaObject(23));
    assert.strictEqual(false, Java.isJavaObject(23.7));
    assert.strictEqual(false, Java.isJavaObject([1, 2, 3]));
    assert.strictEqual(false, Java.isJavaObject(Java.L(23)));
    var SomeClass = Java.importClass('SomeClass');
    assert.strictEqual(false, Java.isJavaObject(SomeClass));
    assert.strictEqual(true, Java.isJavaObject(SomeClass.class));
    var obj = new SomeClass();
    assert.strictEqual(true, Java.isJavaObject(obj));
});
//# sourceMappingURL=isJavaObject.js.map