var assert = require('assert');
var java = require('../tsJavaModule');
var Java = java.Java;
Java.ensureJvm().then(function () {
    var aLongValue = Java.L(23);
    assert.strictEqual(true, Java.isLongValue(aLongValue));
    assert.strictEqual(false, Java.isLongValue({}));
    assert.strictEqual(false, Java.isLongValue({ a: 1 }));
    assert.strictEqual(false, Java.isLongValue('a string'));
    assert.strictEqual(false, Java.isLongValue(23));
    assert.strictEqual(false, Java.isLongValue(23.7));
    assert.strictEqual(false, Java.isLongValue([1, 2, 3]));
    var SomeClass = Java.importClass('SomeClass');
    assert.strictEqual(false, Java.isLongValue(SomeClass));
    assert.strictEqual(false, Java.isLongValue(SomeClass.class));
    var obj = new SomeClass();
    assert.strictEqual(false, Java.isLongValue(obj));
});
//# sourceMappingURL=isLongValue.js.map