
import assert = require('assert');
import BluePromise = require('bluebird');
import java = require('../tsJavaModule');
import Java = java.Java;

Java.ensureJvm().then(() => {
  var aLongValue: Java.longValue_t = Java.L(23);
assert.strictEqual(true, Java.isLongValue(aLongValue));

assert.strictEqual(false, Java.isLongValue({}));
assert.strictEqual(false, Java.isLongValue({a: 1}));
assert.strictEqual(false, Java.isLongValue('a string'));
assert.strictEqual(false, Java.isLongValue(23));
assert.strictEqual(false, Java.isLongValue(23.7));
assert.strictEqual(false, Java.isLongValue([1, 2, 3]));

var SomeClass: Java.SomeClass.Static = Java.importClass('SomeClass');
assert.strictEqual(false, Java.isLongValue(SomeClass));
assert.strictEqual(false, Java.isLongValue(SomeClass.class));

var obj: Java.SomeClass = new SomeClass();
assert.strictEqual(false, Java.isLongValue(obj));
});
