
import assert = require('assert');
import hellojava = require('../../hellojava/tsJavaModule');
import reflection = require('../../reflection/tsJavaModule');
import featureset = require('../../featureset/tsJavaModule');

// It's not strictly necessary to call ensureJvm for each module -- once is sufficient.
// However, there is no harm in doing so.
hellojava.Java.ensureJvm()
  .then(() => reflection.Java.ensureJvm())
  .then(() => featureset.Java.ensureJvm())
  .then(() => {
      var Class1: featureset.Java.Class.Static = featureset.Java.importClass('Class');
  var Class2: reflection.Java.Class.Static = reflection.Java.importClass('Class');

  Class1 = <featureset.Java.Class.Static> <any> Class2;
  assert.strictEqual('java.lang.String', Class1.forName('java.lang.String').getName());
  });
