var assert = require('assert');
var hellojava = require('../../hellojava/tsJavaModule');
var reflection = require('../../reflection/tsJavaModule');
var featureset = require('../../featureset/tsJavaModule');
// It's not strictly necessary to call ensureJvm for each module -- once is sufficient.
// However, there is no harm in doing so.
hellojava.Java.ensureJvm()
    .then(function () { return reflection.Java.ensureJvm(); })
    .then(function () { return featureset.Java.ensureJvm(); })
    .then(function () {
    var classLoader = reflection.Java.getClassLoader();
    function verify(className) {
        assert.strictEqual(className, classLoader.loadClass(className).getName());
    }
    // A class that is declared in both modules
    verify('java.lang.String');
    // A class declared only in reflection
    verify('java.lang.reflect.Parameter');
    // A class declared only in hellojava
    verify('com.redseal.hellojava.HelloJava');
});
//# sourceMappingURL=Reflection_may_be_used_across_modules.js.map