
import assert = require('assert');
import hellojava = require('../../hellojava/tsJavaModule');
import reflection = require('../../reflection/tsJavaModule');
import featureset = require('../../featureset/tsJavaModule');

// It's not strictly necessary to call ensureJvm for each module -- once is sufficient.
// However, there is no harm in doing so.
hellojava.Java.ensureJvm()
  .then(() => reflection.Java.ensureJvm())
  .then(() => featureset.Java.ensureJvm())
  .then(() => {
      var classLoader = reflection.Java.getClassLoader();

  function verify(className: string) {
    assert.strictEqual(className, classLoader.loadClass(className).getName());
  }

  // A class that is declared in both modules
  verify('java.lang.String');

  // A class declared only in reflection
  verify('java.lang.reflect.Parameter');

  // A class declared only in hellojava
  verify('com.redseal.hellojava.HelloJava');
  });
