// tsJavaModule.ts
// This file was generated by ts-java.
/// <reference path="../typings/java/java.d.ts" />
/// <reference path="../typings/lodash/lodash.d.ts" />

// Generated using the following tsjava options:
// tsJavaModulePath:
//   tsJavaModule.ts
// classpath:
//   target/reflection-1.0.0.jar
// classes:
//   java.lang.Boolean
//   java.lang.Class
//   java.lang.ClassLoader
//   java.lang.Integer
//   java.lang.reflect.AccessibleObject
//   java.lang.reflect.Constructor
//   java.lang.reflect.Executable
//   java.lang.reflect.Field
//   java.lang.reflect.Method
//   java.lang.reflect.Modifier
//   java.lang.reflect.Parameter
//   java.lang.reflect.Type
// packages:
//   <none>

/* tslint:disable:max-line-length class-name */

declare function require(name: string): any;
require('source-map-support').install();

import _java = require('java');
import _ = require('lodash');
import BluePromise = require('bluebird');
import path = require('path');

_java.asyncOptions = {
    syncSuffix: '',
    asyncSuffix: 'A',
    promiseSuffix: 'P',
    promisify: BluePromise.promisify
};

// JVM initialization callback which adds tsjava.classpath to the JVM classpath.
function beforeJvm(): BluePromise<void> {
  var moduleJars: string[] = ['target/reflection-1.0.0.jar'];
  moduleJars.forEach((jarPath: string) => {
    var fullJarPath: string = path.join(__dirname, '', jarPath);
    _java.classpath.push(fullJarPath);
  });
  return BluePromise.resolve();
}

_java.registerClientP(beforeJvm);

export module Java {
  'use strict';

  interface StringDict {
    [index: string]: string;
  }

  export type NodeJavaAPI = typeof _java;

  export function getJava(): NodeJavaAPI {
    return _java;
  }

  export function ensureJvm(): Promise<void> {
    return _java.ensureJvm();
  }

  export function getClassLoader(): Java.java.lang.ClassLoader {
    return _java.getClassLoader();
  }

  // Return the fully qualified class path for a class name.
  // Returns undefined if the className is ambiguous or not present in the configured classes.
  export function fullyQualifiedName(className: string): string {
    var shortToLongMap: StringDict = {
      'Boolean': 'java.lang.Boolean',
      'Class': 'java.lang.Class',
      'ClassLoader': 'java.lang.ClassLoader',
      'Integer': 'java.lang.Integer',
      'Object': 'java.lang.Object',
      'AccessibleObject': 'java.lang.reflect.AccessibleObject',
      'Constructor': 'java.lang.reflect.Constructor',
      'Executable': 'java.lang.reflect.Executable',
      'Field': 'java.lang.reflect.Field',
      'Method': 'java.lang.reflect.Method',
      'Modifier': 'java.lang.reflect.Modifier',
      'Parameter': 'java.lang.reflect.Parameter',
      'Type': 'java.lang.reflect.Type',
      'String': 'java.lang.String'
    };
    return shortToLongMap[className];
  }

  export function importClass(className: 'Boolean'): Java.java.lang.Boolean.Static;
  export function importClass(className: 'Class'): Java.java.lang.Class.Static;
  export function importClass(className: 'ClassLoader'): Java.java.lang.ClassLoader.Static;
  export function importClass(className: 'Integer'): Java.java.lang.Integer.Static;
  export function importClass(className: 'Object'): Java.java.lang.Object.Static;
  export function importClass(className: 'AccessibleObject'): Java.java.lang.reflect.AccessibleObject.Static;
  export function importClass(className: 'Constructor'): Java.java.lang.reflect.Constructor.Static;
  export function importClass(className: 'Executable'): Java.java.lang.reflect.Executable.Static;
  export function importClass(className: 'Field'): Java.java.lang.reflect.Field.Static;
  export function importClass(className: 'Method'): Java.java.lang.reflect.Method.Static;
  export function importClass(className: 'Modifier'): Java.java.lang.reflect.Modifier.Static;
  export function importClass(className: 'Parameter'): Java.java.lang.reflect.Parameter.Static;
  export function importClass(className: 'Type'): Java.java.lang.reflect.Type.Static;
  export function importClass(className: 'String'): Java.java.lang.String.Static;
  export function importClass(className: 'java.lang.Boolean'): Java.java.lang.Boolean.Static;
  export function importClass(className: 'java.lang.Class'): Java.java.lang.Class.Static;
  export function importClass(className: 'java.lang.ClassLoader'): Java.java.lang.ClassLoader.Static;
  export function importClass(className: 'java.lang.Integer'): Java.java.lang.Integer.Static;
  export function importClass(className: 'java.lang.Object'): Java.java.lang.Object.Static;
  export function importClass(className: 'java.lang.reflect.AccessibleObject'): Java.java.lang.reflect.AccessibleObject.Static;
  export function importClass(className: 'java.lang.reflect.Constructor'): Java.java.lang.reflect.Constructor.Static;
  export function importClass(className: 'java.lang.reflect.Executable'): Java.java.lang.reflect.Executable.Static;
  export function importClass(className: 'java.lang.reflect.Field'): Java.java.lang.reflect.Field.Static;
  export function importClass(className: 'java.lang.reflect.Method'): Java.java.lang.reflect.Method.Static;
  export function importClass(className: 'java.lang.reflect.Modifier'): Java.java.lang.reflect.Modifier.Static;
  export function importClass(className: 'java.lang.reflect.Parameter'): Java.java.lang.reflect.Parameter.Static;
  export function importClass(className: 'java.lang.reflect.Type'): Java.java.lang.reflect.Type.Static;
  export function importClass(className: 'java.lang.String'): Java.java.lang.String.Static;
  export function importClass(className: string): any;
  export function importClass(className: string): any {
    var fullName: string = fullyQualifiedName(className) || className;
    return _java.import(fullName);
  }

  export function asInstanceOf(obj: any, className: 'Boolean'): Java.java.lang.Boolean;
  export function asInstanceOf(obj: any, className: 'Class'): Java.java.lang.Class;
  export function asInstanceOf(obj: any, className: 'ClassLoader'): Java.java.lang.ClassLoader;
  export function asInstanceOf(obj: any, className: 'Integer'): Java.java.lang.Integer;
  export function asInstanceOf(obj: any, className: 'Object'): Java.java.lang.Object;
  export function asInstanceOf(obj: any, className: 'AccessibleObject'): Java.java.lang.reflect.AccessibleObject;
  export function asInstanceOf(obj: any, className: 'Constructor'): Java.java.lang.reflect.Constructor;
  export function asInstanceOf(obj: any, className: 'Executable'): Java.java.lang.reflect.Executable;
  export function asInstanceOf(obj: any, className: 'Field'): Java.java.lang.reflect.Field;
  export function asInstanceOf(obj: any, className: 'Method'): Java.java.lang.reflect.Method;
  export function asInstanceOf(obj: any, className: 'Modifier'): Java.java.lang.reflect.Modifier;
  export function asInstanceOf(obj: any, className: 'Parameter'): Java.java.lang.reflect.Parameter;
  export function asInstanceOf(obj: any, className: 'Type'): Java.java.lang.reflect.Type;
  export function asInstanceOf(obj: any, className: 'String'): Java.java.lang.String;
  export function asInstanceOf(obj: any, className: 'java.lang.Boolean'): Java.java.lang.Boolean;
  export function asInstanceOf(obj: any, className: 'java.lang.Class'): Java.java.lang.Class;
  export function asInstanceOf(obj: any, className: 'java.lang.ClassLoader'): Java.java.lang.ClassLoader;
  export function asInstanceOf(obj: any, className: 'java.lang.Integer'): Java.java.lang.Integer;
  export function asInstanceOf(obj: any, className: 'java.lang.Object'): Java.java.lang.Object;
  export function asInstanceOf(obj: any, className: 'java.lang.reflect.AccessibleObject'): Java.java.lang.reflect.AccessibleObject;
  export function asInstanceOf(obj: any, className: 'java.lang.reflect.Constructor'): Java.java.lang.reflect.Constructor;
  export function asInstanceOf(obj: any, className: 'java.lang.reflect.Executable'): Java.java.lang.reflect.Executable;
  export function asInstanceOf(obj: any, className: 'java.lang.reflect.Field'): Java.java.lang.reflect.Field;
  export function asInstanceOf(obj: any, className: 'java.lang.reflect.Method'): Java.java.lang.reflect.Method;
  export function asInstanceOf(obj: any, className: 'java.lang.reflect.Modifier'): Java.java.lang.reflect.Modifier;
  export function asInstanceOf(obj: any, className: 'java.lang.reflect.Parameter'): Java.java.lang.reflect.Parameter;
  export function asInstanceOf(obj: any, className: 'java.lang.reflect.Type'): Java.java.lang.reflect.Type;
  export function asInstanceOf(obj: any, className: 'java.lang.String'): Java.java.lang.String;
  export function asInstanceOf(obj: any, className: string): any;
  export function asInstanceOf(obj: any, className: string): any {
    var fullName: string = fullyQualifiedName(className) || className;
    if (_java.instanceOf(obj, fullName)) {
      return obj;
    } else {
      throw new Error('asInstanceOf fails, obj is not a ' + fullName);
    }
  }

  export interface Callback<T> {
    (err?: Error, result?: T): void;
  }

  // Returns true if javaObject is an instance of the named class, which may be a short className.
  // Returns false if javaObject is not an instance of the named class.
  // Throws an exception if the named class does not exist, or is an ambiguous short name.
  export function instanceOf(javaObject: any, className: string): boolean {
    var fullName: string = fullyQualifiedName(className) || className;
    return smellsLikeJavaObject(javaObject) && _java.instanceOf(javaObject, fullName);
  }






  export function newInstanceA(className: 'Boolean', arg0: string_t, cb: Callback<boolean>): void;
  export function newInstanceA(className: 'Boolean', arg0: boolean_t, cb: Callback<boolean>): void;
  export function newInstanceA(className: 'Integer', arg0: string_t, cb: Callback<number>): void;
  export function newInstanceA(className: 'Integer', arg0: integer_t, cb: Callback<number>): void;
  export function newInstanceA(className: 'Object', cb: Callback<object_t>): void;
  export function newInstanceA(className: 'Modifier', cb: Callback<Java.Modifier>): void;
  export function newInstanceA(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: object_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: string_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: integer_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'String', arg0: array_t<integer_t>, arg1: integer_t, arg2: integer_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'String', arg0: object_array_t, arg1: object_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'String', arg0: object_array_t, arg1: string_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'String', arg0: object_array_t, arg1: integer_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'String', arg0: object_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'String', arg0: object_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'String', arg0: string_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'String', arg0: object_array_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'String', arg0: object_array_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'String', cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.Boolean', arg0: string_t, cb: Callback<boolean>): void;
  export function newInstanceA(className: 'java.lang.Boolean', arg0: boolean_t, cb: Callback<boolean>): void;
  export function newInstanceA(className: 'java.lang.Integer', arg0: string_t, cb: Callback<number>): void;
  export function newInstanceA(className: 'java.lang.Integer', arg0: integer_t, cb: Callback<number>): void;
  export function newInstanceA(className: 'java.lang.Object', cb: Callback<object_t>): void;
  export function newInstanceA(className: 'java.lang.reflect.Modifier', cb: Callback<Java.Modifier>): void;
  export function newInstanceA(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: object_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: string_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: integer_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.String', arg0: array_t<integer_t>, arg1: integer_t, arg2: integer_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.String', arg0: object_array_t, arg1: object_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.String', arg0: object_array_t, arg1: string_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.String', arg0: object_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.String', arg0: object_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.String', arg0: string_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.String', arg0: object_array_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.String', arg0: object_array_t, cb: Callback<string>): void;
  export function newInstanceA(className: 'java.lang.String', cb: Callback<string>): void;
  export function newInstanceA(className: string, ...args: any[]): void;
  export function newInstanceA(className: string, ...args: any[]): any {
    var fullName: string = fullyQualifiedName(className) || className;
    args.unshift(fullName);
    return _java.newInstance.apply(_java, args);
  }

  export function newInstance(className: 'Boolean', arg0: string_t): boolean;
  export function newInstance(className: 'Boolean', arg0: boolean_t): boolean;
  export function newInstance(className: 'Integer', arg0: string_t): number;
  export function newInstance(className: 'Integer', arg0: integer_t): number;
  export function newInstance(className: 'Object'): object_t;
  export function newInstance(className: 'Modifier'): Java.Modifier;
  export function newInstance(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: object_t): string;
  export function newInstance(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: string_t): string;
  export function newInstance(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: integer_t): string;
  export function newInstance(className: 'String', arg0: array_t<integer_t>, arg1: integer_t, arg2: integer_t): string;
  export function newInstance(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t): string;
  export function newInstance(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t): string;
  export function newInstance(className: 'String', arg0: object_array_t, arg1: object_t): string;
  export function newInstance(className: 'String', arg0: object_array_t, arg1: string_t): string;
  export function newInstance(className: 'String', arg0: object_array_t, arg1: integer_t): string;
  export function newInstance(className: 'String', arg0: object_t): string;
  export function newInstance(className: 'String', arg0: object_t): string;
  export function newInstance(className: 'String', arg0: string_t): string;
  export function newInstance(className: 'String', arg0: object_array_t): string;
  export function newInstance(className: 'String', arg0: object_array_t): string;
  export function newInstance(className: 'String'): string;
  export function newInstance(className: 'java.lang.Boolean', arg0: string_t): boolean;
  export function newInstance(className: 'java.lang.Boolean', arg0: boolean_t): boolean;
  export function newInstance(className: 'java.lang.Integer', arg0: string_t): number;
  export function newInstance(className: 'java.lang.Integer', arg0: integer_t): number;
  export function newInstance(className: 'java.lang.Object'): object_t;
  export function newInstance(className: 'java.lang.reflect.Modifier'): Java.Modifier;
  export function newInstance(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: object_t): string;
  export function newInstance(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: string_t): string;
  export function newInstance(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: integer_t): string;
  export function newInstance(className: 'java.lang.String', arg0: array_t<integer_t>, arg1: integer_t, arg2: integer_t): string;
  export function newInstance(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t): string;
  export function newInstance(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t): string;
  export function newInstance(className: 'java.lang.String', arg0: object_array_t, arg1: object_t): string;
  export function newInstance(className: 'java.lang.String', arg0: object_array_t, arg1: string_t): string;
  export function newInstance(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t): string;
  export function newInstance(className: 'java.lang.String', arg0: object_t): string;
  export function newInstance(className: 'java.lang.String', arg0: object_t): string;
  export function newInstance(className: 'java.lang.String', arg0: string_t): string;
  export function newInstance(className: 'java.lang.String', arg0: object_array_t): string;
  export function newInstance(className: 'java.lang.String', arg0: object_array_t): string;
  export function newInstance(className: 'java.lang.String'): string;
  export function newInstance(className: string, ...args: any[]): any;
  export function newInstance(className: string, ...args: any[]): any {
    var fullName: string = fullyQualifiedName(className) || className;
    args.unshift(fullName);
    return _java.newInstanceSync.apply(_java, args);
  }

  export function newInstanceP(className: 'Boolean', arg0: string_t): Promise<boolean>;
  export function newInstanceP(className: 'Boolean', arg0: boolean_t): Promise<boolean>;
  export function newInstanceP(className: 'Integer', arg0: string_t): Promise<number>;
  export function newInstanceP(className: 'Integer', arg0: integer_t): Promise<number>;
  export function newInstanceP(className: 'Object'): Promise<object_t>;
  export function newInstanceP(className: 'Modifier'): Promise<Java.Modifier>;
  export function newInstanceP(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: object_t): Promise<string>;
  export function newInstanceP(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: string_t): Promise<string>;
  export function newInstanceP(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: integer_t): Promise<string>;
  export function newInstanceP(className: 'String', arg0: array_t<integer_t>, arg1: integer_t, arg2: integer_t): Promise<string>;
  export function newInstanceP(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t): Promise<string>;
  export function newInstanceP(className: 'String', arg0: object_array_t, arg1: integer_t, arg2: integer_t): Promise<string>;
  export function newInstanceP(className: 'String', arg0: object_array_t, arg1: object_t): Promise<string>;
  export function newInstanceP(className: 'String', arg0: object_array_t, arg1: string_t): Promise<string>;
  export function newInstanceP(className: 'String', arg0: object_array_t, arg1: integer_t): Promise<string>;
  export function newInstanceP(className: 'String', arg0: object_t): Promise<string>;
  export function newInstanceP(className: 'String', arg0: object_t): Promise<string>;
  export function newInstanceP(className: 'String', arg0: string_t): Promise<string>;
  export function newInstanceP(className: 'String', arg0: object_array_t): Promise<string>;
  export function newInstanceP(className: 'String', arg0: object_array_t): Promise<string>;
  export function newInstanceP(className: 'String'): Promise<string>;
  export function newInstanceP(className: 'java.lang.Boolean', arg0: string_t): Promise<boolean>;
  export function newInstanceP(className: 'java.lang.Boolean', arg0: boolean_t): Promise<boolean>;
  export function newInstanceP(className: 'java.lang.Integer', arg0: string_t): Promise<number>;
  export function newInstanceP(className: 'java.lang.Integer', arg0: integer_t): Promise<number>;
  export function newInstanceP(className: 'java.lang.Object'): Promise<object_t>;
  export function newInstanceP(className: 'java.lang.reflect.Modifier'): Promise<Java.Modifier>;
  export function newInstanceP(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: object_t): Promise<string>;
  export function newInstanceP(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: string_t): Promise<string>;
  export function newInstanceP(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: integer_t): Promise<string>;
  export function newInstanceP(className: 'java.lang.String', arg0: array_t<integer_t>, arg1: integer_t, arg2: integer_t): Promise<string>;
  export function newInstanceP(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t): Promise<string>;
  export function newInstanceP(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t, arg2: integer_t): Promise<string>;
  export function newInstanceP(className: 'java.lang.String', arg0: object_array_t, arg1: object_t): Promise<string>;
  export function newInstanceP(className: 'java.lang.String', arg0: object_array_t, arg1: string_t): Promise<string>;
  export function newInstanceP(className: 'java.lang.String', arg0: object_array_t, arg1: integer_t): Promise<string>;
  export function newInstanceP(className: 'java.lang.String', arg0: object_t): Promise<string>;
  export function newInstanceP(className: 'java.lang.String', arg0: object_t): Promise<string>;
  export function newInstanceP(className: 'java.lang.String', arg0: string_t): Promise<string>;
  export function newInstanceP(className: 'java.lang.String', arg0: object_array_t): Promise<string>;
  export function newInstanceP(className: 'java.lang.String', arg0: object_array_t): Promise<string>;
  export function newInstanceP(className: 'java.lang.String'): Promise<string>;
  export function newInstanceP(className: string, ...args: any[]): Promise<any>;
  export function newInstanceP(className: string, ...args: any[]): Promise<any> {
    var fullName: string = fullyQualifiedName(className) || className;
    args.unshift(fullName);
    return _java.newInstanceP.apply(_java, args);
  }

  export function newArray(className: 'Boolean', arg: boolean_t[]): array_t<java.lang.Boolean>;
  export function newArray(className: 'Class', arg: Java.Class[]): array_t<java.lang.Class>;
  export function newArray(className: 'ClassLoader', arg: Java.ClassLoader[]): array_t<java.lang.ClassLoader>;
  export function newArray(className: 'Integer', arg: integer_t[]): array_t<java.lang.Integer>;
  export function newArray(className: 'Object', arg: object_t[]): array_t<java.lang.Object>;
  export function newArray(className: 'AccessibleObject', arg: Java.AccessibleObject[]): array_t<java.lang.reflect.AccessibleObject>;
  export function newArray(className: 'Constructor', arg: Java.Constructor[]): array_t<java.lang.reflect.Constructor>;
  export function newArray(className: 'Executable', arg: Java.Executable[]): array_t<java.lang.reflect.Executable>;
  export function newArray(className: 'Field', arg: Java.Field[]): array_t<java.lang.reflect.Field>;
  export function newArray(className: 'Method', arg: Java.Method[]): array_t<java.lang.reflect.Method>;
  export function newArray(className: 'Modifier', arg: Java.Modifier[]): array_t<java.lang.reflect.Modifier>;
  export function newArray(className: 'Parameter', arg: Java.Parameter[]): array_t<java.lang.reflect.Parameter>;
  export function newArray(className: 'Type', arg: Java.Type[]): array_t<java.lang.reflect.Type>;
  export function newArray(className: 'String', arg: string_t[]): array_t<java.lang.String>;
  export function newArray(className: 'java.lang.Boolean', arg: boolean_t[]): array_t<java.lang.Boolean>;
  export function newArray(className: 'java.lang.Class', arg: Java.Class[]): array_t<java.lang.Class>;
  export function newArray(className: 'java.lang.ClassLoader', arg: Java.ClassLoader[]): array_t<java.lang.ClassLoader>;
  export function newArray(className: 'java.lang.Integer', arg: integer_t[]): array_t<java.lang.Integer>;
  export function newArray(className: 'java.lang.Object', arg: object_t[]): array_t<java.lang.Object>;
  export function newArray(className: 'java.lang.reflect.AccessibleObject', arg: Java.AccessibleObject[]): array_t<java.lang.reflect.AccessibleObject>;
  export function newArray(className: 'java.lang.reflect.Constructor', arg: Java.Constructor[]): array_t<java.lang.reflect.Constructor>;
  export function newArray(className: 'java.lang.reflect.Executable', arg: Java.Executable[]): array_t<java.lang.reflect.Executable>;
  export function newArray(className: 'java.lang.reflect.Field', arg: Java.Field[]): array_t<java.lang.reflect.Field>;
  export function newArray(className: 'java.lang.reflect.Method', arg: Java.Method[]): array_t<java.lang.reflect.Method>;
  export function newArray(className: 'java.lang.reflect.Modifier', arg: Java.Modifier[]): array_t<java.lang.reflect.Modifier>;
  export function newArray(className: 'java.lang.reflect.Parameter', arg: Java.Parameter[]): array_t<java.lang.reflect.Parameter>;
  export function newArray(className: 'java.lang.reflect.Type', arg: Java.Type[]): array_t<java.lang.reflect.Type>;
  export function newArray(className: 'java.lang.String', arg: string_t[]): array_t<java.lang.String>;
  export function newArray<T>(className: string, arg: any[]): array_t<T>;
  export function newArray<T>(className: string, arg: any[]): array_t<T> {
    var fullName: string = fullyQualifiedName(className) || className;
    return _java.newArray(fullName, arg);
  }

  // export module Java {

  // Node-java has special handling for methods that return long or java.lang.Long,
  // returning a Javascript Number but with an additional property longValue.
  export interface longValue_t extends Number {
    longValue: string;
  }

  // Node-java can automatically coerce a javascript string into a java.lang.String.
  // This special type alias allows to declare that possiblity to Typescript.
  export type string_t = string | Java.java.lang.String;

  // Java methods that take java.lang.Object parameters implicitly will take a java.lang.String.
  // But string_t is not sufficient for this case, we need object_t.
  export type object_t = Java.java.lang.Object | string | boolean | number | longValue_t;

  // Java methods that take long or java.lang.Long parameters may take javascript numbers,
  // longValue_t (see above) or java.lang.Long.
  // This special type alias allows to declare that possiblity to Typescript.
  export type long_t = number | longValue_t ;

  // Handling of other primitive numeric types is simpler, as there is no loss of precision.
  export type boolean_t = boolean | Java.java.lang.Boolean;
  export type short_t = number ;
  export type integer_t = number | Java.java.lang.Integer;
  export type double_t = number ;
  export type float_t = number ;
  export type number_t = number ;

  export interface array_t<T> extends Java.java.lang.Object {
    // This is an opaque type for a java array_t T[];
    // Use Java.newArray<T>(className, [...]) to create wherever a Java method expects a T[],
    // most notably for vararg parameteters.
    __dummy: T;
  }

  export type object_array_t = array_t<Java.java.lang.Object> | object_t[];

  export import Boolean = java.lang.Boolean;
  export import Class = java.lang.Class;
  export import ClassLoader = java.lang.ClassLoader;
  export import Integer = java.lang.Integer;
  export import Object = java.lang.Object;
  export import AccessibleObject = java.lang.reflect.AccessibleObject;
  export import Constructor = java.lang.reflect.Constructor;
  export import Executable = java.lang.reflect.Executable;
  export import Field = java.lang.reflect.Field;
  export import Method = java.lang.reflect.Method;
  export import Modifier = java.lang.reflect.Modifier;
  export import Parameter = java.lang.reflect.Parameter;
  export import Type = java.lang.reflect.Type;
  export import String = java.lang.String;

  export module java.lang {
    export interface Boolean extends Java.java.lang.Object {
      // public boolean java.lang.Boolean.booleanValue()
      booleanValueA( cb: Callback<boolean>): void;
      booleanValue(): boolean;
      booleanValueP(): Promise<boolean>;
      // public int java.lang.Boolean.compareTo(java.lang.Boolean)
      compareToA(arg0: boolean_t, cb: Callback<number>): void;
      compareTo(arg0: boolean_t): number;
      compareToP(arg0: boolean_t): Promise<number>;
      // public int java.lang.Boolean.compareTo(java.lang.Object)
      compareToA(arg0: object_t, cb: Callback<number>): void;
      compareTo(arg0: object_t): number;
      compareToP(arg0: object_t): Promise<number>;
      // public boolean java.lang.Object.equals(java.lang.Object)
      equalsA(arg0: object_t, cb: Callback<boolean>): void;
      equals(arg0: object_t): boolean;
      equalsP(arg0: object_t): Promise<boolean>;
      // public final native java.lang.Class<?> java.lang.Object.getClass()
      getClassA( cb: Callback<Java.Class>): void;
      getClass(): Java.Class;
      getClassP(): Promise<Java.Class>;
      // public native int java.lang.Object.hashCode()
      hashCodeA( cb: Callback<number>): void;
      hashCode(): number;
      hashCodeP(): Promise<number>;
      // public final native void java.lang.Object.notify()
      notifyA( cb: Callback<void>): void;
      notify(): void;
      notifyP(): Promise<void>;
      // public final native void java.lang.Object.notifyAll()
      notifyAllA( cb: Callback<void>): void;
      notifyAll(): void;
      notifyAllP(): Promise<void>;
      // public java.lang.String java.lang.Object.toString()
      toStringA( cb: Callback<string>): void;
      toString(): string;
      toStringP(): Promise<string>;
      // public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException
      waitA(arg0: object_t, arg1: integer_t, cb: Callback<void>): void;
      wait(arg0: object_t, arg1: integer_t): void;
      waitP(arg0: object_t, arg1: integer_t): Promise<void>;
      // public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException
      waitA(arg0: object_t, cb: Callback<void>): void;
      wait(arg0: object_t): void;
      waitP(arg0: object_t): Promise<void>;
      // public final void java.lang.Object.wait() throws java.lang.InterruptedException
      waitA( cb: Callback<void>): void;
      wait(): void;
      waitP(): Promise<void>;
    }
    export module Boolean {
      export interface Static {
        TRUE: boolean;
        FALSE: boolean;
        TYPE: Java.Class;
        class: Java.Class;
        new (arg0: string_t): java.lang.Boolean;
        new (arg0: boolean_t): java.lang.Boolean;
        // public static int java.lang.Boolean.compare(boolean,boolean)
        compareA(arg0: boolean_t, arg1: boolean_t, cb: Callback<number>): void;
        compare(arg0: boolean_t, arg1: boolean_t): number;
        compareP(arg0: boolean_t, arg1: boolean_t): Promise<number>;
        // public static boolean java.lang.Boolean.getBoolean(java.lang.String)
        getBooleanA(arg0: string_t, cb: Callback<boolean>): void;
        getBoolean(arg0: string_t): boolean;
        getBooleanP(arg0: string_t): Promise<boolean>;
        // public static int java.lang.Boolean.hashCode(boolean)
        hashCodeA(arg0: boolean_t, cb: Callback<number>): void;
        hashCode(arg0: boolean_t): number;
        hashCodeP(arg0: boolean_t): Promise<number>;
        // public static boolean java.lang.Boolean.logicalAnd(boolean,boolean)
        logicalAndA(arg0: boolean_t, arg1: boolean_t, cb: Callback<boolean>): void;
        logicalAnd(arg0: boolean_t, arg1: boolean_t): boolean;
        logicalAndP(arg0: boolean_t, arg1: boolean_t): Promise<boolean>;
        // public static boolean java.lang.Boolean.logicalOr(boolean,boolean)
        logicalOrA(arg0: boolean_t, arg1: boolean_t, cb: Callback<boolean>): void;
        logicalOr(arg0: boolean_t, arg1: boolean_t): boolean;
        logicalOrP(arg0: boolean_t, arg1: boolean_t): Promise<boolean>;
        // public static boolean java.lang.Boolean.logicalXor(boolean,boolean)
        logicalXorA(arg0: boolean_t, arg1: boolean_t, cb: Callback<boolean>): void;
        logicalXor(arg0: boolean_t, arg1: boolean_t): boolean;
        logicalXorP(arg0: boolean_t, arg1: boolean_t): Promise<boolean>;
        // public static boolean java.lang.Boolean.parseBoolean(java.lang.String)
        parseBooleanA(arg0: string_t, cb: Callback<boolean>): void;
        parseBoolean(arg0: string_t): boolean;
        parseBooleanP(arg0: string_t): Promise<boolean>;
        // public static java.lang.String java.lang.Boolean.toString(boolean)
        toStringA(arg0: boolean_t, cb: Callback<string>): void;
        toString(arg0: boolean_t): string;
        toStringP(arg0: boolean_t): Promise<string>;
        // public static java.lang.Boolean java.lang.Boolean.valueOf(java.lang.String)
        valueOfA(arg0: string_t, cb: Callback<boolean>): void;
        valueOf(arg0: string_t): boolean;
        valueOfP(arg0: string_t): Promise<boolean>;
        // public static java.lang.Boolean java.lang.Boolean.valueOf(boolean)
        valueOfA(arg0: boolean_t, cb: Callback<boolean>): void;
        valueOf(arg0: boolean_t): boolean;
        valueOfP(arg0: boolean_t): Promise<boolean>;
      }
    }
  }

  export module java.lang {
    export interface Class extends Java.java.lang.Object, Java.java.lang.reflect.Type {
      // public <U> java.lang.Class<? extends U> java.lang.Class.asSubclass(java.lang.Class<U>)
      asSubclassA(arg0: Java.Class, cb: Callback<Java.Class>): void;
      asSubclass(arg0: Java.Class): Java.Class;
      asSubclassP(arg0: Java.Class): Promise<Java.Class>;
      // public T java.lang.Class.cast(java.lang.Object)
      castA(arg0: object_t, cb: Callback<object_t>): void;
      cast(arg0: object_t): object_t;
      castP(arg0: object_t): Promise<object_t>;
      // public boolean java.lang.Class.desiredAssertionStatus()
      desiredAssertionStatusA( cb: Callback<boolean>): void;
      desiredAssertionStatus(): boolean;
      desiredAssertionStatusP(): Promise<boolean>;
      // public boolean java.lang.Object.equals(java.lang.Object)
      equalsA(arg0: object_t, cb: Callback<boolean>): void;
      equals(arg0: object_t): boolean;
      equalsP(arg0: object_t): Promise<boolean>;
      // public java.lang.reflect.AnnotatedType[] java.lang.Class.getAnnotatedInterfaces()
      getAnnotatedInterfacesA( cb: Callback<object_t[]>): void;
      getAnnotatedInterfaces(): object_t[];
      getAnnotatedInterfacesP(): Promise<object_t[]>;
      // public java.lang.reflect.AnnotatedType java.lang.Class.getAnnotatedSuperclass()
      getAnnotatedSuperclassA( cb: Callback<object_t>): void;
      getAnnotatedSuperclass(): object_t;
      getAnnotatedSuperclassP(): Promise<object_t>;
      // public <A> A java.lang.Class.getAnnotation(java.lang.Class<A>)
      getAnnotationA(arg0: Java.Class, cb: Callback<object_t>): void;
      getAnnotation(arg0: Java.Class): object_t;
      getAnnotationP(arg0: Java.Class): Promise<object_t>;
      // public java.lang.annotation.Annotation[] java.lang.Class.getAnnotations()
      getAnnotationsA( cb: Callback<object_t[]>): void;
      getAnnotations(): object_t[];
      getAnnotationsP(): Promise<object_t[]>;
      // public <A> A[] java.lang.Class.getAnnotationsByType(java.lang.Class<A>)
      getAnnotationsByTypeA(arg0: Java.Class, cb: Callback<object_t[]>): void;
      getAnnotationsByType(arg0: Java.Class): object_t[];
      getAnnotationsByTypeP(arg0: Java.Class): Promise<object_t[]>;
      // public java.lang.String java.lang.Class.getCanonicalName()
      getCanonicalNameA( cb: Callback<string>): void;
      getCanonicalName(): string;
      getCanonicalNameP(): Promise<string>;
      // public final native java.lang.Class<?> java.lang.Object.getClass()
      getClassA( cb: Callback<Java.Class>): void;
      getClass(): Java.Class;
      getClassP(): Promise<Java.Class>;
      // public java.lang.Class<?>[] java.lang.Class.getClasses()
      getClassesA( cb: Callback<Java.Class[]>): void;
      getClasses(): Java.Class[];
      getClassesP(): Promise<Java.Class[]>;
      // public java.lang.ClassLoader java.lang.Class.getClassLoader()
      getClassLoaderA( cb: Callback<Java.ClassLoader>): void;
      getClassLoader(): Java.ClassLoader;
      getClassLoaderP(): Promise<Java.ClassLoader>;
      // public native java.lang.Class<?> java.lang.Class.getComponentType()
      getComponentTypeA( cb: Callback<Java.Class>): void;
      getComponentType(): Java.Class;
      getComponentTypeP(): Promise<Java.Class>;
      // public java.lang.reflect.Constructor<T> java.lang.Class.getConstructor(java.lang.Class<?>...) throws java.lang.NoSuchMethodException,java.lang.SecurityException
      getConstructorA(arg0: array_t<Java.Class>, cb: Callback<Java.Constructor>): void;
      getConstructor(...arg0: Java.Class[]): Java.Constructor;
      getConstructor(arg0: array_t<Java.Class>): Java.Constructor;
      getConstructorP(...arg0: Java.Class[]): Promise<Java.Constructor>;
      getConstructorP(arg0: array_t<Java.Class>): Promise<Java.Constructor>;
      // public java.lang.reflect.Constructor<?>[] java.lang.Class.getConstructors() throws java.lang.SecurityException
      getConstructorsA( cb: Callback<Java.Constructor[]>): void;
      getConstructors(): Java.Constructor[];
      getConstructorsP(): Promise<Java.Constructor[]>;
      // public <A> A java.lang.Class.getDeclaredAnnotation(java.lang.Class<A>)
      getDeclaredAnnotationA(arg0: Java.Class, cb: Callback<object_t>): void;
      getDeclaredAnnotation(arg0: Java.Class): object_t;
      getDeclaredAnnotationP(arg0: Java.Class): Promise<object_t>;
      // public java.lang.annotation.Annotation[] java.lang.Class.getDeclaredAnnotations()
      getDeclaredAnnotationsA( cb: Callback<object_t[]>): void;
      getDeclaredAnnotations(): object_t[];
      getDeclaredAnnotationsP(): Promise<object_t[]>;
      // public <A> A[] java.lang.Class.getDeclaredAnnotationsByType(java.lang.Class<A>)
      getDeclaredAnnotationsByTypeA(arg0: Java.Class, cb: Callback<object_t[]>): void;
      getDeclaredAnnotationsByType(arg0: Java.Class): object_t[];
      getDeclaredAnnotationsByTypeP(arg0: Java.Class): Promise<object_t[]>;
      // public java.lang.Class<?>[] java.lang.Class.getDeclaredClasses() throws java.lang.SecurityException
      getDeclaredClassesA( cb: Callback<Java.Class[]>): void;
      getDeclaredClasses(): Java.Class[];
      getDeclaredClassesP(): Promise<Java.Class[]>;
      // public java.lang.reflect.Constructor<T> java.lang.Class.getDeclaredConstructor(java.lang.Class<?>...) throws java.lang.NoSuchMethodException,java.lang.SecurityException
      getDeclaredConstructorA(arg0: array_t<Java.Class>, cb: Callback<Java.Constructor>): void;
      getDeclaredConstructor(...arg0: Java.Class[]): Java.Constructor;
      getDeclaredConstructor(arg0: array_t<Java.Class>): Java.Constructor;
      getDeclaredConstructorP(...arg0: Java.Class[]): Promise<Java.Constructor>;
      getDeclaredConstructorP(arg0: array_t<Java.Class>): Promise<Java.Constructor>;
      // public java.lang.reflect.Constructor<?>[] java.lang.Class.getDeclaredConstructors() throws java.lang.SecurityException
      getDeclaredConstructorsA( cb: Callback<Java.Constructor[]>): void;
      getDeclaredConstructors(): Java.Constructor[];
      getDeclaredConstructorsP(): Promise<Java.Constructor[]>;
      // public java.lang.reflect.Field java.lang.Class.getDeclaredField(java.lang.String) throws java.lang.NoSuchFieldException,java.lang.SecurityException
      getDeclaredFieldA(arg0: string_t, cb: Callback<Java.Field>): void;
      getDeclaredField(arg0: string_t): Java.Field;
      getDeclaredFieldP(arg0: string_t): Promise<Java.Field>;
      // public java.lang.reflect.Field[] java.lang.Class.getDeclaredFields() throws java.lang.SecurityException
      getDeclaredFieldsA( cb: Callback<Java.Field[]>): void;
      getDeclaredFields(): Java.Field[];
      getDeclaredFieldsP(): Promise<Java.Field[]>;
      // public java.lang.reflect.Method java.lang.Class.getDeclaredMethod(java.lang.String,java.lang.Class<?>...) throws java.lang.NoSuchMethodException,java.lang.SecurityException
      getDeclaredMethodA(arg0: string_t, arg1: array_t<Java.Class>, cb: Callback<Java.Method>): void;
      getDeclaredMethod(arg0: string_t, ...arg1: Java.Class[]): Java.Method;
      getDeclaredMethod(arg0: string_t, arg1: array_t<Java.Class>): Java.Method;
      getDeclaredMethodP(arg0: string_t, ...arg1: Java.Class[]): Promise<Java.Method>;
      getDeclaredMethodP(arg0: string_t, arg1: array_t<Java.Class>): Promise<Java.Method>;
      // public java.lang.reflect.Method[] java.lang.Class.getDeclaredMethods() throws java.lang.SecurityException
      getDeclaredMethodsA( cb: Callback<Java.Method[]>): void;
      getDeclaredMethods(): Java.Method[];
      getDeclaredMethodsP(): Promise<Java.Method[]>;
      // public java.lang.Class<?> java.lang.Class.getDeclaringClass() throws java.lang.SecurityException
      getDeclaringClassA( cb: Callback<Java.Class>): void;
      getDeclaringClass(): Java.Class;
      getDeclaringClassP(): Promise<Java.Class>;
      // public java.lang.Class<?> java.lang.Class.getEnclosingClass() throws java.lang.SecurityException
      getEnclosingClassA( cb: Callback<Java.Class>): void;
      getEnclosingClass(): Java.Class;
      getEnclosingClassP(): Promise<Java.Class>;
      // public java.lang.reflect.Constructor<?> java.lang.Class.getEnclosingConstructor() throws java.lang.SecurityException
      getEnclosingConstructorA( cb: Callback<Java.Constructor>): void;
      getEnclosingConstructor(): Java.Constructor;
      getEnclosingConstructorP(): Promise<Java.Constructor>;
      // public java.lang.reflect.Method java.lang.Class.getEnclosingMethod() throws java.lang.SecurityException
      getEnclosingMethodA( cb: Callback<Java.Method>): void;
      getEnclosingMethod(): Java.Method;
      getEnclosingMethodP(): Promise<Java.Method>;
      // public T[] java.lang.Class.getEnumConstants()
      getEnumConstantsA( cb: Callback<object_t[]>): void;
      getEnumConstants(): object_t[];
      getEnumConstantsP(): Promise<object_t[]>;
      // public java.lang.reflect.Field java.lang.Class.getField(java.lang.String) throws java.lang.NoSuchFieldException,java.lang.SecurityException
      getFieldA(arg0: string_t, cb: Callback<Java.Field>): void;
      getField(arg0: string_t): Java.Field;
      getFieldP(arg0: string_t): Promise<Java.Field>;
      // public java.lang.reflect.Field[] java.lang.Class.getFields() throws java.lang.SecurityException
      getFieldsA( cb: Callback<Java.Field[]>): void;
      getFields(): Java.Field[];
      getFieldsP(): Promise<Java.Field[]>;
      // public java.lang.reflect.Type[] java.lang.Class.getGenericInterfaces()
      getGenericInterfacesA( cb: Callback<Java.Type[]>): void;
      getGenericInterfaces(): Java.Type[];
      getGenericInterfacesP(): Promise<Java.Type[]>;
      // public java.lang.reflect.Type java.lang.Class.getGenericSuperclass()
      getGenericSuperclassA( cb: Callback<Java.Type>): void;
      getGenericSuperclass(): Java.Type;
      getGenericSuperclassP(): Promise<Java.Type>;
      // public java.lang.Class<?>[] java.lang.Class.getInterfaces()
      getInterfacesA( cb: Callback<Java.Class[]>): void;
      getInterfaces(): Java.Class[];
      getInterfacesP(): Promise<Java.Class[]>;
      // public java.lang.reflect.Method java.lang.Class.getMethod(java.lang.String,java.lang.Class<?>...) throws java.lang.NoSuchMethodException,java.lang.SecurityException
      getMethodA(arg0: string_t, arg1: array_t<Java.Class>, cb: Callback<Java.Method>): void;
      getMethod(arg0: string_t, ...arg1: Java.Class[]): Java.Method;
      getMethod(arg0: string_t, arg1: array_t<Java.Class>): Java.Method;
      getMethodP(arg0: string_t, ...arg1: Java.Class[]): Promise<Java.Method>;
      getMethodP(arg0: string_t, arg1: array_t<Java.Class>): Promise<Java.Method>;
      // public java.lang.reflect.Method[] java.lang.Class.getMethods() throws java.lang.SecurityException
      getMethodsA( cb: Callback<Java.Method[]>): void;
      getMethods(): Java.Method[];
      getMethodsP(): Promise<Java.Method[]>;
      // public native int java.lang.Class.getModifiers()
      getModifiersA( cb: Callback<number>): void;
      getModifiers(): number;
      getModifiersP(): Promise<number>;
      // public java.lang.String java.lang.Class.getName()
      getNameA( cb: Callback<string>): void;
      getName(): string;
      getNameP(): Promise<string>;
      // public java.lang.Package java.lang.Class.getPackage()
      getPackageA( cb: Callback<object_t>): void;
      getPackage(): object_t;
      getPackageP(): Promise<object_t>;
      // public java.security.ProtectionDomain java.lang.Class.getProtectionDomain()
      getProtectionDomainA( cb: Callback<object_t>): void;
      getProtectionDomain(): object_t;
      getProtectionDomainP(): Promise<object_t>;
      // public java.net.URL java.lang.Class.getResource(java.lang.String)
      getResourceA(arg0: string_t, cb: Callback<object_t>): void;
      getResource(arg0: string_t): object_t;
      getResourceP(arg0: string_t): Promise<object_t>;
      // public java.io.InputStream java.lang.Class.getResourceAsStream(java.lang.String)
      getResourceAsStreamA(arg0: string_t, cb: Callback<object_t>): void;
      getResourceAsStream(arg0: string_t): object_t;
      getResourceAsStreamP(arg0: string_t): Promise<object_t>;
      // public native java.lang.Object[] java.lang.Class.getSigners()
      getSignersA( cb: Callback<object_t[]>): void;
      getSigners(): object_t[];
      getSignersP(): Promise<object_t[]>;
      // public java.lang.String java.lang.Class.getSimpleName()
      getSimpleNameA( cb: Callback<string>): void;
      getSimpleName(): string;
      getSimpleNameP(): Promise<string>;
      // public native java.lang.Class<? super T> java.lang.Class.getSuperclass()
      getSuperclassA( cb: Callback<Java.Class>): void;
      getSuperclass(): Java.Class;
      getSuperclassP(): Promise<Java.Class>;
      // public default java.lang.String java.lang.reflect.Type.getTypeName()
      getTypeNameA( cb: Callback<string>): void;
      getTypeName(): string;
      getTypeNameP(): Promise<string>;
      // public java.lang.reflect.TypeVariable<java.lang.Class<T>>[] java.lang.Class.getTypeParameters()
      getTypeParametersA( cb: Callback<object_t[]>): void;
      getTypeParameters(): object_t[];
      getTypeParametersP(): Promise<object_t[]>;
      // public native int java.lang.Object.hashCode()
      hashCodeA( cb: Callback<number>): void;
      hashCode(): number;
      hashCodeP(): Promise<number>;
      // public boolean java.lang.Class.isAnnotation()
      isAnnotationA( cb: Callback<boolean>): void;
      isAnnotation(): boolean;
      isAnnotationP(): Promise<boolean>;
      // public boolean java.lang.Class.isAnnotationPresent(java.lang.Class<? extends java.lang.annotation.Annotation>)
      isAnnotationPresentA(arg0: Java.Class, cb: Callback<boolean>): void;
      isAnnotationPresent(arg0: Java.Class): boolean;
      isAnnotationPresentP(arg0: Java.Class): Promise<boolean>;
      // public boolean java.lang.Class.isAnonymousClass()
      isAnonymousClassA( cb: Callback<boolean>): void;
      isAnonymousClass(): boolean;
      isAnonymousClassP(): Promise<boolean>;
      // public native boolean java.lang.Class.isArray()
      isArrayA( cb: Callback<boolean>): void;
      isArray(): boolean;
      isArrayP(): Promise<boolean>;
      // public native boolean java.lang.Class.isAssignableFrom(java.lang.Class<?>)
      isAssignableFromA(arg0: Java.Class, cb: Callback<boolean>): void;
      isAssignableFrom(arg0: Java.Class): boolean;
      isAssignableFromP(arg0: Java.Class): Promise<boolean>;
      // public boolean java.lang.Class.isEnum()
      isEnumA( cb: Callback<boolean>): void;
      isEnum(): boolean;
      isEnumP(): Promise<boolean>;
      // public native boolean java.lang.Class.isInstance(java.lang.Object)
      isInstanceA(arg0: object_t, cb: Callback<boolean>): void;
      isInstance(arg0: object_t): boolean;
      isInstanceP(arg0: object_t): Promise<boolean>;
      // public native boolean java.lang.Class.isInterface()
      isInterfaceA( cb: Callback<boolean>): void;
      isInterface(): boolean;
      isInterfaceP(): Promise<boolean>;
      // public boolean java.lang.Class.isLocalClass()
      isLocalClassA( cb: Callback<boolean>): void;
      isLocalClass(): boolean;
      isLocalClassP(): Promise<boolean>;
      // public boolean java.lang.Class.isMemberClass()
      isMemberClassA( cb: Callback<boolean>): void;
      isMemberClass(): boolean;
      isMemberClassP(): Promise<boolean>;
      // public native boolean java.lang.Class.isPrimitive()
      isPrimitiveA( cb: Callback<boolean>): void;
      isPrimitive(): boolean;
      isPrimitiveP(): Promise<boolean>;
      // public boolean java.lang.Class.isSynthetic()
      isSyntheticA( cb: Callback<boolean>): void;
      isSynthetic(): boolean;
      isSyntheticP(): Promise<boolean>;
      // public T java.lang.Class.newInstance() throws java.lang.InstantiationException,java.lang.IllegalAccessException
      newInstanceA( cb: Callback<object_t>): void;
      newInstance(): object_t;
      newInstanceP(): Promise<object_t>;
      // public final native void java.lang.Object.notify()
      notifyA( cb: Callback<void>): void;
      notify(): void;
      notifyP(): Promise<void>;
      // public final native void java.lang.Object.notifyAll()
      notifyAllA( cb: Callback<void>): void;
      notifyAll(): void;
      notifyAllP(): Promise<void>;
      // public java.lang.String java.lang.Class.toGenericString()
      toGenericStringA( cb: Callback<string>): void;
      toGenericString(): string;
      toGenericStringP(): Promise<string>;
      // public java.lang.String java.lang.Object.toString()
      toStringA( cb: Callback<string>): void;
      toString(): string;
      toStringP(): Promise<string>;
      // public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException
      waitA(arg0: object_t, arg1: integer_t, cb: Callback<void>): void;
      wait(arg0: object_t, arg1: integer_t): void;
      waitP(arg0: object_t, arg1: integer_t): Promise<void>;
      // public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException
      waitA(arg0: object_t, cb: Callback<void>): void;
      wait(arg0: object_t): void;
      waitP(arg0: object_t): Promise<void>;
      // public final void java.lang.Object.wait() throws java.lang.InterruptedException
      waitA( cb: Callback<void>): void;
      wait(): void;
      waitP(): Promise<void>;
    }
    export module Class {
      export interface Static {
        class: Java.Class;
        // public static java.lang.Class<?> java.lang.Class.forName(java.lang.String,boolean,java.lang.ClassLoader) throws java.lang.ClassNotFoundException
        forNameA(arg0: string_t, arg1: boolean_t, arg2: Java.ClassLoader, cb: Callback<Java.Class>): void;
        forName(arg0: string_t, arg1: boolean_t, arg2: Java.ClassLoader): Java.Class;
        forNameP(arg0: string_t, arg1: boolean_t, arg2: Java.ClassLoader): Promise<Java.Class>;
        // public static java.lang.Class<?> java.lang.Class.forName(java.lang.String) throws java.lang.ClassNotFoundException
        forNameA(arg0: string_t, cb: Callback<Java.Class>): void;
        forName(arg0: string_t): Java.Class;
        forNameP(arg0: string_t): Promise<Java.Class>;
      }
    }
  }

  export module java.lang {
    export interface ClassLoader extends Java.java.lang.Object {
      // public void java.lang.ClassLoader.clearAssertionStatus()
      clearAssertionStatusA( cb: Callback<void>): void;
      clearAssertionStatus(): void;
      clearAssertionStatusP(): Promise<void>;
      // public boolean java.lang.Object.equals(java.lang.Object)
      equalsA(arg0: object_t, cb: Callback<boolean>): void;
      equals(arg0: object_t): boolean;
      equalsP(arg0: object_t): Promise<boolean>;
      // public final native java.lang.Class<?> java.lang.Object.getClass()
      getClassA( cb: Callback<Java.Class>): void;
      getClass(): Java.Class;
      getClassP(): Promise<Java.Class>;
      // public final java.lang.ClassLoader java.lang.ClassLoader.getParent()
      getParentA( cb: Callback<Java.ClassLoader>): void;
      getParent(): Java.ClassLoader;
      getParentP(): Promise<Java.ClassLoader>;
      // public java.net.URL java.lang.ClassLoader.getResource(java.lang.String)
      getResourceA(arg0: string_t, cb: Callback<object_t>): void;
      getResource(arg0: string_t): object_t;
      getResourceP(arg0: string_t): Promise<object_t>;
      // public java.io.InputStream java.lang.ClassLoader.getResourceAsStream(java.lang.String)
      getResourceAsStreamA(arg0: string_t, cb: Callback<object_t>): void;
      getResourceAsStream(arg0: string_t): object_t;
      getResourceAsStreamP(arg0: string_t): Promise<object_t>;
      // public java.util.Enumeration<java.net.URL> java.lang.ClassLoader.getResources(java.lang.String) throws java.io.IOException
      getResourcesA(arg0: string_t, cb: Callback<object_t>): void;
      getResources(arg0: string_t): object_t;
      getResourcesP(arg0: string_t): Promise<object_t>;
      // public native int java.lang.Object.hashCode()
      hashCodeA( cb: Callback<number>): void;
      hashCode(): number;
      hashCodeP(): Promise<number>;
      // public java.lang.Class<?> java.lang.ClassLoader.loadClass(java.lang.String) throws java.lang.ClassNotFoundException
      loadClassA(arg0: string_t, cb: Callback<Java.Class>): void;
      loadClass(arg0: string_t): Java.Class;
      loadClassP(arg0: string_t): Promise<Java.Class>;
      // public final native void java.lang.Object.notify()
      notifyA( cb: Callback<void>): void;
      notify(): void;
      notifyP(): Promise<void>;
      // public final native void java.lang.Object.notifyAll()
      notifyAllA( cb: Callback<void>): void;
      notifyAll(): void;
      notifyAllP(): Promise<void>;
      // public void java.lang.ClassLoader.setClassAssertionStatus(java.lang.String,boolean)
      setClassAssertionStatusA(arg0: string_t, arg1: boolean_t, cb: Callback<void>): void;
      setClassAssertionStatus(arg0: string_t, arg1: boolean_t): void;
      setClassAssertionStatusP(arg0: string_t, arg1: boolean_t): Promise<void>;
      // public void java.lang.ClassLoader.setDefaultAssertionStatus(boolean)
      setDefaultAssertionStatusA(arg0: boolean_t, cb: Callback<void>): void;
      setDefaultAssertionStatus(arg0: boolean_t): void;
      setDefaultAssertionStatusP(arg0: boolean_t): Promise<void>;
      // public void java.lang.ClassLoader.setPackageAssertionStatus(java.lang.String,boolean)
      setPackageAssertionStatusA(arg0: string_t, arg1: boolean_t, cb: Callback<void>): void;
      setPackageAssertionStatus(arg0: string_t, arg1: boolean_t): void;
      setPackageAssertionStatusP(arg0: string_t, arg1: boolean_t): Promise<void>;
      // public java.lang.String java.lang.Object.toString()
      toStringA( cb: Callback<string>): void;
      toString(): string;
      toStringP(): Promise<string>;
      // public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException
      waitA(arg0: object_t, arg1: integer_t, cb: Callback<void>): void;
      wait(arg0: object_t, arg1: integer_t): void;
      waitP(arg0: object_t, arg1: integer_t): Promise<void>;
      // public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException
      waitA(arg0: object_t, cb: Callback<void>): void;
      wait(arg0: object_t): void;
      waitP(arg0: object_t): Promise<void>;
      // public final void java.lang.Object.wait() throws java.lang.InterruptedException
      waitA( cb: Callback<void>): void;
      wait(): void;
      waitP(): Promise<void>;
    }
    export module ClassLoader {
      export interface Static {
        class: Java.Class;
        // public static java.lang.ClassLoader java.lang.ClassLoader.getSystemClassLoader()
        getSystemClassLoaderA( cb: Callback<Java.ClassLoader>): void;
        getSystemClassLoader(): Java.ClassLoader;
        getSystemClassLoaderP(): Promise<Java.ClassLoader>;
        // public static java.net.URL java.lang.ClassLoader.getSystemResource(java.lang.String)
        getSystemResourceA(arg0: string_t, cb: Callback<object_t>): void;
        getSystemResource(arg0: string_t): object_t;
        getSystemResourceP(arg0: string_t): Promise<object_t>;
        // public static java.io.InputStream java.lang.ClassLoader.getSystemResourceAsStream(java.lang.String)
        getSystemResourceAsStreamA(arg0: string_t, cb: Callback<object_t>): void;
        getSystemResourceAsStream(arg0: string_t): object_t;
        getSystemResourceAsStreamP(arg0: string_t): Promise<object_t>;
        // public static java.util.Enumeration<java.net.URL> java.lang.ClassLoader.getSystemResources(java.lang.String) throws java.io.IOException
        getSystemResourcesA(arg0: string_t, cb: Callback<object_t>): void;
        getSystemResources(arg0: string_t): object_t;
        getSystemResourcesP(arg0: string_t): Promise<object_t>;
      }
    }
  }

  export module java.lang {
    export interface Integer extends Java.java.lang.Object {
      // public byte java.lang.Integer.byteValue()
      byteValueA( cb: Callback<object_t>): void;
      byteValue(): object_t;
      byteValueP(): Promise<object_t>;
      // public int java.lang.Integer.compareTo(java.lang.Integer)
      compareToA(arg0: integer_t, cb: Callback<number>): void;
      compareTo(arg0: integer_t): number;
      compareToP(arg0: integer_t): Promise<number>;
      // public int java.lang.Integer.compareTo(java.lang.Object)
      compareToA(arg0: object_t, cb: Callback<number>): void;
      compareTo(arg0: object_t): number;
      compareToP(arg0: object_t): Promise<number>;
      // public double java.lang.Integer.doubleValue()
      doubleValueA( cb: Callback<object_t>): void;
      doubleValue(): object_t;
      doubleValueP(): Promise<object_t>;
      // public boolean java.lang.Object.equals(java.lang.Object)
      equalsA(arg0: object_t, cb: Callback<boolean>): void;
      equals(arg0: object_t): boolean;
      equalsP(arg0: object_t): Promise<boolean>;
      // public float java.lang.Integer.floatValue()
      floatValueA( cb: Callback<object_t>): void;
      floatValue(): object_t;
      floatValueP(): Promise<object_t>;
      // public final native java.lang.Class<?> java.lang.Object.getClass()
      getClassA( cb: Callback<Java.Class>): void;
      getClass(): Java.Class;
      getClassP(): Promise<Java.Class>;
      // public native int java.lang.Object.hashCode()
      hashCodeA( cb: Callback<number>): void;
      hashCode(): number;
      hashCodeP(): Promise<number>;
      // public int java.lang.Integer.intValue()
      intValueA( cb: Callback<number>): void;
      intValue(): number;
      intValueP(): Promise<number>;
      // public long java.lang.Integer.longValue()
      longValueA( cb: Callback<object_t>): void;
      longValue(): object_t;
      longValueP(): Promise<object_t>;
      // public final native void java.lang.Object.notify()
      notifyA( cb: Callback<void>): void;
      notify(): void;
      notifyP(): Promise<void>;
      // public final native void java.lang.Object.notifyAll()
      notifyAllA( cb: Callback<void>): void;
      notifyAll(): void;
      notifyAllP(): Promise<void>;
      // public short java.lang.Integer.shortValue()
      shortValueA( cb: Callback<object_t>): void;
      shortValue(): object_t;
      shortValueP(): Promise<object_t>;
      // public java.lang.String java.lang.Object.toString()
      toStringA( cb: Callback<string>): void;
      toString(): string;
      toStringP(): Promise<string>;
      // public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException
      waitA(arg0: object_t, arg1: integer_t, cb: Callback<void>): void;
      wait(arg0: object_t, arg1: integer_t): void;
      waitP(arg0: object_t, arg1: integer_t): Promise<void>;
      // public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException
      waitA(arg0: object_t, cb: Callback<void>): void;
      wait(arg0: object_t): void;
      waitP(arg0: object_t): Promise<void>;
      // public final void java.lang.Object.wait() throws java.lang.InterruptedException
      waitA( cb: Callback<void>): void;
      wait(): void;
      waitP(): Promise<void>;
    }
    export module Integer {
      export interface Static {
        MIN_VALUE: number;
        MAX_VALUE: number;
        TYPE: Java.Class;
        SIZE: number;
        BYTES: number;
        class: Java.Class;
        new (arg0: string_t): java.lang.Integer;
        new (arg0: integer_t): java.lang.Integer;
        // public static int java.lang.Integer.bitCount(int)
        bitCountA(arg0: integer_t, cb: Callback<number>): void;
        bitCount(arg0: integer_t): number;
        bitCountP(arg0: integer_t): Promise<number>;
        // public static int java.lang.Integer.compare(int,int)
        compareA(arg0: integer_t, arg1: integer_t, cb: Callback<number>): void;
        compare(arg0: integer_t, arg1: integer_t): number;
        compareP(arg0: integer_t, arg1: integer_t): Promise<number>;
        // public static int java.lang.Integer.compareUnsigned(int,int)
        compareUnsignedA(arg0: integer_t, arg1: integer_t, cb: Callback<number>): void;
        compareUnsigned(arg0: integer_t, arg1: integer_t): number;
        compareUnsignedP(arg0: integer_t, arg1: integer_t): Promise<number>;
        // public static java.lang.Integer java.lang.Integer.decode(java.lang.String) throws java.lang.NumberFormatException
        decodeA(arg0: string_t, cb: Callback<number>): void;
        decode(arg0: string_t): number;
        decodeP(arg0: string_t): Promise<number>;
        // public static int java.lang.Integer.divideUnsigned(int,int)
        divideUnsignedA(arg0: integer_t, arg1: integer_t, cb: Callback<number>): void;
        divideUnsigned(arg0: integer_t, arg1: integer_t): number;
        divideUnsignedP(arg0: integer_t, arg1: integer_t): Promise<number>;
        // public static java.lang.Integer java.lang.Integer.getInteger(java.lang.String,java.lang.Integer)
        getIntegerA(arg0: string_t, arg1: integer_t, cb: Callback<number>): void;
        getInteger(arg0: string_t, arg1: integer_t): number;
        getIntegerP(arg0: string_t, arg1: integer_t): Promise<number>;
        // public static java.lang.Integer java.lang.Integer.getInteger(java.lang.String,int)
        getIntegerA(arg0: string_t, arg1: integer_t, cb: Callback<number>): void;
        getInteger(arg0: string_t, arg1: integer_t): number;
        getIntegerP(arg0: string_t, arg1: integer_t): Promise<number>;
        // public static java.lang.Integer java.lang.Integer.getInteger(java.lang.String)
        getIntegerA(arg0: string_t, cb: Callback<number>): void;
        getInteger(arg0: string_t): number;
        getIntegerP(arg0: string_t): Promise<number>;
        // public static int java.lang.Integer.hashCode(int)
        hashCodeA(arg0: integer_t, cb: Callback<number>): void;
        hashCode(arg0: integer_t): number;
        hashCodeP(arg0: integer_t): Promise<number>;
        // public static int java.lang.Integer.highestOneBit(int)
        highestOneBitA(arg0: integer_t, cb: Callback<number>): void;
        highestOneBit(arg0: integer_t): number;
        highestOneBitP(arg0: integer_t): Promise<number>;
        // public static int java.lang.Integer.lowestOneBit(int)
        lowestOneBitA(arg0: integer_t, cb: Callback<number>): void;
        lowestOneBit(arg0: integer_t): number;
        lowestOneBitP(arg0: integer_t): Promise<number>;
        // public static int java.lang.Integer.max(int,int)
        maxA(arg0: integer_t, arg1: integer_t, cb: Callback<number>): void;
        max(arg0: integer_t, arg1: integer_t): number;
        maxP(arg0: integer_t, arg1: integer_t): Promise<number>;
        // public static int java.lang.Integer.min(int,int)
        minA(arg0: integer_t, arg1: integer_t, cb: Callback<number>): void;
        min(arg0: integer_t, arg1: integer_t): number;
        minP(arg0: integer_t, arg1: integer_t): Promise<number>;
        // public static int java.lang.Integer.numberOfLeadingZeros(int)
        numberOfLeadingZerosA(arg0: integer_t, cb: Callback<number>): void;
        numberOfLeadingZeros(arg0: integer_t): number;
        numberOfLeadingZerosP(arg0: integer_t): Promise<number>;
        // public static int java.lang.Integer.numberOfTrailingZeros(int)
        numberOfTrailingZerosA(arg0: integer_t, cb: Callback<number>): void;
        numberOfTrailingZeros(arg0: integer_t): number;
        numberOfTrailingZerosP(arg0: integer_t): Promise<number>;
        // public static int java.lang.Integer.parseInt(java.lang.String,int) throws java.lang.NumberFormatException
        parseIntA(arg0: string_t, arg1: integer_t, cb: Callback<number>): void;
        parseInt(arg0: string_t, arg1: integer_t): number;
        parseIntP(arg0: string_t, arg1: integer_t): Promise<number>;
        // public static int java.lang.Integer.parseInt(java.lang.String) throws java.lang.NumberFormatException
        parseIntA(arg0: string_t, cb: Callback<number>): void;
        parseInt(arg0: string_t): number;
        parseIntP(arg0: string_t): Promise<number>;
        // public static int java.lang.Integer.parseUnsignedInt(java.lang.String,int) throws java.lang.NumberFormatException
        parseUnsignedIntA(arg0: string_t, arg1: integer_t, cb: Callback<number>): void;
        parseUnsignedInt(arg0: string_t, arg1: integer_t): number;
        parseUnsignedIntP(arg0: string_t, arg1: integer_t): Promise<number>;
        // public static int java.lang.Integer.parseUnsignedInt(java.lang.String) throws java.lang.NumberFormatException
        parseUnsignedIntA(arg0: string_t, cb: Callback<number>): void;
        parseUnsignedInt(arg0: string_t): number;
        parseUnsignedIntP(arg0: string_t): Promise<number>;
        // public static int java.lang.Integer.remainderUnsigned(int,int)
        remainderUnsignedA(arg0: integer_t, arg1: integer_t, cb: Callback<number>): void;
        remainderUnsigned(arg0: integer_t, arg1: integer_t): number;
        remainderUnsignedP(arg0: integer_t, arg1: integer_t): Promise<number>;
        // public static int java.lang.Integer.reverse(int)
        reverseA(arg0: integer_t, cb: Callback<number>): void;
        reverse(arg0: integer_t): number;
        reverseP(arg0: integer_t): Promise<number>;
        // public static int java.lang.Integer.reverseBytes(int)
        reverseBytesA(arg0: integer_t, cb: Callback<number>): void;
        reverseBytes(arg0: integer_t): number;
        reverseBytesP(arg0: integer_t): Promise<number>;
        // public static int java.lang.Integer.rotateLeft(int,int)
        rotateLeftA(arg0: integer_t, arg1: integer_t, cb: Callback<number>): void;
        rotateLeft(arg0: integer_t, arg1: integer_t): number;
        rotateLeftP(arg0: integer_t, arg1: integer_t): Promise<number>;
        // public static int java.lang.Integer.rotateRight(int,int)
        rotateRightA(arg0: integer_t, arg1: integer_t, cb: Callback<number>): void;
        rotateRight(arg0: integer_t, arg1: integer_t): number;
        rotateRightP(arg0: integer_t, arg1: integer_t): Promise<number>;
        // public static int java.lang.Integer.signum(int)
        signumA(arg0: integer_t, cb: Callback<number>): void;
        signum(arg0: integer_t): number;
        signumP(arg0: integer_t): Promise<number>;
        // public static int java.lang.Integer.sum(int,int)
        sumA(arg0: integer_t, arg1: integer_t, cb: Callback<number>): void;
        sum(arg0: integer_t, arg1: integer_t): number;
        sumP(arg0: integer_t, arg1: integer_t): Promise<number>;
        // public static java.lang.String java.lang.Integer.toBinaryString(int)
        toBinaryStringA(arg0: integer_t, cb: Callback<string>): void;
        toBinaryString(arg0: integer_t): string;
        toBinaryStringP(arg0: integer_t): Promise<string>;
        // public static java.lang.String java.lang.Integer.toHexString(int)
        toHexStringA(arg0: integer_t, cb: Callback<string>): void;
        toHexString(arg0: integer_t): string;
        toHexStringP(arg0: integer_t): Promise<string>;
        // public static java.lang.String java.lang.Integer.toOctalString(int)
        toOctalStringA(arg0: integer_t, cb: Callback<string>): void;
        toOctalString(arg0: integer_t): string;
        toOctalStringP(arg0: integer_t): Promise<string>;
        // public static java.lang.String java.lang.Integer.toString(int,int)
        toStringA(arg0: integer_t, arg1: integer_t, cb: Callback<string>): void;
        toString(arg0: integer_t, arg1: integer_t): string;
        toStringP(arg0: integer_t, arg1: integer_t): Promise<string>;
        // public static java.lang.String java.lang.Integer.toString(int)
        toStringA(arg0: integer_t, cb: Callback<string>): void;
        toString(arg0: integer_t): string;
        toStringP(arg0: integer_t): Promise<string>;
        // public static long java.lang.Integer.toUnsignedLong(int)
        toUnsignedLongA(arg0: integer_t, cb: Callback<object_t>): void;
        toUnsignedLong(arg0: integer_t): object_t;
        toUnsignedLongP(arg0: integer_t): Promise<object_t>;
        // public static java.lang.String java.lang.Integer.toUnsignedString(int,int)
        toUnsignedStringA(arg0: integer_t, arg1: integer_t, cb: Callback<string>): void;
        toUnsignedString(arg0: integer_t, arg1: integer_t): string;
        toUnsignedStringP(arg0: integer_t, arg1: integer_t): Promise<string>;
        // public static java.lang.String java.lang.Integer.toUnsignedString(int)
        toUnsignedStringA(arg0: integer_t, cb: Callback<string>): void;
        toUnsignedString(arg0: integer_t): string;
        toUnsignedStringP(arg0: integer_t): Promise<string>;
        // public static java.lang.Integer java.lang.Integer.valueOf(java.lang.String,int) throws java.lang.NumberFormatException
        valueOfA(arg0: string_t, arg1: integer_t, cb: Callback<number>): void;
        valueOf(arg0: string_t, arg1: integer_t): number;
        valueOfP(arg0: string_t, arg1: integer_t): Promise<number>;
        // public static java.lang.Integer java.lang.Integer.valueOf(java.lang.String) throws java.lang.NumberFormatException
        valueOfA(arg0: string_t, cb: Callback<number>): void;
        valueOf(arg0: string_t): number;
        valueOfP(arg0: string_t): Promise<number>;
        // public static java.lang.Integer java.lang.Integer.valueOf(int)
        valueOfA(arg0: integer_t, cb: Callback<number>): void;
        valueOf(arg0: integer_t): number;
        valueOfP(arg0: integer_t): Promise<number>;
      }
    }
  }

  export module java.lang {
    export interface Object  {
      // public boolean java.lang.Object.equals(java.lang.Object)
      equalsA(arg0: object_t, cb: Callback<boolean>): void;
      equals(arg0: object_t): boolean;
      equalsP(arg0: object_t): Promise<boolean>;
      // public final native java.lang.Class<?> java.lang.Object.getClass()
      getClassA( cb: Callback<Java.Class>): void;
      getClass(): Java.Class;
      getClassP(): Promise<Java.Class>;
      // public native int java.lang.Object.hashCode()
      hashCodeA( cb: Callback<number>): void;
      hashCode(): number;
      hashCodeP(): Promise<number>;
      // public final native void java.lang.Object.notify()
      notifyA( cb: Callback<void>): void;
      notify(): void;
      notifyP(): Promise<void>;
      // public final native void java.lang.Object.notifyAll()
      notifyAllA( cb: Callback<void>): void;
      notifyAll(): void;
      notifyAllP(): Promise<void>;
      // public java.lang.String java.lang.Object.toString()
      toStringA( cb: Callback<string>): void;
      toString(): string;
      toStringP(): Promise<string>;
      // public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException
      waitA(arg0: object_t, arg1: integer_t, cb: Callback<void>): void;
      wait(arg0: object_t, arg1: integer_t): void;
      waitP(arg0: object_t, arg1: integer_t): Promise<void>;
      // public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException
      waitA(arg0: object_t, cb: Callback<void>): void;
      wait(arg0: object_t): void;
      waitP(arg0: object_t): Promise<void>;
      // public final void java.lang.Object.wait() throws java.lang.InterruptedException
      waitA( cb: Callback<void>): void;
      wait(): void;
      waitP(): Promise<void>;
    }
    export module Object {
      export interface Static {
        class: Java.Class;
        new (): java.lang.Object;
      }
    }
  }

  export module java.lang.reflect {
    export interface AccessibleObject extends Java.java.lang.Object {
      // public boolean java.lang.Object.equals(java.lang.Object)
      equalsA(arg0: object_t, cb: Callback<boolean>): void;
      equals(arg0: object_t): boolean;
      equalsP(arg0: object_t): Promise<boolean>;
      // public <T> T java.lang.reflect.AccessibleObject.getAnnotation(java.lang.Class<T>)
      getAnnotationA(arg0: Java.Class, cb: Callback<object_t>): void;
      getAnnotation(arg0: Java.Class): object_t;
      getAnnotationP(arg0: Java.Class): Promise<object_t>;
      // public java.lang.annotation.Annotation[] java.lang.reflect.AccessibleObject.getAnnotations()
      getAnnotationsA( cb: Callback<object_t[]>): void;
      getAnnotations(): object_t[];
      getAnnotationsP(): Promise<object_t[]>;
      // public <T> T[] java.lang.reflect.AccessibleObject.getAnnotationsByType(java.lang.Class<T>)
      getAnnotationsByTypeA(arg0: Java.Class, cb: Callback<object_t[]>): void;
      getAnnotationsByType(arg0: Java.Class): object_t[];
      getAnnotationsByTypeP(arg0: Java.Class): Promise<object_t[]>;
      // public final native java.lang.Class<?> java.lang.Object.getClass()
      getClassA( cb: Callback<Java.Class>): void;
      getClass(): Java.Class;
      getClassP(): Promise<Java.Class>;
      // public <T> T java.lang.reflect.AccessibleObject.getDeclaredAnnotation(java.lang.Class<T>)
      getDeclaredAnnotationA(arg0: Java.Class, cb: Callback<object_t>): void;
      getDeclaredAnnotation(arg0: Java.Class): object_t;
      getDeclaredAnnotationP(arg0: Java.Class): Promise<object_t>;
      // public java.lang.annotation.Annotation[] java.lang.reflect.AccessibleObject.getDeclaredAnnotations()
      getDeclaredAnnotationsA( cb: Callback<object_t[]>): void;
      getDeclaredAnnotations(): object_t[];
      getDeclaredAnnotationsP(): Promise<object_t[]>;
      // public <T> T[] java.lang.reflect.AccessibleObject.getDeclaredAnnotationsByType(java.lang.Class<T>)
      getDeclaredAnnotationsByTypeA(arg0: Java.Class, cb: Callback<object_t[]>): void;
      getDeclaredAnnotationsByType(arg0: Java.Class): object_t[];
      getDeclaredAnnotationsByTypeP(arg0: Java.Class): Promise<object_t[]>;
      // public native int java.lang.Object.hashCode()
      hashCodeA( cb: Callback<number>): void;
      hashCode(): number;
      hashCodeP(): Promise<number>;
      // public boolean java.lang.reflect.AccessibleObject.isAccessible()
      isAccessibleA( cb: Callback<boolean>): void;
      isAccessible(): boolean;
      isAccessibleP(): Promise<boolean>;
      // public boolean java.lang.reflect.AccessibleObject.isAnnotationPresent(java.lang.Class<? extends java.lang.annotation.Annotation>)
      isAnnotationPresentA(arg0: Java.Class, cb: Callback<boolean>): void;
      isAnnotationPresent(arg0: Java.Class): boolean;
      isAnnotationPresentP(arg0: Java.Class): Promise<boolean>;
      // public final native void java.lang.Object.notify()
      notifyA( cb: Callback<void>): void;
      notify(): void;
      notifyP(): Promise<void>;
      // public final native void java.lang.Object.notifyAll()
      notifyAllA( cb: Callback<void>): void;
      notifyAll(): void;
      notifyAllP(): Promise<void>;
      // public void java.lang.reflect.AccessibleObject.setAccessible(boolean) throws java.lang.SecurityException
      setAccessibleA(arg0: boolean_t, cb: Callback<void>): void;
      setAccessible(arg0: boolean_t): void;
      setAccessibleP(arg0: boolean_t): Promise<void>;
      // public java.lang.String java.lang.Object.toString()
      toStringA( cb: Callback<string>): void;
      toString(): string;
      toStringP(): Promise<string>;
      // public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException
      waitA(arg0: object_t, arg1: integer_t, cb: Callback<void>): void;
      wait(arg0: object_t, arg1: integer_t): void;
      waitP(arg0: object_t, arg1: integer_t): Promise<void>;
      // public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException
      waitA(arg0: object_t, cb: Callback<void>): void;
      wait(arg0: object_t): void;
      waitP(arg0: object_t): Promise<void>;
      // public final void java.lang.Object.wait() throws java.lang.InterruptedException
      waitA( cb: Callback<void>): void;
      wait(): void;
      waitP(): Promise<void>;
    }
    export module AccessibleObject {
      export interface Static {
        class: Java.Class;
        // public static void java.lang.reflect.AccessibleObject.setAccessible(java.lang.reflect.AccessibleObject[],boolean) throws java.lang.SecurityException
        setAccessibleA(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t, cb: Callback<void>): void;
        setAccessible(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t): void;
        setAccessibleP(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t): Promise<void>;
      }
    }
  }

  export module java.lang.reflect {
    export interface Constructor extends Java.java.lang.reflect.Executable {
      // public boolean java.lang.Object.equals(java.lang.Object)
      equalsA(arg0: object_t, cb: Callback<boolean>): void;
      equals(arg0: object_t): boolean;
      equalsP(arg0: object_t): Promise<boolean>;
      // public java.lang.reflect.AnnotatedType[] java.lang.reflect.Executable.getAnnotatedExceptionTypes()
      getAnnotatedExceptionTypesA( cb: Callback<object_t[]>): void;
      getAnnotatedExceptionTypes(): object_t[];
      getAnnotatedExceptionTypesP(): Promise<object_t[]>;
      // public java.lang.reflect.AnnotatedType[] java.lang.reflect.Executable.getAnnotatedParameterTypes()
      getAnnotatedParameterTypesA( cb: Callback<object_t[]>): void;
      getAnnotatedParameterTypes(): object_t[];
      getAnnotatedParameterTypesP(): Promise<object_t[]>;
      // public java.lang.reflect.AnnotatedType java.lang.reflect.Executable.getAnnotatedReceiverType()
      getAnnotatedReceiverTypeA( cb: Callback<object_t>): void;
      getAnnotatedReceiverType(): object_t;
      getAnnotatedReceiverTypeP(): Promise<object_t>;
      // public abstract java.lang.reflect.AnnotatedType java.lang.reflect.Executable.getAnnotatedReturnType()
      getAnnotatedReturnTypeA( cb: Callback<object_t>): void;
      getAnnotatedReturnType(): object_t;
      getAnnotatedReturnTypeP(): Promise<object_t>;
      // public <T> T java.lang.reflect.AccessibleObject.getAnnotation(java.lang.Class<T>)
      getAnnotationA(arg0: Java.Class, cb: Callback<object_t>): void;
      getAnnotation(arg0: Java.Class): object_t;
      getAnnotationP(arg0: Java.Class): Promise<object_t>;
      // public java.lang.annotation.Annotation[] java.lang.reflect.AccessibleObject.getAnnotations()
      getAnnotationsA( cb: Callback<object_t[]>): void;
      getAnnotations(): object_t[];
      getAnnotationsP(): Promise<object_t[]>;
      // public <T> T[] java.lang.reflect.AccessibleObject.getAnnotationsByType(java.lang.Class<T>)
      getAnnotationsByTypeA(arg0: Java.Class, cb: Callback<object_t[]>): void;
      getAnnotationsByType(arg0: Java.Class): object_t[];
      getAnnotationsByTypeP(arg0: Java.Class): Promise<object_t[]>;
      // public final native java.lang.Class<?> java.lang.Object.getClass()
      getClassA( cb: Callback<Java.Class>): void;
      getClass(): Java.Class;
      getClassP(): Promise<Java.Class>;
      // public <T> T java.lang.reflect.AccessibleObject.getDeclaredAnnotation(java.lang.Class<T>)
      getDeclaredAnnotationA(arg0: Java.Class, cb: Callback<object_t>): void;
      getDeclaredAnnotation(arg0: Java.Class): object_t;
      getDeclaredAnnotationP(arg0: Java.Class): Promise<object_t>;
      // public java.lang.annotation.Annotation[] java.lang.reflect.AccessibleObject.getDeclaredAnnotations()
      getDeclaredAnnotationsA( cb: Callback<object_t[]>): void;
      getDeclaredAnnotations(): object_t[];
      getDeclaredAnnotationsP(): Promise<object_t[]>;
      // public <T> T[] java.lang.reflect.AccessibleObject.getDeclaredAnnotationsByType(java.lang.Class<T>)
      getDeclaredAnnotationsByTypeA(arg0: Java.Class, cb: Callback<object_t[]>): void;
      getDeclaredAnnotationsByType(arg0: Java.Class): object_t[];
      getDeclaredAnnotationsByTypeP(arg0: Java.Class): Promise<object_t[]>;
      // public abstract java.lang.Class<?> java.lang.reflect.Executable.getDeclaringClass()
      getDeclaringClassA( cb: Callback<Java.Class>): void;
      getDeclaringClass(): Java.Class;
      getDeclaringClassP(): Promise<Java.Class>;
      // public abstract java.lang.Class<?>[] java.lang.reflect.Executable.getExceptionTypes()
      getExceptionTypesA( cb: Callback<Java.Class[]>): void;
      getExceptionTypes(): Java.Class[];
      getExceptionTypesP(): Promise<Java.Class[]>;
      // public java.lang.reflect.Type[] java.lang.reflect.Executable.getGenericExceptionTypes()
      getGenericExceptionTypesA( cb: Callback<Java.Type[]>): void;
      getGenericExceptionTypes(): Java.Type[];
      getGenericExceptionTypesP(): Promise<Java.Type[]>;
      // public java.lang.reflect.Type[] java.lang.reflect.Executable.getGenericParameterTypes()
      getGenericParameterTypesA( cb: Callback<Java.Type[]>): void;
      getGenericParameterTypes(): Java.Type[];
      getGenericParameterTypesP(): Promise<Java.Type[]>;
      // public abstract int java.lang.reflect.Executable.getModifiers()
      getModifiersA( cb: Callback<number>): void;
      getModifiers(): number;
      getModifiersP(): Promise<number>;
      // public abstract java.lang.String java.lang.reflect.Executable.getName()
      getNameA( cb: Callback<string>): void;
      getName(): string;
      getNameP(): Promise<string>;
      // public abstract java.lang.annotation.Annotation[][] java.lang.reflect.Executable.getParameterAnnotations()
      getParameterAnnotationsA( cb: Callback<object_t[][]>): void;
      getParameterAnnotations(): object_t[][];
      getParameterAnnotationsP(): Promise<object_t[][]>;
      // public int java.lang.reflect.Executable.getParameterCount()
      getParameterCountA( cb: Callback<number>): void;
      getParameterCount(): number;
      getParameterCountP(): Promise<number>;
      // public java.lang.reflect.Parameter[] java.lang.reflect.Executable.getParameters()
      getParametersA( cb: Callback<Java.Parameter[]>): void;
      getParameters(): Java.Parameter[];
      getParametersP(): Promise<Java.Parameter[]>;
      // public abstract java.lang.Class<?>[] java.lang.reflect.Executable.getParameterTypes()
      getParameterTypesA( cb: Callback<Java.Class[]>): void;
      getParameterTypes(): Java.Class[];
      getParameterTypesP(): Promise<Java.Class[]>;
      // public abstract java.lang.reflect.TypeVariable<?>[] java.lang.reflect.Executable.getTypeParameters()
      getTypeParametersA( cb: Callback<object_t[]>): void;
      getTypeParameters(): object_t[];
      getTypeParametersP(): Promise<object_t[]>;
      // public native int java.lang.Object.hashCode()
      hashCodeA( cb: Callback<number>): void;
      hashCode(): number;
      hashCodeP(): Promise<number>;
      // public boolean java.lang.reflect.AccessibleObject.isAccessible()
      isAccessibleA( cb: Callback<boolean>): void;
      isAccessible(): boolean;
      isAccessibleP(): Promise<boolean>;
      // public boolean java.lang.reflect.AccessibleObject.isAnnotationPresent(java.lang.Class<? extends java.lang.annotation.Annotation>)
      isAnnotationPresentA(arg0: Java.Class, cb: Callback<boolean>): void;
      isAnnotationPresent(arg0: Java.Class): boolean;
      isAnnotationPresentP(arg0: Java.Class): Promise<boolean>;
      // public boolean java.lang.reflect.Executable.isSynthetic()
      isSyntheticA( cb: Callback<boolean>): void;
      isSynthetic(): boolean;
      isSyntheticP(): Promise<boolean>;
      // public boolean java.lang.reflect.Executable.isVarArgs()
      isVarArgsA( cb: Callback<boolean>): void;
      isVarArgs(): boolean;
      isVarArgsP(): Promise<boolean>;
      // public T java.lang.reflect.Constructor.newInstance(java.lang.Object...) throws java.lang.InstantiationException,java.lang.IllegalAccessException,java.lang.IllegalArgumentException,java.lang.reflect.InvocationTargetException
      newInstanceA(arg0: object_array_t, cb: Callback<object_t>): void;
      newInstance(...arg0: object_t[]): object_t;
      newInstance(arg0: object_array_t): object_t;
      newInstanceP(...arg0: object_t[]): Promise<object_t>;
      newInstanceP(arg0: object_array_t): Promise<object_t>;
      // public final native void java.lang.Object.notify()
      notifyA( cb: Callback<void>): void;
      notify(): void;
      notifyP(): Promise<void>;
      // public final native void java.lang.Object.notifyAll()
      notifyAllA( cb: Callback<void>): void;
      notifyAll(): void;
      notifyAllP(): Promise<void>;
      // public void java.lang.reflect.AccessibleObject.setAccessible(boolean) throws java.lang.SecurityException
      setAccessibleA(arg0: boolean_t, cb: Callback<void>): void;
      setAccessible(arg0: boolean_t): void;
      setAccessibleP(arg0: boolean_t): Promise<void>;
      // public abstract java.lang.String java.lang.reflect.Executable.toGenericString()
      toGenericStringA( cb: Callback<string>): void;
      toGenericString(): string;
      toGenericStringP(): Promise<string>;
      // public java.lang.String java.lang.Object.toString()
      toStringA( cb: Callback<string>): void;
      toString(): string;
      toStringP(): Promise<string>;
      // public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException
      waitA(arg0: object_t, arg1: integer_t, cb: Callback<void>): void;
      wait(arg0: object_t, arg1: integer_t): void;
      waitP(arg0: object_t, arg1: integer_t): Promise<void>;
      // public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException
      waitA(arg0: object_t, cb: Callback<void>): void;
      wait(arg0: object_t): void;
      waitP(arg0: object_t): Promise<void>;
      // public final void java.lang.Object.wait() throws java.lang.InterruptedException
      waitA( cb: Callback<void>): void;
      wait(): void;
      waitP(): Promise<void>;
    }
    export module Constructor {
      export interface Static {
        PUBLIC: number;
        DECLARED: number;
        class: Java.Class;
        // public static void java.lang.reflect.AccessibleObject.setAccessible(java.lang.reflect.AccessibleObject[],boolean) throws java.lang.SecurityException
        setAccessibleA(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t, cb: Callback<void>): void;
        setAccessible(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t): void;
        setAccessibleP(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t): Promise<void>;
      }
    }
  }

  export module java.lang.reflect {
    export interface Executable extends Java.java.lang.reflect.AccessibleObject {
      // public boolean java.lang.Object.equals(java.lang.Object)
      equalsA(arg0: object_t, cb: Callback<boolean>): void;
      equals(arg0: object_t): boolean;
      equalsP(arg0: object_t): Promise<boolean>;
      // public java.lang.reflect.AnnotatedType[] java.lang.reflect.Executable.getAnnotatedExceptionTypes()
      getAnnotatedExceptionTypesA( cb: Callback<object_t[]>): void;
      getAnnotatedExceptionTypes(): object_t[];
      getAnnotatedExceptionTypesP(): Promise<object_t[]>;
      // public java.lang.reflect.AnnotatedType[] java.lang.reflect.Executable.getAnnotatedParameterTypes()
      getAnnotatedParameterTypesA( cb: Callback<object_t[]>): void;
      getAnnotatedParameterTypes(): object_t[];
      getAnnotatedParameterTypesP(): Promise<object_t[]>;
      // public java.lang.reflect.AnnotatedType java.lang.reflect.Executable.getAnnotatedReceiverType()
      getAnnotatedReceiverTypeA( cb: Callback<object_t>): void;
      getAnnotatedReceiverType(): object_t;
      getAnnotatedReceiverTypeP(): Promise<object_t>;
      // public abstract java.lang.reflect.AnnotatedType java.lang.reflect.Executable.getAnnotatedReturnType()
      getAnnotatedReturnTypeA( cb: Callback<object_t>): void;
      getAnnotatedReturnType(): object_t;
      getAnnotatedReturnTypeP(): Promise<object_t>;
      // public <T> T java.lang.reflect.AccessibleObject.getAnnotation(java.lang.Class<T>)
      getAnnotationA(arg0: Java.Class, cb: Callback<object_t>): void;
      getAnnotation(arg0: Java.Class): object_t;
      getAnnotationP(arg0: Java.Class): Promise<object_t>;
      // public java.lang.annotation.Annotation[] java.lang.reflect.AccessibleObject.getAnnotations()
      getAnnotationsA( cb: Callback<object_t[]>): void;
      getAnnotations(): object_t[];
      getAnnotationsP(): Promise<object_t[]>;
      // public <T> T[] java.lang.reflect.AccessibleObject.getAnnotationsByType(java.lang.Class<T>)
      getAnnotationsByTypeA(arg0: Java.Class, cb: Callback<object_t[]>): void;
      getAnnotationsByType(arg0: Java.Class): object_t[];
      getAnnotationsByTypeP(arg0: Java.Class): Promise<object_t[]>;
      // public final native java.lang.Class<?> java.lang.Object.getClass()
      getClassA( cb: Callback<Java.Class>): void;
      getClass(): Java.Class;
      getClassP(): Promise<Java.Class>;
      // public <T> T java.lang.reflect.AccessibleObject.getDeclaredAnnotation(java.lang.Class<T>)
      getDeclaredAnnotationA(arg0: Java.Class, cb: Callback<object_t>): void;
      getDeclaredAnnotation(arg0: Java.Class): object_t;
      getDeclaredAnnotationP(arg0: Java.Class): Promise<object_t>;
      // public java.lang.annotation.Annotation[] java.lang.reflect.AccessibleObject.getDeclaredAnnotations()
      getDeclaredAnnotationsA( cb: Callback<object_t[]>): void;
      getDeclaredAnnotations(): object_t[];
      getDeclaredAnnotationsP(): Promise<object_t[]>;
      // public <T> T[] java.lang.reflect.AccessibleObject.getDeclaredAnnotationsByType(java.lang.Class<T>)
      getDeclaredAnnotationsByTypeA(arg0: Java.Class, cb: Callback<object_t[]>): void;
      getDeclaredAnnotationsByType(arg0: Java.Class): object_t[];
      getDeclaredAnnotationsByTypeP(arg0: Java.Class): Promise<object_t[]>;
      // public abstract java.lang.Class<?> java.lang.reflect.Executable.getDeclaringClass()
      getDeclaringClassA( cb: Callback<Java.Class>): void;
      getDeclaringClass(): Java.Class;
      getDeclaringClassP(): Promise<Java.Class>;
      // public abstract java.lang.Class<?>[] java.lang.reflect.Executable.getExceptionTypes()
      getExceptionTypesA( cb: Callback<Java.Class[]>): void;
      getExceptionTypes(): Java.Class[];
      getExceptionTypesP(): Promise<Java.Class[]>;
      // public java.lang.reflect.Type[] java.lang.reflect.Executable.getGenericExceptionTypes()
      getGenericExceptionTypesA( cb: Callback<Java.Type[]>): void;
      getGenericExceptionTypes(): Java.Type[];
      getGenericExceptionTypesP(): Promise<Java.Type[]>;
      // public java.lang.reflect.Type[] java.lang.reflect.Executable.getGenericParameterTypes()
      getGenericParameterTypesA( cb: Callback<Java.Type[]>): void;
      getGenericParameterTypes(): Java.Type[];
      getGenericParameterTypesP(): Promise<Java.Type[]>;
      // public abstract int java.lang.reflect.Executable.getModifiers()
      getModifiersA( cb: Callback<number>): void;
      getModifiers(): number;
      getModifiersP(): Promise<number>;
      // public abstract java.lang.String java.lang.reflect.Executable.getName()
      getNameA( cb: Callback<string>): void;
      getName(): string;
      getNameP(): Promise<string>;
      // public abstract java.lang.annotation.Annotation[][] java.lang.reflect.Executable.getParameterAnnotations()
      getParameterAnnotationsA( cb: Callback<object_t[][]>): void;
      getParameterAnnotations(): object_t[][];
      getParameterAnnotationsP(): Promise<object_t[][]>;
      // public int java.lang.reflect.Executable.getParameterCount()
      getParameterCountA( cb: Callback<number>): void;
      getParameterCount(): number;
      getParameterCountP(): Promise<number>;
      // public java.lang.reflect.Parameter[] java.lang.reflect.Executable.getParameters()
      getParametersA( cb: Callback<Java.Parameter[]>): void;
      getParameters(): Java.Parameter[];
      getParametersP(): Promise<Java.Parameter[]>;
      // public abstract java.lang.Class<?>[] java.lang.reflect.Executable.getParameterTypes()
      getParameterTypesA( cb: Callback<Java.Class[]>): void;
      getParameterTypes(): Java.Class[];
      getParameterTypesP(): Promise<Java.Class[]>;
      // public abstract java.lang.reflect.TypeVariable<?>[] java.lang.reflect.Executable.getTypeParameters()
      getTypeParametersA( cb: Callback<object_t[]>): void;
      getTypeParameters(): object_t[];
      getTypeParametersP(): Promise<object_t[]>;
      // public native int java.lang.Object.hashCode()
      hashCodeA( cb: Callback<number>): void;
      hashCode(): number;
      hashCodeP(): Promise<number>;
      // public boolean java.lang.reflect.AccessibleObject.isAccessible()
      isAccessibleA( cb: Callback<boolean>): void;
      isAccessible(): boolean;
      isAccessibleP(): Promise<boolean>;
      // public boolean java.lang.reflect.AccessibleObject.isAnnotationPresent(java.lang.Class<? extends java.lang.annotation.Annotation>)
      isAnnotationPresentA(arg0: Java.Class, cb: Callback<boolean>): void;
      isAnnotationPresent(arg0: Java.Class): boolean;
      isAnnotationPresentP(arg0: Java.Class): Promise<boolean>;
      // public boolean java.lang.reflect.Executable.isSynthetic()
      isSyntheticA( cb: Callback<boolean>): void;
      isSynthetic(): boolean;
      isSyntheticP(): Promise<boolean>;
      // public boolean java.lang.reflect.Executable.isVarArgs()
      isVarArgsA( cb: Callback<boolean>): void;
      isVarArgs(): boolean;
      isVarArgsP(): Promise<boolean>;
      // public final native void java.lang.Object.notify()
      notifyA( cb: Callback<void>): void;
      notify(): void;
      notifyP(): Promise<void>;
      // public final native void java.lang.Object.notifyAll()
      notifyAllA( cb: Callback<void>): void;
      notifyAll(): void;
      notifyAllP(): Promise<void>;
      // public void java.lang.reflect.AccessibleObject.setAccessible(boolean) throws java.lang.SecurityException
      setAccessibleA(arg0: boolean_t, cb: Callback<void>): void;
      setAccessible(arg0: boolean_t): void;
      setAccessibleP(arg0: boolean_t): Promise<void>;
      // public abstract java.lang.String java.lang.reflect.Executable.toGenericString()
      toGenericStringA( cb: Callback<string>): void;
      toGenericString(): string;
      toGenericStringP(): Promise<string>;
      // public java.lang.String java.lang.Object.toString()
      toStringA( cb: Callback<string>): void;
      toString(): string;
      toStringP(): Promise<string>;
      // public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException
      waitA(arg0: object_t, arg1: integer_t, cb: Callback<void>): void;
      wait(arg0: object_t, arg1: integer_t): void;
      waitP(arg0: object_t, arg1: integer_t): Promise<void>;
      // public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException
      waitA(arg0: object_t, cb: Callback<void>): void;
      wait(arg0: object_t): void;
      waitP(arg0: object_t): Promise<void>;
      // public final void java.lang.Object.wait() throws java.lang.InterruptedException
      waitA( cb: Callback<void>): void;
      wait(): void;
      waitP(): Promise<void>;
    }
    export module Executable {
      export interface Static {
        PUBLIC: number;
        DECLARED: number;
        class: Java.Class;
        // public static void java.lang.reflect.AccessibleObject.setAccessible(java.lang.reflect.AccessibleObject[],boolean) throws java.lang.SecurityException
        setAccessibleA(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t, cb: Callback<void>): void;
        setAccessible(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t): void;
        setAccessibleP(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t): Promise<void>;
      }
    }
  }

  export module java.lang.reflect {
    export interface Field extends Java.java.lang.reflect.AccessibleObject {
      // public boolean java.lang.Object.equals(java.lang.Object)
      equalsA(arg0: object_t, cb: Callback<boolean>): void;
      equals(arg0: object_t): boolean;
      equalsP(arg0: object_t): Promise<boolean>;
      // public java.lang.Object java.lang.reflect.Field.get(java.lang.Object) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      getA(arg0: object_t, cb: Callback<object_t>): void;
      get(arg0: object_t): object_t;
      getP(arg0: object_t): Promise<object_t>;
      // public java.lang.reflect.AnnotatedType java.lang.reflect.Field.getAnnotatedType()
      getAnnotatedTypeA( cb: Callback<object_t>): void;
      getAnnotatedType(): object_t;
      getAnnotatedTypeP(): Promise<object_t>;
      // public <T> T java.lang.reflect.AccessibleObject.getAnnotation(java.lang.Class<T>)
      getAnnotationA(arg0: Java.Class, cb: Callback<object_t>): void;
      getAnnotation(arg0: Java.Class): object_t;
      getAnnotationP(arg0: Java.Class): Promise<object_t>;
      // public java.lang.annotation.Annotation[] java.lang.reflect.AccessibleObject.getAnnotations()
      getAnnotationsA( cb: Callback<object_t[]>): void;
      getAnnotations(): object_t[];
      getAnnotationsP(): Promise<object_t[]>;
      // public <T> T[] java.lang.reflect.AccessibleObject.getAnnotationsByType(java.lang.Class<T>)
      getAnnotationsByTypeA(arg0: Java.Class, cb: Callback<object_t[]>): void;
      getAnnotationsByType(arg0: Java.Class): object_t[];
      getAnnotationsByTypeP(arg0: Java.Class): Promise<object_t[]>;
      // public boolean java.lang.reflect.Field.getBoolean(java.lang.Object) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      getBooleanA(arg0: object_t, cb: Callback<boolean>): void;
      getBoolean(arg0: object_t): boolean;
      getBooleanP(arg0: object_t): Promise<boolean>;
      // public byte java.lang.reflect.Field.getByte(java.lang.Object) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      getByteA(arg0: object_t, cb: Callback<object_t>): void;
      getByte(arg0: object_t): object_t;
      getByteP(arg0: object_t): Promise<object_t>;
      // public char java.lang.reflect.Field.getChar(java.lang.Object) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      getCharA(arg0: object_t, cb: Callback<object_t>): void;
      getChar(arg0: object_t): object_t;
      getCharP(arg0: object_t): Promise<object_t>;
      // public final native java.lang.Class<?> java.lang.Object.getClass()
      getClassA( cb: Callback<Java.Class>): void;
      getClass(): Java.Class;
      getClassP(): Promise<Java.Class>;
      // public <T> T java.lang.reflect.AccessibleObject.getDeclaredAnnotation(java.lang.Class<T>)
      getDeclaredAnnotationA(arg0: Java.Class, cb: Callback<object_t>): void;
      getDeclaredAnnotation(arg0: Java.Class): object_t;
      getDeclaredAnnotationP(arg0: Java.Class): Promise<object_t>;
      // public java.lang.annotation.Annotation[] java.lang.reflect.AccessibleObject.getDeclaredAnnotations()
      getDeclaredAnnotationsA( cb: Callback<object_t[]>): void;
      getDeclaredAnnotations(): object_t[];
      getDeclaredAnnotationsP(): Promise<object_t[]>;
      // public <T> T[] java.lang.reflect.AccessibleObject.getDeclaredAnnotationsByType(java.lang.Class<T>)
      getDeclaredAnnotationsByTypeA(arg0: Java.Class, cb: Callback<object_t[]>): void;
      getDeclaredAnnotationsByType(arg0: Java.Class): object_t[];
      getDeclaredAnnotationsByTypeP(arg0: Java.Class): Promise<object_t[]>;
      // public java.lang.Class<?> java.lang.reflect.Field.getDeclaringClass()
      getDeclaringClassA( cb: Callback<Java.Class>): void;
      getDeclaringClass(): Java.Class;
      getDeclaringClassP(): Promise<Java.Class>;
      // public double java.lang.reflect.Field.getDouble(java.lang.Object) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      getDoubleA(arg0: object_t, cb: Callback<object_t>): void;
      getDouble(arg0: object_t): object_t;
      getDoubleP(arg0: object_t): Promise<object_t>;
      // public float java.lang.reflect.Field.getFloat(java.lang.Object) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      getFloatA(arg0: object_t, cb: Callback<object_t>): void;
      getFloat(arg0: object_t): object_t;
      getFloatP(arg0: object_t): Promise<object_t>;
      // public java.lang.reflect.Type java.lang.reflect.Field.getGenericType()
      getGenericTypeA( cb: Callback<Java.Type>): void;
      getGenericType(): Java.Type;
      getGenericTypeP(): Promise<Java.Type>;
      // public int java.lang.reflect.Field.getInt(java.lang.Object) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      getIntA(arg0: object_t, cb: Callback<number>): void;
      getInt(arg0: object_t): number;
      getIntP(arg0: object_t): Promise<number>;
      // public long java.lang.reflect.Field.getLong(java.lang.Object) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      getLongA(arg0: object_t, cb: Callback<object_t>): void;
      getLong(arg0: object_t): object_t;
      getLongP(arg0: object_t): Promise<object_t>;
      // public int java.lang.reflect.Field.getModifiers()
      getModifiersA( cb: Callback<number>): void;
      getModifiers(): number;
      getModifiersP(): Promise<number>;
      // public java.lang.String java.lang.reflect.Field.getName()
      getNameA( cb: Callback<string>): void;
      getName(): string;
      getNameP(): Promise<string>;
      // public short java.lang.reflect.Field.getShort(java.lang.Object) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      getShortA(arg0: object_t, cb: Callback<object_t>): void;
      getShort(arg0: object_t): object_t;
      getShortP(arg0: object_t): Promise<object_t>;
      // public java.lang.Class<?> java.lang.reflect.Field.getType()
      getTypeA( cb: Callback<Java.Class>): void;
      getType(): Java.Class;
      getTypeP(): Promise<Java.Class>;
      // public native int java.lang.Object.hashCode()
      hashCodeA( cb: Callback<number>): void;
      hashCode(): number;
      hashCodeP(): Promise<number>;
      // public boolean java.lang.reflect.AccessibleObject.isAccessible()
      isAccessibleA( cb: Callback<boolean>): void;
      isAccessible(): boolean;
      isAccessibleP(): Promise<boolean>;
      // public boolean java.lang.reflect.AccessibleObject.isAnnotationPresent(java.lang.Class<? extends java.lang.annotation.Annotation>)
      isAnnotationPresentA(arg0: Java.Class, cb: Callback<boolean>): void;
      isAnnotationPresent(arg0: Java.Class): boolean;
      isAnnotationPresentP(arg0: Java.Class): Promise<boolean>;
      // public boolean java.lang.reflect.Field.isEnumConstant()
      isEnumConstantA( cb: Callback<boolean>): void;
      isEnumConstant(): boolean;
      isEnumConstantP(): Promise<boolean>;
      // public boolean java.lang.reflect.Field.isSynthetic()
      isSyntheticA( cb: Callback<boolean>): void;
      isSynthetic(): boolean;
      isSyntheticP(): Promise<boolean>;
      // public final native void java.lang.Object.notify()
      notifyA( cb: Callback<void>): void;
      notify(): void;
      notifyP(): Promise<void>;
      // public final native void java.lang.Object.notifyAll()
      notifyAllA( cb: Callback<void>): void;
      notifyAll(): void;
      notifyAllP(): Promise<void>;
      // public void java.lang.reflect.Field.set(java.lang.Object,java.lang.Object) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      setA(arg0: object_t, arg1: object_t, cb: Callback<void>): void;
      set(arg0: object_t, arg1: object_t): void;
      setP(arg0: object_t, arg1: object_t): Promise<void>;
      // public void java.lang.reflect.AccessibleObject.setAccessible(boolean) throws java.lang.SecurityException
      setAccessibleA(arg0: boolean_t, cb: Callback<void>): void;
      setAccessible(arg0: boolean_t): void;
      setAccessibleP(arg0: boolean_t): Promise<void>;
      // public void java.lang.reflect.Field.setBoolean(java.lang.Object,boolean) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      setBooleanA(arg0: object_t, arg1: boolean_t, cb: Callback<void>): void;
      setBoolean(arg0: object_t, arg1: boolean_t): void;
      setBooleanP(arg0: object_t, arg1: boolean_t): Promise<void>;
      // public void java.lang.reflect.Field.setByte(java.lang.Object,byte) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      setByteA(arg0: object_t, arg1: object_t, cb: Callback<void>): void;
      setByte(arg0: object_t, arg1: object_t): void;
      setByteP(arg0: object_t, arg1: object_t): Promise<void>;
      // public void java.lang.reflect.Field.setChar(java.lang.Object,char) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      setCharA(arg0: object_t, arg1: object_t, cb: Callback<void>): void;
      setChar(arg0: object_t, arg1: object_t): void;
      setCharP(arg0: object_t, arg1: object_t): Promise<void>;
      // public void java.lang.reflect.Field.setDouble(java.lang.Object,double) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      setDoubleA(arg0: object_t, arg1: object_t, cb: Callback<void>): void;
      setDouble(arg0: object_t, arg1: object_t): void;
      setDoubleP(arg0: object_t, arg1: object_t): Promise<void>;
      // public void java.lang.reflect.Field.setFloat(java.lang.Object,float) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      setFloatA(arg0: object_t, arg1: object_t, cb: Callback<void>): void;
      setFloat(arg0: object_t, arg1: object_t): void;
      setFloatP(arg0: object_t, arg1: object_t): Promise<void>;
      // public void java.lang.reflect.Field.setInt(java.lang.Object,int) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      setIntA(arg0: object_t, arg1: integer_t, cb: Callback<void>): void;
      setInt(arg0: object_t, arg1: integer_t): void;
      setIntP(arg0: object_t, arg1: integer_t): Promise<void>;
      // public void java.lang.reflect.Field.setLong(java.lang.Object,long) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      setLongA(arg0: object_t, arg1: object_t, cb: Callback<void>): void;
      setLong(arg0: object_t, arg1: object_t): void;
      setLongP(arg0: object_t, arg1: object_t): Promise<void>;
      // public void java.lang.reflect.Field.setShort(java.lang.Object,short) throws java.lang.IllegalArgumentException,java.lang.IllegalAccessException
      setShortA(arg0: object_t, arg1: object_t, cb: Callback<void>): void;
      setShort(arg0: object_t, arg1: object_t): void;
      setShortP(arg0: object_t, arg1: object_t): Promise<void>;
      // public java.lang.String java.lang.reflect.Field.toGenericString()
      toGenericStringA( cb: Callback<string>): void;
      toGenericString(): string;
      toGenericStringP(): Promise<string>;
      // public java.lang.String java.lang.Object.toString()
      toStringA( cb: Callback<string>): void;
      toString(): string;
      toStringP(): Promise<string>;
      // public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException
      waitA(arg0: object_t, arg1: integer_t, cb: Callback<void>): void;
      wait(arg0: object_t, arg1: integer_t): void;
      waitP(arg0: object_t, arg1: integer_t): Promise<void>;
      // public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException
      waitA(arg0: object_t, cb: Callback<void>): void;
      wait(arg0: object_t): void;
      waitP(arg0: object_t): Promise<void>;
      // public final void java.lang.Object.wait() throws java.lang.InterruptedException
      waitA( cb: Callback<void>): void;
      wait(): void;
      waitP(): Promise<void>;
    }
    export module Field {
      export interface Static {
        PUBLIC: number;
        DECLARED: number;
        class: Java.Class;
        // public static void java.lang.reflect.AccessibleObject.setAccessible(java.lang.reflect.AccessibleObject[],boolean) throws java.lang.SecurityException
        setAccessibleA(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t, cb: Callback<void>): void;
        setAccessible(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t): void;
        setAccessibleP(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t): Promise<void>;
      }
    }
  }

  export module java.lang.reflect {
    export interface Method extends Java.java.lang.reflect.Executable {
      // public boolean java.lang.Object.equals(java.lang.Object)
      equalsA(arg0: object_t, cb: Callback<boolean>): void;
      equals(arg0: object_t): boolean;
      equalsP(arg0: object_t): Promise<boolean>;
      // public java.lang.reflect.AnnotatedType[] java.lang.reflect.Executable.getAnnotatedExceptionTypes()
      getAnnotatedExceptionTypesA( cb: Callback<object_t[]>): void;
      getAnnotatedExceptionTypes(): object_t[];
      getAnnotatedExceptionTypesP(): Promise<object_t[]>;
      // public java.lang.reflect.AnnotatedType[] java.lang.reflect.Executable.getAnnotatedParameterTypes()
      getAnnotatedParameterTypesA( cb: Callback<object_t[]>): void;
      getAnnotatedParameterTypes(): object_t[];
      getAnnotatedParameterTypesP(): Promise<object_t[]>;
      // public java.lang.reflect.AnnotatedType java.lang.reflect.Executable.getAnnotatedReceiverType()
      getAnnotatedReceiverTypeA( cb: Callback<object_t>): void;
      getAnnotatedReceiverType(): object_t;
      getAnnotatedReceiverTypeP(): Promise<object_t>;
      // public abstract java.lang.reflect.AnnotatedType java.lang.reflect.Executable.getAnnotatedReturnType()
      getAnnotatedReturnTypeA( cb: Callback<object_t>): void;
      getAnnotatedReturnType(): object_t;
      getAnnotatedReturnTypeP(): Promise<object_t>;
      // public <T> T java.lang.reflect.AccessibleObject.getAnnotation(java.lang.Class<T>)
      getAnnotationA(arg0: Java.Class, cb: Callback<object_t>): void;
      getAnnotation(arg0: Java.Class): object_t;
      getAnnotationP(arg0: Java.Class): Promise<object_t>;
      // public java.lang.annotation.Annotation[] java.lang.reflect.AccessibleObject.getAnnotations()
      getAnnotationsA( cb: Callback<object_t[]>): void;
      getAnnotations(): object_t[];
      getAnnotationsP(): Promise<object_t[]>;
      // public <T> T[] java.lang.reflect.AccessibleObject.getAnnotationsByType(java.lang.Class<T>)
      getAnnotationsByTypeA(arg0: Java.Class, cb: Callback<object_t[]>): void;
      getAnnotationsByType(arg0: Java.Class): object_t[];
      getAnnotationsByTypeP(arg0: Java.Class): Promise<object_t[]>;
      // public final native java.lang.Class<?> java.lang.Object.getClass()
      getClassA( cb: Callback<Java.Class>): void;
      getClass(): Java.Class;
      getClassP(): Promise<Java.Class>;
      // public <T> T java.lang.reflect.AccessibleObject.getDeclaredAnnotation(java.lang.Class<T>)
      getDeclaredAnnotationA(arg0: Java.Class, cb: Callback<object_t>): void;
      getDeclaredAnnotation(arg0: Java.Class): object_t;
      getDeclaredAnnotationP(arg0: Java.Class): Promise<object_t>;
      // public java.lang.annotation.Annotation[] java.lang.reflect.AccessibleObject.getDeclaredAnnotations()
      getDeclaredAnnotationsA( cb: Callback<object_t[]>): void;
      getDeclaredAnnotations(): object_t[];
      getDeclaredAnnotationsP(): Promise<object_t[]>;
      // public <T> T[] java.lang.reflect.AccessibleObject.getDeclaredAnnotationsByType(java.lang.Class<T>)
      getDeclaredAnnotationsByTypeA(arg0: Java.Class, cb: Callback<object_t[]>): void;
      getDeclaredAnnotationsByType(arg0: Java.Class): object_t[];
      getDeclaredAnnotationsByTypeP(arg0: Java.Class): Promise<object_t[]>;
      // public abstract java.lang.Class<?> java.lang.reflect.Executable.getDeclaringClass()
      getDeclaringClassA( cb: Callback<Java.Class>): void;
      getDeclaringClass(): Java.Class;
      getDeclaringClassP(): Promise<Java.Class>;
      // public java.lang.Object java.lang.reflect.Method.getDefaultValue()
      getDefaultValueA( cb: Callback<object_t>): void;
      getDefaultValue(): object_t;
      getDefaultValueP(): Promise<object_t>;
      // public abstract java.lang.Class<?>[] java.lang.reflect.Executable.getExceptionTypes()
      getExceptionTypesA( cb: Callback<Java.Class[]>): void;
      getExceptionTypes(): Java.Class[];
      getExceptionTypesP(): Promise<Java.Class[]>;
      // public java.lang.reflect.Type[] java.lang.reflect.Executable.getGenericExceptionTypes()
      getGenericExceptionTypesA( cb: Callback<Java.Type[]>): void;
      getGenericExceptionTypes(): Java.Type[];
      getGenericExceptionTypesP(): Promise<Java.Type[]>;
      // public java.lang.reflect.Type[] java.lang.reflect.Executable.getGenericParameterTypes()
      getGenericParameterTypesA( cb: Callback<Java.Type[]>): void;
      getGenericParameterTypes(): Java.Type[];
      getGenericParameterTypesP(): Promise<Java.Type[]>;
      // public java.lang.reflect.Type java.lang.reflect.Method.getGenericReturnType()
      getGenericReturnTypeA( cb: Callback<Java.Type>): void;
      getGenericReturnType(): Java.Type;
      getGenericReturnTypeP(): Promise<Java.Type>;
      // public abstract int java.lang.reflect.Executable.getModifiers()
      getModifiersA( cb: Callback<number>): void;
      getModifiers(): number;
      getModifiersP(): Promise<number>;
      // public abstract java.lang.String java.lang.reflect.Executable.getName()
      getNameA( cb: Callback<string>): void;
      getName(): string;
      getNameP(): Promise<string>;
      // public abstract java.lang.annotation.Annotation[][] java.lang.reflect.Executable.getParameterAnnotations()
      getParameterAnnotationsA( cb: Callback<object_t[][]>): void;
      getParameterAnnotations(): object_t[][];
      getParameterAnnotationsP(): Promise<object_t[][]>;
      // public int java.lang.reflect.Executable.getParameterCount()
      getParameterCountA( cb: Callback<number>): void;
      getParameterCount(): number;
      getParameterCountP(): Promise<number>;
      // public java.lang.reflect.Parameter[] java.lang.reflect.Executable.getParameters()
      getParametersA( cb: Callback<Java.Parameter[]>): void;
      getParameters(): Java.Parameter[];
      getParametersP(): Promise<Java.Parameter[]>;
      // public abstract java.lang.Class<?>[] java.lang.reflect.Executable.getParameterTypes()
      getParameterTypesA( cb: Callback<Java.Class[]>): void;
      getParameterTypes(): Java.Class[];
      getParameterTypesP(): Promise<Java.Class[]>;
      // public java.lang.Class<?> java.lang.reflect.Method.getReturnType()
      getReturnTypeA( cb: Callback<Java.Class>): void;
      getReturnType(): Java.Class;
      getReturnTypeP(): Promise<Java.Class>;
      // public abstract java.lang.reflect.TypeVariable<?>[] java.lang.reflect.Executable.getTypeParameters()
      getTypeParametersA( cb: Callback<object_t[]>): void;
      getTypeParameters(): object_t[];
      getTypeParametersP(): Promise<object_t[]>;
      // public native int java.lang.Object.hashCode()
      hashCodeA( cb: Callback<number>): void;
      hashCode(): number;
      hashCodeP(): Promise<number>;
      // public java.lang.Object java.lang.reflect.Method.invoke(java.lang.Object,java.lang.Object...) throws java.lang.IllegalAccessException,java.lang.IllegalArgumentException,java.lang.reflect.InvocationTargetException
      invokeA(arg0: object_t, arg1: object_array_t, cb: Callback<object_t>): void;
      invoke(arg0: object_t, ...arg1: object_t[]): object_t;
      invoke(arg0: object_t, arg1: object_array_t): object_t;
      invokeP(arg0: object_t, ...arg1: object_t[]): Promise<object_t>;
      invokeP(arg0: object_t, arg1: object_array_t): Promise<object_t>;
      // public boolean java.lang.reflect.AccessibleObject.isAccessible()
      isAccessibleA( cb: Callback<boolean>): void;
      isAccessible(): boolean;
      isAccessibleP(): Promise<boolean>;
      // public boolean java.lang.reflect.AccessibleObject.isAnnotationPresent(java.lang.Class<? extends java.lang.annotation.Annotation>)
      isAnnotationPresentA(arg0: Java.Class, cb: Callback<boolean>): void;
      isAnnotationPresent(arg0: Java.Class): boolean;
      isAnnotationPresentP(arg0: Java.Class): Promise<boolean>;
      // public boolean java.lang.reflect.Method.isBridge()
      isBridgeA( cb: Callback<boolean>): void;
      isBridge(): boolean;
      isBridgeP(): Promise<boolean>;
      // public boolean java.lang.reflect.Method.isDefault()
      isDefaultA( cb: Callback<boolean>): void;
      isDefault(): boolean;
      isDefaultP(): Promise<boolean>;
      // public boolean java.lang.reflect.Executable.isSynthetic()
      isSyntheticA( cb: Callback<boolean>): void;
      isSynthetic(): boolean;
      isSyntheticP(): Promise<boolean>;
      // public boolean java.lang.reflect.Executable.isVarArgs()
      isVarArgsA( cb: Callback<boolean>): void;
      isVarArgs(): boolean;
      isVarArgsP(): Promise<boolean>;
      // public final native void java.lang.Object.notify()
      notifyA( cb: Callback<void>): void;
      notify(): void;
      notifyP(): Promise<void>;
      // public final native void java.lang.Object.notifyAll()
      notifyAllA( cb: Callback<void>): void;
      notifyAll(): void;
      notifyAllP(): Promise<void>;
      // public void java.lang.reflect.AccessibleObject.setAccessible(boolean) throws java.lang.SecurityException
      setAccessibleA(arg0: boolean_t, cb: Callback<void>): void;
      setAccessible(arg0: boolean_t): void;
      setAccessibleP(arg0: boolean_t): Promise<void>;
      // public abstract java.lang.String java.lang.reflect.Executable.toGenericString()
      toGenericStringA( cb: Callback<string>): void;
      toGenericString(): string;
      toGenericStringP(): Promise<string>;
      // public java.lang.String java.lang.Object.toString()
      toStringA( cb: Callback<string>): void;
      toString(): string;
      toStringP(): Promise<string>;
      // public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException
      waitA(arg0: object_t, arg1: integer_t, cb: Callback<void>): void;
      wait(arg0: object_t, arg1: integer_t): void;
      waitP(arg0: object_t, arg1: integer_t): Promise<void>;
      // public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException
      waitA(arg0: object_t, cb: Callback<void>): void;
      wait(arg0: object_t): void;
      waitP(arg0: object_t): Promise<void>;
      // public final void java.lang.Object.wait() throws java.lang.InterruptedException
      waitA( cb: Callback<void>): void;
      wait(): void;
      waitP(): Promise<void>;
    }
    export module Method {
      export interface Static {
        PUBLIC: number;
        DECLARED: number;
        class: Java.Class;
        // public static void java.lang.reflect.AccessibleObject.setAccessible(java.lang.reflect.AccessibleObject[],boolean) throws java.lang.SecurityException
        setAccessibleA(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t, cb: Callback<void>): void;
        setAccessible(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t): void;
        setAccessibleP(arg0: array_t<Java.AccessibleObject>, arg1: boolean_t): Promise<void>;
      }
    }
  }

  export module java.lang.reflect {
    export interface Modifier extends Java.java.lang.Object {
      // public boolean java.lang.Object.equals(java.lang.Object)
      equalsA(arg0: object_t, cb: Callback<boolean>): void;
      equals(arg0: object_t): boolean;
      equalsP(arg0: object_t): Promise<boolean>;
      // public final native java.lang.Class<?> java.lang.Object.getClass()
      getClassA( cb: Callback<Java.Class>): void;
      getClass(): Java.Class;
      getClassP(): Promise<Java.Class>;
      // public native int java.lang.Object.hashCode()
      hashCodeA( cb: Callback<number>): void;
      hashCode(): number;
      hashCodeP(): Promise<number>;
      // public final native void java.lang.Object.notify()
      notifyA( cb: Callback<void>): void;
      notify(): void;
      notifyP(): Promise<void>;
      // public final native void java.lang.Object.notifyAll()
      notifyAllA( cb: Callback<void>): void;
      notifyAll(): void;
      notifyAllP(): Promise<void>;
      // public java.lang.String java.lang.Object.toString()
      toStringA( cb: Callback<string>): void;
      toString(): string;
      toStringP(): Promise<string>;
      // public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException
      waitA(arg0: object_t, arg1: integer_t, cb: Callback<void>): void;
      wait(arg0: object_t, arg1: integer_t): void;
      waitP(arg0: object_t, arg1: integer_t): Promise<void>;
      // public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException
      waitA(arg0: object_t, cb: Callback<void>): void;
      wait(arg0: object_t): void;
      waitP(arg0: object_t): Promise<void>;
      // public final void java.lang.Object.wait() throws java.lang.InterruptedException
      waitA( cb: Callback<void>): void;
      wait(): void;
      waitP(): Promise<void>;
    }
    export module Modifier {
      export interface Static {
        PUBLIC: number;
        PRIVATE: number;
        PROTECTED: number;
        STATIC: number;
        FINAL: number;
        SYNCHRONIZED: number;
        VOLATILE: number;
        TRANSIENT: number;
        NATIVE: number;
        INTERFACE: number;
        ABSTRACT: number;
        STRICT: number;
        class: Java.Class;
        new (): java.lang.reflect.Modifier;
        // public static int java.lang.reflect.Modifier.classModifiers()
        classModifiersA( cb: Callback<number>): void;
        classModifiers(): number;
        classModifiersP(): Promise<number>;
        // public static int java.lang.reflect.Modifier.constructorModifiers()
        constructorModifiersA( cb: Callback<number>): void;
        constructorModifiers(): number;
        constructorModifiersP(): Promise<number>;
        // public static int java.lang.reflect.Modifier.fieldModifiers()
        fieldModifiersA( cb: Callback<number>): void;
        fieldModifiers(): number;
        fieldModifiersP(): Promise<number>;
        // public static int java.lang.reflect.Modifier.interfaceModifiers()
        interfaceModifiersA( cb: Callback<number>): void;
        interfaceModifiers(): number;
        interfaceModifiersP(): Promise<number>;
        // public static boolean java.lang.reflect.Modifier.isAbstract(int)
        isAbstractA(arg0: integer_t, cb: Callback<boolean>): void;
        isAbstract(arg0: integer_t): boolean;
        isAbstractP(arg0: integer_t): Promise<boolean>;
        // public static boolean java.lang.reflect.Modifier.isFinal(int)
        isFinalA(arg0: integer_t, cb: Callback<boolean>): void;
        isFinal(arg0: integer_t): boolean;
        isFinalP(arg0: integer_t): Promise<boolean>;
        // public static boolean java.lang.reflect.Modifier.isInterface(int)
        isInterfaceA(arg0: integer_t, cb: Callback<boolean>): void;
        isInterface(arg0: integer_t): boolean;
        isInterfaceP(arg0: integer_t): Promise<boolean>;
        // public static boolean java.lang.reflect.Modifier.isNative(int)
        isNativeA(arg0: integer_t, cb: Callback<boolean>): void;
        isNative(arg0: integer_t): boolean;
        isNativeP(arg0: integer_t): Promise<boolean>;
        // public static boolean java.lang.reflect.Modifier.isPrivate(int)
        isPrivateA(arg0: integer_t, cb: Callback<boolean>): void;
        isPrivate(arg0: integer_t): boolean;
        isPrivateP(arg0: integer_t): Promise<boolean>;
        // public static boolean java.lang.reflect.Modifier.isProtected(int)
        isProtectedA(arg0: integer_t, cb: Callback<boolean>): void;
        isProtected(arg0: integer_t): boolean;
        isProtectedP(arg0: integer_t): Promise<boolean>;
        // public static boolean java.lang.reflect.Modifier.isPublic(int)
        isPublicA(arg0: integer_t, cb: Callback<boolean>): void;
        isPublic(arg0: integer_t): boolean;
        isPublicP(arg0: integer_t): Promise<boolean>;
        // public static boolean java.lang.reflect.Modifier.isStatic(int)
        isStaticA(arg0: integer_t, cb: Callback<boolean>): void;
        isStatic(arg0: integer_t): boolean;
        isStaticP(arg0: integer_t): Promise<boolean>;
        // public static boolean java.lang.reflect.Modifier.isStrict(int)
        isStrictA(arg0: integer_t, cb: Callback<boolean>): void;
        isStrict(arg0: integer_t): boolean;
        isStrictP(arg0: integer_t): Promise<boolean>;
        // public static boolean java.lang.reflect.Modifier.isSynchronized(int)
        isSynchronizedA(arg0: integer_t, cb: Callback<boolean>): void;
        isSynchronized(arg0: integer_t): boolean;
        isSynchronizedP(arg0: integer_t): Promise<boolean>;
        // public static boolean java.lang.reflect.Modifier.isTransient(int)
        isTransientA(arg0: integer_t, cb: Callback<boolean>): void;
        isTransient(arg0: integer_t): boolean;
        isTransientP(arg0: integer_t): Promise<boolean>;
        // public static boolean java.lang.reflect.Modifier.isVolatile(int)
        isVolatileA(arg0: integer_t, cb: Callback<boolean>): void;
        isVolatile(arg0: integer_t): boolean;
        isVolatileP(arg0: integer_t): Promise<boolean>;
        // public static int java.lang.reflect.Modifier.methodModifiers()
        methodModifiersA( cb: Callback<number>): void;
        methodModifiers(): number;
        methodModifiersP(): Promise<number>;
        // public static int java.lang.reflect.Modifier.parameterModifiers()
        parameterModifiersA( cb: Callback<number>): void;
        parameterModifiers(): number;
        parameterModifiersP(): Promise<number>;
        // public static java.lang.String java.lang.reflect.Modifier.toString(int)
        toStringA(arg0: integer_t, cb: Callback<string>): void;
        toString(arg0: integer_t): string;
        toStringP(arg0: integer_t): Promise<string>;
      }
    }
  }

  export module java.lang.reflect {
    export interface Parameter extends Java.java.lang.Object {
      // public boolean java.lang.Object.equals(java.lang.Object)
      equalsA(arg0: object_t, cb: Callback<boolean>): void;
      equals(arg0: object_t): boolean;
      equalsP(arg0: object_t): Promise<boolean>;
      // public java.lang.reflect.AnnotatedType java.lang.reflect.Parameter.getAnnotatedType()
      getAnnotatedTypeA( cb: Callback<object_t>): void;
      getAnnotatedType(): object_t;
      getAnnotatedTypeP(): Promise<object_t>;
      // public <T> T java.lang.reflect.Parameter.getAnnotation(java.lang.Class<T>)
      getAnnotationA(arg0: Java.Class, cb: Callback<object_t>): void;
      getAnnotation(arg0: Java.Class): object_t;
      getAnnotationP(arg0: Java.Class): Promise<object_t>;
      // public java.lang.annotation.Annotation[] java.lang.reflect.Parameter.getAnnotations()
      getAnnotationsA( cb: Callback<object_t[]>): void;
      getAnnotations(): object_t[];
      getAnnotationsP(): Promise<object_t[]>;
      // public <T> T[] java.lang.reflect.Parameter.getAnnotationsByType(java.lang.Class<T>)
      getAnnotationsByTypeA(arg0: Java.Class, cb: Callback<object_t[]>): void;
      getAnnotationsByType(arg0: Java.Class): object_t[];
      getAnnotationsByTypeP(arg0: Java.Class): Promise<object_t[]>;
      // public final native java.lang.Class<?> java.lang.Object.getClass()
      getClassA( cb: Callback<Java.Class>): void;
      getClass(): Java.Class;
      getClassP(): Promise<Java.Class>;
      // public <T> T java.lang.reflect.Parameter.getDeclaredAnnotation(java.lang.Class<T>)
      getDeclaredAnnotationA(arg0: Java.Class, cb: Callback<object_t>): void;
      getDeclaredAnnotation(arg0: Java.Class): object_t;
      getDeclaredAnnotationP(arg0: Java.Class): Promise<object_t>;
      // public java.lang.annotation.Annotation[] java.lang.reflect.Parameter.getDeclaredAnnotations()
      getDeclaredAnnotationsA( cb: Callback<object_t[]>): void;
      getDeclaredAnnotations(): object_t[];
      getDeclaredAnnotationsP(): Promise<object_t[]>;
      // public <T> T[] java.lang.reflect.Parameter.getDeclaredAnnotationsByType(java.lang.Class<T>)
      getDeclaredAnnotationsByTypeA(arg0: Java.Class, cb: Callback<object_t[]>): void;
      getDeclaredAnnotationsByType(arg0: Java.Class): object_t[];
      getDeclaredAnnotationsByTypeP(arg0: Java.Class): Promise<object_t[]>;
      // public java.lang.reflect.Executable java.lang.reflect.Parameter.getDeclaringExecutable()
      getDeclaringExecutableA( cb: Callback<Java.Executable>): void;
      getDeclaringExecutable(): Java.Executable;
      getDeclaringExecutableP(): Promise<Java.Executable>;
      // public int java.lang.reflect.Parameter.getModifiers()
      getModifiersA( cb: Callback<number>): void;
      getModifiers(): number;
      getModifiersP(): Promise<number>;
      // public java.lang.String java.lang.reflect.Parameter.getName()
      getNameA( cb: Callback<string>): void;
      getName(): string;
      getNameP(): Promise<string>;
      // public java.lang.reflect.Type java.lang.reflect.Parameter.getParameterizedType()
      getParameterizedTypeA( cb: Callback<Java.Type>): void;
      getParameterizedType(): Java.Type;
      getParameterizedTypeP(): Promise<Java.Type>;
      // public java.lang.Class<?> java.lang.reflect.Parameter.getType()
      getTypeA( cb: Callback<Java.Class>): void;
      getType(): Java.Class;
      getTypeP(): Promise<Java.Class>;
      // public native int java.lang.Object.hashCode()
      hashCodeA( cb: Callback<number>): void;
      hashCode(): number;
      hashCodeP(): Promise<number>;
      // public default boolean java.lang.reflect.AnnotatedElement.isAnnotationPresent(java.lang.Class<? extends java.lang.annotation.Annotation>)
      isAnnotationPresentA(arg0: Java.Class, cb: Callback<boolean>): void;
      isAnnotationPresent(arg0: Java.Class): boolean;
      isAnnotationPresentP(arg0: Java.Class): Promise<boolean>;
      // public boolean java.lang.reflect.Parameter.isImplicit()
      isImplicitA( cb: Callback<boolean>): void;
      isImplicit(): boolean;
      isImplicitP(): Promise<boolean>;
      // public boolean java.lang.reflect.Parameter.isNamePresent()
      isNamePresentA( cb: Callback<boolean>): void;
      isNamePresent(): boolean;
      isNamePresentP(): Promise<boolean>;
      // public boolean java.lang.reflect.Parameter.isSynthetic()
      isSyntheticA( cb: Callback<boolean>): void;
      isSynthetic(): boolean;
      isSyntheticP(): Promise<boolean>;
      // public boolean java.lang.reflect.Parameter.isVarArgs()
      isVarArgsA( cb: Callback<boolean>): void;
      isVarArgs(): boolean;
      isVarArgsP(): Promise<boolean>;
      // public final native void java.lang.Object.notify()
      notifyA( cb: Callback<void>): void;
      notify(): void;
      notifyP(): Promise<void>;
      // public final native void java.lang.Object.notifyAll()
      notifyAllA( cb: Callback<void>): void;
      notifyAll(): void;
      notifyAllP(): Promise<void>;
      // public java.lang.String java.lang.Object.toString()
      toStringA( cb: Callback<string>): void;
      toString(): string;
      toStringP(): Promise<string>;
      // public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException
      waitA(arg0: object_t, arg1: integer_t, cb: Callback<void>): void;
      wait(arg0: object_t, arg1: integer_t): void;
      waitP(arg0: object_t, arg1: integer_t): Promise<void>;
      // public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException
      waitA(arg0: object_t, cb: Callback<void>): void;
      wait(arg0: object_t): void;
      waitP(arg0: object_t): Promise<void>;
      // public final void java.lang.Object.wait() throws java.lang.InterruptedException
      waitA( cb: Callback<void>): void;
      wait(): void;
      waitP(): Promise<void>;
    }
    export module Parameter {
      export interface Static {
        class: Java.Class;
      }
    }
  }

  export module java.lang.reflect {
    export interface Type extends Java.java.lang.Object {
      // public default java.lang.String java.lang.reflect.Type.getTypeName()
      getTypeNameA( cb: Callback<string>): void;
      getTypeName(): string;
      getTypeNameP(): Promise<string>;
    }
    export module Type {
      export interface Static {
        class: Java.Class;
      }
    }
  }

  export module java.lang {
    export interface String extends Java.java.lang.Object {
      // public char java.lang.String.charAt(int)
      charAtA(arg0: integer_t, cb: Callback<object_t>): void;
      charAt(arg0: integer_t): object_t;
      charAtP(arg0: integer_t): Promise<object_t>;
      // public default java.util.stream.IntStream java.lang.CharSequence.chars()
      charsA( cb: Callback<object_t>): void;
      chars(): object_t;
      charsP(): Promise<object_t>;
      // public int java.lang.String.codePointAt(int)
      codePointAtA(arg0: integer_t, cb: Callback<number>): void;
      codePointAt(arg0: integer_t): number;
      codePointAtP(arg0: integer_t): Promise<number>;
      // public int java.lang.String.codePointBefore(int)
      codePointBeforeA(arg0: integer_t, cb: Callback<number>): void;
      codePointBefore(arg0: integer_t): number;
      codePointBeforeP(arg0: integer_t): Promise<number>;
      // public int java.lang.String.codePointCount(int,int)
      codePointCountA(arg0: integer_t, arg1: integer_t, cb: Callback<number>): void;
      codePointCount(arg0: integer_t, arg1: integer_t): number;
      codePointCountP(arg0: integer_t, arg1: integer_t): Promise<number>;
      // public default java.util.stream.IntStream java.lang.CharSequence.codePoints()
      codePointsA( cb: Callback<object_t>): void;
      codePoints(): object_t;
      codePointsP(): Promise<object_t>;
      // public int java.lang.String.compareTo(java.lang.String)
      compareToA(arg0: string_t, cb: Callback<number>): void;
      compareTo(arg0: string_t): number;
      compareToP(arg0: string_t): Promise<number>;
      // public int java.lang.String.compareTo(java.lang.Object)
      compareToA(arg0: object_t, cb: Callback<number>): void;
      compareTo(arg0: object_t): number;
      compareToP(arg0: object_t): Promise<number>;
      // public int java.lang.String.compareToIgnoreCase(java.lang.String)
      compareToIgnoreCaseA(arg0: string_t, cb: Callback<number>): void;
      compareToIgnoreCase(arg0: string_t): number;
      compareToIgnoreCaseP(arg0: string_t): Promise<number>;
      // public java.lang.String java.lang.String.concat(java.lang.String)
      concatA(arg0: string_t, cb: Callback<string>): void;
      concat(arg0: string_t): string;
      concatP(arg0: string_t): Promise<string>;
      // public boolean java.lang.String.contains(java.lang.CharSequence)
      containsA(arg0: object_t, cb: Callback<boolean>): void;
      contains(arg0: object_t): boolean;
      containsP(arg0: object_t): Promise<boolean>;
      // public boolean java.lang.String.contentEquals(java.lang.StringBuffer)
      contentEqualsA(arg0: object_t, cb: Callback<boolean>): void;
      contentEquals(arg0: object_t): boolean;
      contentEqualsP(arg0: object_t): Promise<boolean>;
      // public boolean java.lang.String.contentEquals(java.lang.CharSequence)
      contentEqualsA(arg0: object_t, cb: Callback<boolean>): void;
      contentEquals(arg0: object_t): boolean;
      contentEqualsP(arg0: object_t): Promise<boolean>;
      // public boolean java.lang.String.endsWith(java.lang.String)
      endsWithA(arg0: string_t, cb: Callback<boolean>): void;
      endsWith(arg0: string_t): boolean;
      endsWithP(arg0: string_t): Promise<boolean>;
      // public boolean java.lang.Object.equals(java.lang.Object)
      equalsA(arg0: object_t, cb: Callback<boolean>): void;
      equals(arg0: object_t): boolean;
      equalsP(arg0: object_t): Promise<boolean>;
      // public boolean java.lang.String.equalsIgnoreCase(java.lang.String)
      equalsIgnoreCaseA(arg0: string_t, cb: Callback<boolean>): void;
      equalsIgnoreCase(arg0: string_t): boolean;
      equalsIgnoreCaseP(arg0: string_t): Promise<boolean>;
      // public void java.lang.String.getBytes(int,int,byte[],int)
      getBytesA(arg0: integer_t, arg1: integer_t, arg2: object_array_t, arg3: integer_t, cb: Callback<void>): void;
      getBytes(arg0: integer_t, arg1: integer_t, arg2: object_array_t, arg3: integer_t): void;
      getBytesP(arg0: integer_t, arg1: integer_t, arg2: object_array_t, arg3: integer_t): Promise<void>;
      // public byte[] java.lang.String.getBytes(java.nio.charset.Charset)
      getBytesA(arg0: object_t, cb: Callback<object_t[]>): void;
      getBytes(arg0: object_t): object_t[];
      getBytesP(arg0: object_t): Promise<object_t[]>;
      // public byte[] java.lang.String.getBytes(java.lang.String) throws java.io.UnsupportedEncodingException
      getBytesA(arg0: string_t, cb: Callback<object_t[]>): void;
      getBytes(arg0: string_t): object_t[];
      getBytesP(arg0: string_t): Promise<object_t[]>;
      // public byte[] java.lang.String.getBytes()
      getBytesA( cb: Callback<object_t[]>): void;
      getBytes(): object_t[];
      getBytesP(): Promise<object_t[]>;
      // public void java.lang.String.getChars(int,int,char[],int)
      getCharsA(arg0: integer_t, arg1: integer_t, arg2: object_array_t, arg3: integer_t, cb: Callback<void>): void;
      getChars(arg0: integer_t, arg1: integer_t, arg2: object_array_t, arg3: integer_t): void;
      getCharsP(arg0: integer_t, arg1: integer_t, arg2: object_array_t, arg3: integer_t): Promise<void>;
      // public final native java.lang.Class<?> java.lang.Object.getClass()
      getClassA( cb: Callback<Java.Class>): void;
      getClass(): Java.Class;
      getClassP(): Promise<Java.Class>;
      // public native int java.lang.Object.hashCode()
      hashCodeA( cb: Callback<number>): void;
      hashCode(): number;
      hashCodeP(): Promise<number>;
      // public int java.lang.String.indexOf(java.lang.String,int)
      indexOfA(arg0: string_t, arg1: integer_t, cb: Callback<number>): void;
      indexOf(arg0: string_t, arg1: integer_t): number;
      indexOfP(arg0: string_t, arg1: integer_t): Promise<number>;
      // public int java.lang.String.indexOf(int,int)
      indexOfA(arg0: integer_t, arg1: integer_t, cb: Callback<number>): void;
      indexOf(arg0: integer_t, arg1: integer_t): number;
      indexOfP(arg0: integer_t, arg1: integer_t): Promise<number>;
      // public int java.lang.String.indexOf(java.lang.String)
      indexOfA(arg0: string_t, cb: Callback<number>): void;
      indexOf(arg0: string_t): number;
      indexOfP(arg0: string_t): Promise<number>;
      // public int java.lang.String.indexOf(int)
      indexOfA(arg0: integer_t, cb: Callback<number>): void;
      indexOf(arg0: integer_t): number;
      indexOfP(arg0: integer_t): Promise<number>;
      // public native java.lang.String java.lang.String.intern()
      internA( cb: Callback<string>): void;
      intern(): string;
      internP(): Promise<string>;
      // public boolean java.lang.String.isEmpty()
      isEmptyA( cb: Callback<boolean>): void;
      isEmpty(): boolean;
      isEmptyP(): Promise<boolean>;
      // public int java.lang.String.lastIndexOf(java.lang.String,int)
      lastIndexOfA(arg0: string_t, arg1: integer_t, cb: Callback<number>): void;
      lastIndexOf(arg0: string_t, arg1: integer_t): number;
      lastIndexOfP(arg0: string_t, arg1: integer_t): Promise<number>;
      // public int java.lang.String.lastIndexOf(int,int)
      lastIndexOfA(arg0: integer_t, arg1: integer_t, cb: Callback<number>): void;
      lastIndexOf(arg0: integer_t, arg1: integer_t): number;
      lastIndexOfP(arg0: integer_t, arg1: integer_t): Promise<number>;
      // public int java.lang.String.lastIndexOf(java.lang.String)
      lastIndexOfA(arg0: string_t, cb: Callback<number>): void;
      lastIndexOf(arg0: string_t): number;
      lastIndexOfP(arg0: string_t): Promise<number>;
      // public int java.lang.String.lastIndexOf(int)
      lastIndexOfA(arg0: integer_t, cb: Callback<number>): void;
      lastIndexOf(arg0: integer_t): number;
      lastIndexOfP(arg0: integer_t): Promise<number>;
      // public int java.lang.String.length()
      lengthA( cb: Callback<number>): void;
      length(): number;
      lengthP(): Promise<number>;
      // public boolean java.lang.String.matches(java.lang.String)
      matchesA(arg0: string_t, cb: Callback<boolean>): void;
      matches(arg0: string_t): boolean;
      matchesP(arg0: string_t): Promise<boolean>;
      // public final native void java.lang.Object.notify()
      notifyA( cb: Callback<void>): void;
      notify(): void;
      notifyP(): Promise<void>;
      // public final native void java.lang.Object.notifyAll()
      notifyAllA( cb: Callback<void>): void;
      notifyAll(): void;
      notifyAllP(): Promise<void>;
      // public int java.lang.String.offsetByCodePoints(int,int)
      offsetByCodePointsA(arg0: integer_t, arg1: integer_t, cb: Callback<number>): void;
      offsetByCodePoints(arg0: integer_t, arg1: integer_t): number;
      offsetByCodePointsP(arg0: integer_t, arg1: integer_t): Promise<number>;
      // public boolean java.lang.String.regionMatches(boolean,int,java.lang.String,int,int)
      regionMatchesA(arg0: boolean_t, arg1: integer_t, arg2: string_t, arg3: integer_t, arg4: integer_t, cb: Callback<boolean>): void;
      regionMatches(arg0: boolean_t, arg1: integer_t, arg2: string_t, arg3: integer_t, arg4: integer_t): boolean;
      regionMatchesP(arg0: boolean_t, arg1: integer_t, arg2: string_t, arg3: integer_t, arg4: integer_t): Promise<boolean>;
      // public boolean java.lang.String.regionMatches(int,java.lang.String,int,int)
      regionMatchesA(arg0: integer_t, arg1: string_t, arg2: integer_t, arg3: integer_t, cb: Callback<boolean>): void;
      regionMatches(arg0: integer_t, arg1: string_t, arg2: integer_t, arg3: integer_t): boolean;
      regionMatchesP(arg0: integer_t, arg1: string_t, arg2: integer_t, arg3: integer_t): Promise<boolean>;
      // public java.lang.String java.lang.String.replace(java.lang.CharSequence,java.lang.CharSequence)
      replaceA(arg0: object_t, arg1: object_t, cb: Callback<string>): void;
      replace(arg0: object_t, arg1: object_t): string;
      replaceP(arg0: object_t, arg1: object_t): Promise<string>;
      // public java.lang.String java.lang.String.replace(char,char)
      replaceA(arg0: object_t, arg1: object_t, cb: Callback<string>): void;
      replace(arg0: object_t, arg1: object_t): string;
      replaceP(arg0: object_t, arg1: object_t): Promise<string>;
      // public java.lang.String java.lang.String.replaceAll(java.lang.String,java.lang.String)
      replaceAllA(arg0: string_t, arg1: string_t, cb: Callback<string>): void;
      replaceAll(arg0: string_t, arg1: string_t): string;
      replaceAllP(arg0: string_t, arg1: string_t): Promise<string>;
      // public java.lang.String java.lang.String.replaceFirst(java.lang.String,java.lang.String)
      replaceFirstA(arg0: string_t, arg1: string_t, cb: Callback<string>): void;
      replaceFirst(arg0: string_t, arg1: string_t): string;
      replaceFirstP(arg0: string_t, arg1: string_t): Promise<string>;
      // public java.lang.String[] java.lang.String.split(java.lang.String,int)
      splitA(arg0: string_t, arg1: integer_t, cb: Callback<string[]>): void;
      split(arg0: string_t, arg1: integer_t): string[];
      splitP(arg0: string_t, arg1: integer_t): Promise<string[]>;
      // public java.lang.String[] java.lang.String.split(java.lang.String)
      splitA(arg0: string_t, cb: Callback<string[]>): void;
      split(arg0: string_t): string[];
      splitP(arg0: string_t): Promise<string[]>;
      // public boolean java.lang.String.startsWith(java.lang.String,int)
      startsWithA(arg0: string_t, arg1: integer_t, cb: Callback<boolean>): void;
      startsWith(arg0: string_t, arg1: integer_t): boolean;
      startsWithP(arg0: string_t, arg1: integer_t): Promise<boolean>;
      // public boolean java.lang.String.startsWith(java.lang.String)
      startsWithA(arg0: string_t, cb: Callback<boolean>): void;
      startsWith(arg0: string_t): boolean;
      startsWithP(arg0: string_t): Promise<boolean>;
      // public java.lang.CharSequence java.lang.String.subSequence(int,int)
      subSequenceA(arg0: integer_t, arg1: integer_t, cb: Callback<object_t>): void;
      subSequence(arg0: integer_t, arg1: integer_t): object_t;
      subSequenceP(arg0: integer_t, arg1: integer_t): Promise<object_t>;
      // public java.lang.String java.lang.String.substring(int,int)
      substringA(arg0: integer_t, arg1: integer_t, cb: Callback<string>): void;
      substring(arg0: integer_t, arg1: integer_t): string;
      substringP(arg0: integer_t, arg1: integer_t): Promise<string>;
      // public java.lang.String java.lang.String.substring(int)
      substringA(arg0: integer_t, cb: Callback<string>): void;
      substring(arg0: integer_t): string;
      substringP(arg0: integer_t): Promise<string>;
      // public char[] java.lang.String.toCharArray()
      toCharArrayA( cb: Callback<object_t[]>): void;
      toCharArray(): object_t[];
      toCharArrayP(): Promise<object_t[]>;
      // public java.lang.String java.lang.String.toLowerCase(java.util.Locale)
      toLowerCaseA(arg0: object_t, cb: Callback<string>): void;
      toLowerCase(arg0: object_t): string;
      toLowerCaseP(arg0: object_t): Promise<string>;
      // public java.lang.String java.lang.String.toLowerCase()
      toLowerCaseA( cb: Callback<string>): void;
      toLowerCase(): string;
      toLowerCaseP(): Promise<string>;
      // public java.lang.String java.lang.Object.toString()
      toStringA( cb: Callback<string>): void;
      toString(): string;
      toStringP(): Promise<string>;
      // public java.lang.String java.lang.String.toUpperCase(java.util.Locale)
      toUpperCaseA(arg0: object_t, cb: Callback<string>): void;
      toUpperCase(arg0: object_t): string;
      toUpperCaseP(arg0: object_t): Promise<string>;
      // public java.lang.String java.lang.String.toUpperCase()
      toUpperCaseA( cb: Callback<string>): void;
      toUpperCase(): string;
      toUpperCaseP(): Promise<string>;
      // public java.lang.String java.lang.String.trim()
      trimA( cb: Callback<string>): void;
      trim(): string;
      trimP(): Promise<string>;
      // public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException
      waitA(arg0: object_t, arg1: integer_t, cb: Callback<void>): void;
      wait(arg0: object_t, arg1: integer_t): void;
      waitP(arg0: object_t, arg1: integer_t): Promise<void>;
      // public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException
      waitA(arg0: object_t, cb: Callback<void>): void;
      wait(arg0: object_t): void;
      waitP(arg0: object_t): Promise<void>;
      // public final void java.lang.Object.wait() throws java.lang.InterruptedException
      waitA( cb: Callback<void>): void;
      wait(): void;
      waitP(): Promise<void>;
    }
    export module String {
      export interface Static {
        CASE_INSENSITIVE_ORDER: object_t;
        class: Java.Class;
        new (arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: object_t): java.lang.String;
        new (arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: string_t): java.lang.String;
        new (arg0: object_array_t, arg1: integer_t, arg2: integer_t, arg3: integer_t): java.lang.String;
        new (arg0: array_t<integer_t>, arg1: integer_t, arg2: integer_t): java.lang.String;
        new (arg0: object_array_t, arg1: integer_t, arg2: integer_t): java.lang.String;
        new (arg0: object_array_t, arg1: integer_t, arg2: integer_t): java.lang.String;
        new (arg0: object_array_t, arg1: object_t): java.lang.String;
        new (arg0: object_array_t, arg1: string_t): java.lang.String;
        new (arg0: object_array_t, arg1: integer_t): java.lang.String;
        new (arg0: object_t): java.lang.String;
        new (arg0: object_t): java.lang.String;
        new (arg0: string_t): java.lang.String;
        new (arg0: object_array_t): java.lang.String;
        new (arg0: object_array_t): java.lang.String;
        new (): java.lang.String;
        // public static java.lang.String java.lang.String.copyValueOf(char[],int,int)
        copyValueOfA(arg0: object_array_t, arg1: integer_t, arg2: integer_t, cb: Callback<string>): void;
        copyValueOf(arg0: object_array_t, arg1: integer_t, arg2: integer_t): string;
        copyValueOfP(arg0: object_array_t, arg1: integer_t, arg2: integer_t): Promise<string>;
        // public static java.lang.String java.lang.String.copyValueOf(char[])
        copyValueOfA(arg0: object_array_t, cb: Callback<string>): void;
        copyValueOf(arg0: object_array_t): string;
        copyValueOfP(arg0: object_array_t): Promise<string>;
        // public static java.lang.String java.lang.String.format(java.util.Locale,java.lang.String,java.lang.Object...)
        formatA(arg0: object_t, arg1: string_t, arg2: object_array_t, cb: Callback<string>): void;
        format(arg0: object_t, arg1: string_t, ...arg2: object_t[]): string;
        format(arg0: object_t, arg1: string_t, arg2: object_array_t): string;
        formatP(arg0: object_t, arg1: string_t, ...arg2: object_t[]): Promise<string>;
        formatP(arg0: object_t, arg1: string_t, arg2: object_array_t): Promise<string>;
        // public static java.lang.String java.lang.String.format(java.lang.String,java.lang.Object...)
        formatA(arg0: string_t, arg1: object_array_t, cb: Callback<string>): void;
        format(arg0: string_t, ...arg1: object_t[]): string;
        format(arg0: string_t, arg1: object_array_t): string;
        formatP(arg0: string_t, ...arg1: object_t[]): Promise<string>;
        formatP(arg0: string_t, arg1: object_array_t): Promise<string>;
        // public static java.lang.String java.lang.String.join(java.lang.CharSequence,java.lang.CharSequence...)
        joinA(arg0: object_t, arg1: object_array_t, cb: Callback<string>): void;
        join(arg0: object_t, ...arg1: object_t[]): string;
        join(arg0: object_t, arg1: object_array_t): string;
        joinP(arg0: object_t, ...arg1: object_t[]): Promise<string>;
        joinP(arg0: object_t, arg1: object_array_t): Promise<string>;
        // public static java.lang.String java.lang.String.join(java.lang.CharSequence,java.lang.Iterable<? extends java.lang.CharSequence>)
        joinA(arg0: object_t, arg1: object_t, cb: Callback<string>): void;
        join(arg0: object_t, arg1: object_t): string;
        joinP(arg0: object_t, arg1: object_t): Promise<string>;
        // public static java.lang.String java.lang.String.valueOf(char[],int,int)
        valueOfA(arg0: object_array_t, arg1: integer_t, arg2: integer_t, cb: Callback<string>): void;
        valueOf(arg0: object_array_t, arg1: integer_t, arg2: integer_t): string;
        valueOfP(arg0: object_array_t, arg1: integer_t, arg2: integer_t): Promise<string>;
        // public static java.lang.String java.lang.String.valueOf(java.lang.Object)
        valueOfA(arg0: object_t, cb: Callback<string>): void;
        valueOf(arg0: object_t): string;
        valueOfP(arg0: object_t): Promise<string>;
        // public static java.lang.String java.lang.String.valueOf(char[])
        valueOfA(arg0: object_array_t, cb: Callback<string>): void;
        valueOf(arg0: object_array_t): string;
        valueOfP(arg0: object_array_t): Promise<string>;
        // public static java.lang.String java.lang.String.valueOf(boolean)
        valueOfA(arg0: boolean_t, cb: Callback<string>): void;
        valueOf(arg0: boolean_t): string;
        valueOfP(arg0: boolean_t): Promise<string>;
        // public static java.lang.String java.lang.String.valueOf(long)
        valueOfA(arg0: object_t, cb: Callback<string>): void;
        valueOf(arg0: object_t): string;
        valueOfP(arg0: object_t): Promise<string>;
        // public static java.lang.String java.lang.String.valueOf(int)
        valueOfA(arg0: integer_t, cb: Callback<string>): void;
        valueOf(arg0: integer_t): string;
        valueOfP(arg0: integer_t): Promise<string>;
        // public static java.lang.String java.lang.String.valueOf(float)
        valueOfA(arg0: object_t, cb: Callback<string>): void;
        valueOf(arg0: object_t): string;
        valueOfP(arg0: object_t): Promise<string>;
        // public static java.lang.String java.lang.String.valueOf(double)
        valueOfA(arg0: object_t, cb: Callback<string>): void;
        valueOf(arg0: object_t): string;
        valueOfP(arg0: object_t): Promise<string>;
        // public static java.lang.String java.lang.String.valueOf(char)
        valueOfA(arg0: object_t, cb: Callback<string>): void;
        valueOf(arg0: object_t): string;
        valueOfP(arg0: object_t): Promise<string>;
      }
    }
  }



  // #### `function smellsLikeJavaObject(e: any)`
  // Returns true if the obj 'smells' like a Java object.
  // This is a light-weight test that will return false when `e` is clearly not a Java object,
  // but it may have false positives. To be certain, use `isJavaObject(e)` or `instanceOf(e, classname)` instead.
  function smellsLikeJavaObject(e: any): boolean {
    return _.isObject(e) && !_.isArray(e) ;
  }

  // #### `function isJavaObject(e: any)`
  // Returns true if the obj is a Java object.
  // Useful for determining the runtime type of object_t returned by many java methods.
  export function isJavaObject(e: any): boolean {
    return smellsLikeJavaObject(e) && _java.instanceOf(e, 'java.lang.Object');
  }

} // module Java
