"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var babel = require("babel-core");
var babel_plugin_istanbul_1 = require("babel-plugin-istanbul");
var jestPreset = require("babel-preset-jest");
function createBabelTransformer(options) {
    options = __assign({}, options, { plugins: (options && options.plugins) || [], presets: ((options && options.presets) || []).concat([jestPreset]), retainLines: true, sourceMaps: 'inline' });
    delete options.cacheDirectory;
    delete options.filename;
    return function (src, filename, config, transformOptions) {
        var theseOptions = Object.assign({ filename: filename }, options);
        if (transformOptions && transformOptions.instrument) {
            theseOptions.auxiliaryCommentBefore = ' istanbul ignore next ';
            theseOptions.plugins = theseOptions.plugins.concat([
                [
                    babel_plugin_istanbul_1.default,
                    {
                        cwd: config.rootDir,
                        exclude: [],
                    },
                ],
            ]);
        }
        return babel.transform(src, theseOptions).code;
    };
}
exports.getPostProcessHook = function (tsCompilerOptions, jestConfig, tsJestConfig) {
    if (tsJestConfig.skipBabel) {
        return function (src) { return src; };
    }
    var plugins = [];
    if (tsCompilerOptions.allowSyntheticDefaultImports) {
        plugins.push('transform-es2015-modules-commonjs');
    }
    return createBabelTransformer({
        babelrc: tsJestConfig.useBabelrc || false,
        plugins: plugins,
        presets: [],
    });
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicG9zdHByb2Nlc3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcG9zdHByb2Nlc3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQUlBLGtDQUFvQztBQUNwQywrREFBbUQ7QUFDbkQsOENBQWdEO0FBV2hELGdDQUFnQyxPQUE4QjtJQUMxRCxPQUFPLGdCQUNBLE9BQU8sSUFDVixPQUFPLEVBQUUsQ0FBQyxPQUFPLElBQUksT0FBTyxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUsRUFDM0MsT0FBTyxFQUFFLENBQUMsQ0FBQyxPQUFPLElBQUksT0FBTyxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLEVBR2xFLFdBQVcsRUFBRSxJQUFJLEVBR2pCLFVBQVUsRUFBRSxRQUFRLEdBQ3ZCLENBQUM7SUFDRixPQUFPLE9BQU8sQ0FBQyxjQUFjLENBQUM7SUFDOUIsT0FBTyxPQUFPLENBQUMsUUFBUSxDQUFDO0lBRXhCLE1BQU0sQ0FBQyxVQUNILEdBQVcsRUFDWCxRQUFnQixFQUNoQixNQUFrQixFQUNsQixnQkFBa0M7UUFFbEMsSUFBTSxZQUFZLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQyxFQUFFLFFBQVEsVUFBQSxFQUFFLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFDMUQsRUFBRSxDQUFDLENBQUMsZ0JBQWdCLElBQUksZ0JBQWdCLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztZQUNsRCxZQUFZLENBQUMsc0JBQXNCLEdBQUcsd0JBQXdCLENBQUM7WUFFL0QsWUFBWSxDQUFDLE9BQU8sR0FBRyxZQUFZLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQztnQkFDL0M7b0JBQ0ksK0JBQWM7b0JBQ2Q7d0JBRUksR0FBRyxFQUFFLE1BQU0sQ0FBQyxPQUFPO3dCQUNuQixPQUFPLEVBQUUsRUFBRTtxQkFDZDtpQkFDSjthQUNKLENBQUMsQ0FBQztRQUNQLENBQUM7UUFFRCxNQUFNLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxHQUFHLEVBQUUsWUFBWSxDQUFDLENBQUMsSUFBSSxDQUFDO0lBQ25ELENBQUMsQ0FBQztBQUNOLENBQUM7QUFFWSxRQUFBLGtCQUFrQixHQUFHLFVBQzlCLGlCQUFrQyxFQUNsQyxVQUFzQixFQUN0QixZQUEwQjtJQUUxQixFQUFFLENBQUMsQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztRQUN6QixNQUFNLENBQUMsVUFBQyxHQUFHLElBQUssT0FBQSxHQUFHLEVBQUgsQ0FBRyxDQUFDO0lBQ3hCLENBQUM7SUFFRCxJQUFNLE9BQU8sR0FBRyxFQUFFLENBQUM7SUFFbkIsRUFBRSxDQUFDLENBQUMsaUJBQWlCLENBQUMsNEJBQTRCLENBQUMsQ0FBQyxDQUFDO1FBQ2pELE9BQU8sQ0FBQyxJQUFJLENBQUMsbUNBQW1DLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBRUQsTUFBTSxDQUFDLHNCQUFzQixDQUFDO1FBQzFCLE9BQU8sRUFBRSxZQUFZLENBQUMsVUFBVSxJQUFJLEtBQUs7UUFDekMsT0FBTyxTQUFBO1FBQ1AsT0FBTyxFQUFFLEVBQUU7S0FDZCxDQUFDLENBQUM7QUFDUCxDQUFDLENBQUMifQ==