"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var crypto = require("crypto");
var fs = require("fs-extra");
var nodepath = require("path");
var pkgDir = require("pkg-dir");
var tsc = require("typescript");
var postprocess_1 = require("./postprocess");
var utils_1 = require("./utils");
function process(src, path, config, transformOptions) {
    if (transformOptions === void 0) { transformOptions = { instrument: false }; }
    var compilerOptions = utils_1.getTSConfig(config.globals, transformOptions.instrument);
    var tsJestConfig = utils_1.getTSJestConfig(config.globals);
    var root = pkgDir.sync();
    var isTsFile = path.endsWith('.ts') || path.endsWith('.tsx');
    var isJsFile = path.endsWith('.js') || path.endsWith('.jsx');
    var isHtmlFile = path.endsWith('.html');
    var postHook = postprocess_1.getPostProcessHook(compilerOptions, config, tsJestConfig);
    if (isHtmlFile && config.globals.__TRANSFORM_HTML__) {
        src = 'module.exports=`' + src + '`;';
    }
    var processFile = compilerOptions.allowJs === true
        ? isTsFile || isJsFile
        : isTsFile;
    if (processFile) {
        var tsTranspiled = tsc.transpileModule(src, {
            compilerOptions: compilerOptions,
            fileName: path,
        });
        var outputText = postHook(tsTranspiled.outputText, path, config, transformOptions);
        path = path.startsWith(root) ? path.substr(root.length) : path;
        if (!config.testRegex || !path.match(config.testRegex)) {
            var outputFilePath = nodepath.join(config.cacheDirectory, '/ts-jest/', new Buffer(path).toString('base64'));
            fs.outputFileSync(outputFilePath, outputText);
        }
        var start = outputText.length > 12 ? outputText.substr(1, 10) : '';
        var modified = start === 'use strict'
            ? "'use strict';require('ts-jest').install();" + outputText
            : "require('ts-jest').install();" + outputText;
        return modified;
    }
    return src;
}
exports.process = process;
function getCacheKey(fileData, filePath, configStr, options) {
    if (options === void 0) { options = { instrument: false }; }
    var jestConfig = JSON.parse(configStr);
    var tsConfig = utils_1.getTSConfig(jestConfig.globals, options.instrument);
    return crypto.createHash('md5')
        .update(JSON.stringify(tsConfig), 'utf8')
        .update(fileData + filePath + configStr, 'utf8')
        .digest('hex');
}
exports.getCacheKey = getCacheKey;
//# sourceMappingURL=data:application/json;base64,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