"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
/**
 * Copyright (c) 2016 shogogg <shogo@studofly.net>
 *
 * This software is released under the MIA License.
 * http://opensource.org/licenses/mit-license.php
 */
var Option = (function () {
    function Option() {
    }
    return Option;
}());
exports.Option = Option;
var Some = (function (_super) {
    __extends(Some, _super);
    function Some(value) {
        _super.call(this);
        this._value = value;
    }
    Some.prototype.exists = function (p) {
        return p(this._value);
    };
    Some.prototype.filter = function (p) {
        return p(this._value) ? this : exports.none;
    };
    Some.prototype.filterNot = function (p) {
        return p(this._value) ? exports.none : this;
    };
    Some.prototype.flatMap = function (f) {
        return f(this._value);
    };
    Some.prototype.fold = function (ifEmpty) {
        var _this = this;
        return function (f) { return f(_this._value); };
    };
    Some.prototype.forAll = function (p) {
        return p(this._value);
    };
    Some.prototype.forEach = function (f) {
        return f(this._value);
    };
    Object.defineProperty(Some.prototype, "get", {
        get: function () {
            return this._value;
        },
        enumerable: true,
        configurable: true
    });
    Some.prototype.getOrElse = function (defaultValue) {
        return this._value;
    };
    Object.defineProperty(Some.prototype, "isDefined", {
        get: function () {
            return true;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Some.prototype, "isEmpty", {
        get: function () {
            return false;
        },
        enumerable: true,
        configurable: true
    });
    Some.prototype.map = function (f) {
        return some(f(this._value));
    };
    Some.prototype.match = function (matcher) {
        return matcher.some(this._value);
    };
    Object.defineProperty(Some.prototype, "nonEmpty", {
        get: function () {
            return true;
        },
        enumerable: true,
        configurable: true
    });
    Some.prototype.orElse = function (alternative) {
        return this;
    };
    Object.defineProperty(Some.prototype, "orNull", {
        get: function () {
            return this._value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Some.prototype, "toArray", {
        get: function () {
            return [this._value];
        },
        enumerable: true,
        configurable: true
    });
    Some.prototype.forComprehension = function () {
        var fns = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            fns[_i - 0] = arguments[_i];
        }
        var result = this;
        for (var i = 0; i < fns.length - 1; i++) {
            result = result.flatMap(fns[i]);
        }
        return result.map(fns[fns.length - 1]);
    };
    return Some;
}(Option));
exports.Some = Some;
var None = (function (_super) {
    __extends(None, _super);
    function None() {
        _super.apply(this, arguments);
    }
    None.prototype.exists = function (p) {
        return false;
    };
    None.prototype.filter = function (p) {
        return this;
    };
    None.prototype.filterNot = function (p) {
        return this;
    };
    None.prototype.flatMap = function (f) {
        return this;
    };
    None.prototype.fold = function (ifEmpty) {
        return function () { return ifEmpty(); };
    };
    None.prototype.forAll = function (p) {
        return false;
    };
    None.prototype.forEach = function (f) {
        // do nothing.
    };
    Object.defineProperty(None.prototype, "get", {
        get: function () {
            throw new Error('No such element.');
        },
        enumerable: true,
        configurable: true
    });
    None.prototype.getOrElse = function (defaultValue) {
        return typeof defaultValue === "function" ? defaultValue() : defaultValue;
    };
    Object.defineProperty(None.prototype, "isDefined", {
        get: function () {
            return false;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(None.prototype, "isEmpty", {
        get: function () {
            return true;
        },
        enumerable: true,
        configurable: true
    });
    None.prototype.map = function (f) {
        return this;
    };
    None.prototype.match = function (matcher) {
        return matcher.none();
    };
    Object.defineProperty(None.prototype, "nonEmpty", {
        get: function () {
            return false;
        },
        enumerable: true,
        configurable: true
    });
    None.prototype.orElse = function (alternative) {
        return alternative();
    };
    Object.defineProperty(None.prototype, "orNull", {
        get: function () {
            return null;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(None.prototype, "toArray", {
        get: function () {
            return [];
        },
        enumerable: true,
        configurable: true
    });
    None.prototype.forComprehension = function () {
        var fns = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            fns[_i - 0] = arguments[_i];
        }
        return this;
    };
    return None;
}(Option));
exports.None = None;
function some(value) {
    return new Some(value);
}
exports.some = some;
exports.none = new None;
function option(value) {
    return value === null || value === undefined ? exports.none : some(value);
}
exports.option = option;
