/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("tsickle/src/tsickle", ["require", "exports", "path", "source-map", "tsickle/src/class_decorator_downlevel_transformer", "tsickle/src/decorator-annotator", "tsickle/src/decorators", "tsickle/src/es5processor", "tsickle/src/fileoverview_comment_transformer", "tsickle/src/jsdoc", "tsickle/src/modules_manifest", "tsickle/src/rewriter", "tsickle/src/source_map_utils", "tsickle/src/transformer_sourcemap", "tsickle/src/transformer_util", "tsickle/src/type-translator", "tsickle/src/typescript", "tsickle/src/util", "tsickle/src/modules_manifest"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var path = require("path");
    var source_map_1 = require("source-map");
    var class_decorator_downlevel_transformer_1 = require("tsickle/src/class_decorator_downlevel_transformer");
    var decorator = require("tsickle/src/decorator-annotator");
    var decorators_1 = require("tsickle/src/decorators");
    var es5processor = require("tsickle/src/es5processor");
    var fileoverview_comment_transformer_1 = require("tsickle/src/fileoverview_comment_transformer");
    var jsdoc = require("tsickle/src/jsdoc");
    var modules_manifest_1 = require("tsickle/src/modules_manifest");
    var rewriter_1 = require("tsickle/src/rewriter");
    var source_map_utils_1 = require("tsickle/src/source_map_utils");
    var transformer_sourcemap_1 = require("tsickle/src/transformer_sourcemap");
    var transformer_util_1 = require("tsickle/src/transformer_util");
    var typeTranslator = require("tsickle/src/type-translator");
    var ts = require("tsickle/src/typescript");
    var util_1 = require("tsickle/src/util");
    var modules_manifest_2 = require("tsickle/src/modules_manifest");
    exports.ModulesManifest = modules_manifest_2.ModulesManifest;
    /**
     * The header to be used in generated externs.  This is not included in the
     * output of annotate() because annotate() works one file at a time, and
     * typically you create one externs file from the entire compilation unit.
     */
    exports.EXTERNS_HEADER = "/**\n * @externs\n * @suppress {duplicate,checkTypes}\n */\n// NOTE: generated by tsickle, do not edit.\n";
    /**
     * Symbols that are already declared as externs in Closure, that should
     * be avoided by tsickle's "declare ..." => externs.js conversion.
     */
    exports.closureExternsBlacklist = [
        'exports',
        'global',
        'module',
        // ErrorConstructor is the interface of the Error object itself.
        // tsickle detects that this is part of the TypeScript standard library
        // and assumes it's part of the Closure standard library, but this
        // assumption is wrong for ErrorConstructor.  To properly handle this
        // we'd somehow need to map methods defined on the ErrorConstructor
        // interface into properties on Closure's Error object, but for now it's
        // simpler to just blacklist it.
        'ErrorConstructor',
        'Symbol',
        'WorkerGlobalScope',
    ];
    function formatDiagnostics(diags) {
        return diags
            .map(function (d) {
            var res = ts.DiagnosticCategory[d.category];
            if (d.file) {
                res += ' at ' + formatLocation(d.file, d.start) + ':';
            }
            res += ' ' + ts.flattenDiagnosticMessageText(d.messageText, '\n');
            return res;
        })
            .join('\n');
    }
    exports.formatDiagnostics = formatDiagnostics;
    /** Returns a fileName:line:column string for the given position in the file. */
    function formatLocation(sf, start) {
        var res = sf.fileName;
        if (start !== undefined) {
            var _a = sf.getLineAndCharacterOfPosition(start), line = _a.line, character = _a.character;
            res += ':' + (line + 1) + ':' + (character + 1);
        }
        return res;
    }
    exports.formatLocation = formatLocation;
    /** @return true if node has the specified modifier flag set. */
    function isAmbient(node) {
        var current = node;
        while (current) {
            if (util_1.hasModifierFlag(current, ts.ModifierFlags.Ambient))
                return true;
            current = current.parent;
        }
        return false;
    }
    /**
     * TypeScript allows you to write identifiers quoted, like:
     *   interface Foo {
     *     'bar': string;
     *     'complex name': string;
     *   }
     *   Foo.bar;  // ok
     *   Foo['bar']  // ok
     *   Foo['complex name']  // ok
     *
     * In Closure-land, we want identify that the legal name 'bar' can become an
     * ordinary field, but we need to skip strings like 'complex name'.
     */
    function isValidClosurePropertyName(name) {
        // In local experimentation, it appears that reserved words like 'var' and
        // 'if' are legal JS and still accepted by Closure.
        return /^[a-zA-Z_][a-zA-Z0-9_]*$/.test(name);
    }
    /** Returns the Closure name of a function parameter, special-casing destructuring. */
    function getParameterName(param, index) {
        switch (param.name.kind) {
            case ts.SyntaxKind.Identifier:
                var name_1 = rewriter_1.getIdentifierText(param.name);
                // TypeScript allows parameters named "arguments", but Closure
                // disallows this, even in externs.
                if (name_1 === 'arguments')
                    name_1 = 'tsickle_arguments';
                return name_1;
            case ts.SyntaxKind.ArrayBindingPattern:
            case ts.SyntaxKind.ObjectBindingPattern:
                // Closure crashes if you put a binding pattern in the externs.
                // Avoid this by just generating an unused name; the name is
                // ignored anyway.
                return "__" + index;
            default:
                // The above list of kinds is exhaustive.  param.name is 'never' at this point.
                var paramName = param.name;
                throw new Error("unhandled function parameter kind: " + ts.SyntaxKind[paramName.kind]);
        }
    }
    /** Flags that declare a field of the same name if set on a ctor parameter. */
    var FIELD_DECLARATION_MODIFIERS = ts.ModifierFlags.Private |
        ts.ModifierFlags.Protected | ts.ModifierFlags.Public | ts.ModifierFlags.Readonly;
    /**
     * A Rewriter subclass that adds Tsickle-specific (Closure translation) functionality.
     *
     * One Rewriter subclass manages .ts => .ts+Closure translation.
     * Another Rewriter subclass manages .ts => externs translation.
     */
    var ClosureRewriter = /** @class */ (function (_super) {
        __extends(ClosureRewriter, _super);
        function ClosureRewriter(typeChecker, file, host, sourceMapper) {
            var _this = _super.call(this, file, sourceMapper) || this;
            _this.typeChecker = typeChecker;
            _this.host = host;
            /**
             * A mapping of aliases for symbols in the current file, used when emitting types.
             * TypeScript emits imported symbols with unpredictable prefixes. To generate correct type
             * annotations, tsickle creates its own aliases for types, and registers them in this map (see
             * `emitImportDeclaration` and `forwardDeclare()` below). The aliases are then used when emitting
             * types.
             */
            _this.symbolsToAliasedNames = new Map();
            return _this;
        }
        /** Finds an exported (i.e. not global) declaration for the given symbol. */
        ClosureRewriter.prototype.findExportedDeclaration = function (sym) {
            var _this = this;
            // TODO(martinprobst): it's unclear when a symbol wouldn't have a declaration, maybe just for
            // some builtins (e.g. Symbol)?
            if (!sym.declarations || sym.declarations.length === 0)
                return undefined;
            // A symbol declared in this file does not need to be imported.
            if (sym.declarations.some(function (d) { return d.getSourceFile() === _this.file; }))
                return undefined;
            // Find an exported declaration.
            // Because tsickle runs with the --declaration flag, all types referenced from exported types
            // must be exported, too, so there must either be some declaration that is exported, or the
            // symbol is actually a global declaration (declared in a script file, not a module).
            var decl = sym.declarations.find(function (d) {
                // Check for Export | Default (default being a default export).
                if (!util_1.hasModifierFlag(d, ts.ModifierFlags.ExportDefault))
                    return false;
                // Exclude symbols declared in `declare global {...}` blocks, they are global and don't need
                // imports.
                var current = d;
                while (current) {
                    if (current.flags & ts.NodeFlags.GlobalAugmentation)
                        return false;
                    current = current.parent;
                }
                return true;
            });
            return decl;
        };
        /**
         * Get the ts.Symbol at a location or throw.
         * The TypeScript API can return undefined when fetching a symbol, but
         * in many contexts we know it won't (e.g. our input is already type-checked).
         */
        ClosureRewriter.prototype.mustGetSymbolAtLocation = function (node) {
            var sym = this.typeChecker.getSymbolAtLocation(node);
            if (!sym)
                throw new Error('no symbol');
            return sym;
        };
        /**
         * Handles emittng the jsdoc for methods, including overloads.
         * If overloaded, merges the signatures in the list of SignatureDeclarations into a single jsdoc.
         * - Total number of parameters will be the maximum count found across all variants.
         * - Different names at the same parameter index will be joined with "_or_"
         * - Variable args (...type[] in TypeScript) will be output as "...type",
         *    except if found at the same index as another argument.
         * @param  fnDecls Pass > 1 declaration for overloads of same name
         * @return The list of parameter names that should be used to emit the actual
         *    function statement; for overloads, name will have been merged.
         */
        ClosureRewriter.prototype.emitFunctionType = function (fnDecls, extraTags) {
            if (extraTags === void 0) { extraTags = []; }
            var typeChecker = this.typeChecker;
            var newDoc = extraTags;
            var lens = fnDecls.map(function (fnDecl) { return fnDecl.parameters.length; });
            var minArgsCount = Math.min.apply(Math, __spread(lens));
            var maxArgsCount = Math.max.apply(Math, __spread(lens));
            var isConstructor = fnDecls.find(function (d) { return d.kind === ts.SyntaxKind.Constructor; }) !== undefined;
            // For each parameter index i, paramTags[i] is an array of parameters
            // that can be found at index i.  E.g.
            //    function foo(x: string)
            //    function foo(y: number, z: string)
            // then paramTags[0] = [info about x, info about y].
            var paramTags = [];
            var returnTags = [];
            var typeParameterNames = new Set();
            try {
                for (var fnDecls_1 = __values(fnDecls), fnDecls_1_1 = fnDecls_1.next(); !fnDecls_1_1.done; fnDecls_1_1 = fnDecls_1.next()) {
                    var fnDecl = fnDecls_1_1.value;
                    // Construct the JSDoc comment by reading the existing JSDoc, if
                    // any, and merging it with the known types of the function
                    // parameters and return type.
                    var docTags = this.getJSDoc(fnDecl) || [];
                    try {
                        // Copy all the tags other than @param/@return into the new
                        // JSDoc without any change; @param/@return are handled specially.
                        // TODO: there may be problems if an annotation doesn't apply to all overloads;
                        // is it worth checking for this and erroring?
                        for (var docTags_1 = __values(docTags), docTags_1_1 = docTags_1.next(); !docTags_1_1.done; docTags_1_1 = docTags_1.next()) {
                            var tag = docTags_1_1.value;
                            if (tag.tagName === 'param' || tag.tagName === 'return')
                                continue;
                            newDoc.push(tag);
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (docTags_1_1 && !docTags_1_1.done && (_a = docTags_1.return)) _a.call(docTags_1);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                    // Add @abstract on "abstract" declarations.
                    if (util_1.hasModifierFlag(fnDecl, ts.ModifierFlags.Abstract)) {
                        newDoc.push({ tagName: 'abstract' });
                    }
                    // Add any @template tags.
                    // Multiple declarations with the same template variable names should work:
                    // the declarations get turned into union types, and Closure Compiler will need
                    // to find a union where all type arguments are satisfied.
                    if (fnDecl.typeParameters) {
                        try {
                            for (var _b = __values(fnDecl.typeParameters), _c = _b.next(); !_c.done; _c = _b.next()) {
                                var tp = _c.value;
                                typeParameterNames.add(rewriter_1.getIdentifierText(tp.name));
                            }
                        }
                        catch (e_2_1) { e_2 = { error: e_2_1 }; }
                        finally {
                            try {
                                if (_c && !_c.done && (_d = _b.return)) _d.call(_b);
                            }
                            finally { if (e_2) throw e_2.error; }
                        }
                    }
                    // Merge the parameters into a single list of merged names and list of types
                    var sig = typeChecker.getSignatureFromDeclaration(fnDecl);
                    if (!sig)
                        throw new Error("invalid signature " + fnDecl.name);
                    for (var i = 0; i < sig.declaration.parameters.length; i++) {
                        var paramNode = sig.declaration.parameters[i];
                        var name_2 = getParameterName(paramNode, i);
                        var isThisParam = name_2 === 'this';
                        var newTag = {
                            tagName: isThisParam ? 'this' : 'param',
                            optional: paramNode.initializer !== undefined || paramNode.questionToken !== undefined,
                            parameterName: isThisParam ? undefined : name_2,
                        };
                        var type = typeChecker.getTypeAtLocation(paramNode);
                        if (paramNode.dotDotDotToken !== undefined) {
                            newTag.restParam = true;
                            // In TypeScript you write "...x: number[]", but in Closure
                            // you don't write the array: "@param {...number} x".  Unwrap
                            // the Array<> wrapper.
                            var typeRef = type;
                            if (!typeRef.typeArguments)
                                throw new Error('invalid rest param');
                            type = typeRef.typeArguments[0];
                        }
                        newTag.type = this.typeToClosure(fnDecl, type);
                        try {
                            for (var docTags_2 = __values(docTags), docTags_2_1 = docTags_2.next(); !docTags_2_1.done; docTags_2_1 = docTags_2.next()) {
                                var _e = docTags_2_1.value, tagName = _e.tagName, parameterName = _e.parameterName, text = _e.text;
                                if (tagName === 'param' && parameterName === newTag.parameterName) {
                                    newTag.text = text;
                                    break;
                                }
                            }
                        }
                        catch (e_3_1) { e_3 = { error: e_3_1 }; }
                        finally {
                            try {
                                if (docTags_2_1 && !docTags_2_1.done && (_f = docTags_2.return)) _f.call(docTags_2);
                            }
                            finally { if (e_3) throw e_3.error; }
                        }
                        if (!paramTags[i])
                            paramTags.push([]);
                        paramTags[i].push(newTag);
                    }
                    // Return type.
                    if (!isConstructor) {
                        var retType = typeChecker.getReturnTypeOfSignature(sig);
                        var retTypeString = this.typeToClosure(fnDecl, retType);
                        var returnDoc = void 0;
                        try {
                            for (var docTags_3 = __values(docTags), docTags_3_1 = docTags_3.next(); !docTags_3_1.done; docTags_3_1 = docTags_3.next()) {
                                var _g = docTags_3_1.value, tagName = _g.tagName, text = _g.text;
                                if (tagName === 'return') {
                                    returnDoc = text;
                                    break;
                                }
                            }
                        }
                        catch (e_4_1) { e_4 = { error: e_4_1 }; }
                        finally {
                            try {
                                if (docTags_3_1 && !docTags_3_1.done && (_h = docTags_3.return)) _h.call(docTags_3);
                            }
                            finally { if (e_4) throw e_4.error; }
                        }
                        returnTags.push({
                            tagName: 'return',
                            type: retTypeString,
                            text: returnDoc,
                        });
                    }
                }
            }
            catch (e_5_1) { e_5 = { error: e_5_1 }; }
            finally {
                try {
                    if (fnDecls_1_1 && !fnDecls_1_1.done && (_j = fnDecls_1.return)) _j.call(fnDecls_1);
                }
                finally { if (e_5) throw e_5.error; }
            }
            if (typeParameterNames.size > 0) {
                newDoc.push({ tagName: 'template', text: Array.from(typeParameterNames.values()).join(', ') });
            }
            // Merge the JSDoc tags for each overloaded parameter.
            // Ensure each parameter has a unique name; the merging process can otherwise
            // accidentally generate the same parameter name twice.
            var paramNames = new Set();
            var foundOptional = false;
            for (var i = 0; i < maxArgsCount; i++) {
                var paramTag = jsdoc.merge(paramTags[i]);
                if (paramNames.has(paramTag.parameterName)) {
                    paramTag.parameterName += i.toString();
                }
                paramNames.add(paramTag.parameterName);
                // If the tag is optional, mark parameters following optional as optional,
                // even if they are not, since Closure restricts this, see
                // https://github.com/google/closure-compiler/issues/2314
                if (!paramTag.restParam && (paramTag.optional || foundOptional || i >= minArgsCount)) {
                    foundOptional = true;
                    paramTag.optional = true;
                }
                newDoc.push(paramTag);
                if (paramTag.restParam) {
                    // Cannot have any parameters after a rest param.
                    // Just dump the remaining parameters.
                    break;
                }
            }
            // Merge the JSDoc tags for each overloaded return.
            if (!isConstructor) {
                newDoc.push(jsdoc.merge(returnTags));
            }
            this.emit('\n' + jsdoc.toString(newDoc));
            return newDoc.filter(function (t) { return t.tagName === 'param'; }).map(function (t) { return t.parameterName; });
            var e_5, _j, e_1, _a, e_2, _d, e_3, _f, e_4, _h;
        };
        /**
         * Returns null if there is no existing comment.
         */
        ClosureRewriter.prototype.getJSDoc = function (node) {
            var text = node.getFullText();
            var comments = ts.getLeadingCommentRanges(text, 0);
            if (!comments || comments.length === 0)
                return null;
            // We need to search backwards for the first JSDoc comment to avoid ignoring such when another
            // code-level comment is between that comment and the function declaration (see
            // testfiles/doc_params for an example).
            var docRelativePos = 0;
            var parsed = null;
            for (var i = comments.length - 1; i >= 0; i--) {
                var _a = comments[i], pos = _a.pos, end = _a.end;
                // end is relative within node.getFullText(), add getFullStart to obtain coordinates that are
                // comparable to node positions.
                var docRelativeEnd = end + node.getFullStart();
                if (docRelativeEnd <= this.file.getStart() &&
                    this.file.text.substring(docRelativeEnd).startsWith('\n\n')) {
                    // This comment is at the very beginning of the file and there's an empty line between the
                    // comment and this node, it's a "detached comment". That means we should treat it as a
                    // file-level comment, not attached to this code node.
                    return null;
                }
                var comment = text.substring(pos, end);
                parsed = jsdoc.parse(comment);
                if (parsed) {
                    docRelativePos = node.getFullStart() + pos;
                    break;
                }
            }
            if (!parsed)
                return null;
            if (parsed.warnings) {
                var start = docRelativePos;
                this.diagnostics.push({
                    file: this.file,
                    start: start,
                    length: node.getStart() - start,
                    messageText: parsed.warnings.join('\n'),
                    category: ts.DiagnosticCategory.Warning,
                    code: 0,
                });
            }
            return parsed.tags;
        };
        ClosureRewriter.prototype.maybeAddTemplateClause = function (docTags, decl) {
            var _this = this;
            if (!decl.typeParameters)
                return;
            // Closure does not support template constraints (T extends X).
            docTags.push({
                tagName: 'template',
                text: decl.typeParameters
                    .map(function (tp) {
                    if (tp.constraint) {
                        _this.emit('\n// unsupported: template constraints.');
                    }
                    return rewriter_1.getIdentifierText(tp.name);
                })
                    .join(', ')
            });
        };
        ClosureRewriter.prototype.maybeAddHeritageClauses = function (docTags, decl) {
            if (!decl.heritageClauses)
                return;
            try {
                for (var _a = __values(decl.heritageClauses), _b = _a.next(); !_b.done; _b = _a.next()) {
                    var heritage = _b.value;
                    if (!heritage.types)
                        continue;
                    var isClass = decl.kind === ts.SyntaxKind.ClassDeclaration;
                    if (isClass && heritage.token !== ts.SyntaxKind.ImplementsKeyword && !isAmbient(decl)) {
                        // If a class has "extends Foo", that is preserved in the ES6 output
                        // and we don't need to do anything.  But if it has "implements Foo",
                        // that is a TS-specific thing and we need to translate it to the
                        // the Closure "@implements {Foo}".
                        // However for ambient declarations, we only emit externs, and in those we do need to
                        // add "@extends {Foo}" as they use ES5 syntax.
                        continue;
                    }
                    try {
                        for (var _c = __values(heritage.types), _d = _c.next(); !_d.done; _d = _c.next()) {
                            var impl = _d.value;
                            var tagName = decl.kind === ts.SyntaxKind.InterfaceDeclaration ? 'extends' : 'implements';
                            // We can only @implements an interface, not a class.
                            // But it's fine to translate TS "implements Class" into Closure
                            // "@extends {Class}" because this is just a type hint.
                            var typeChecker = this.typeChecker;
                            var sym = this.mustGetSymbolAtLocation(impl.expression);
                            var alias = sym;
                            if (sym.flags & ts.SymbolFlags.TypeAlias) {
                                // It's implementing a type alias.  Follow the type alias back
                                // to the original symbol to check whether it's a type or a value.
                                var type = this.typeChecker.getDeclaredTypeOfSymbol(sym);
                                if (!type.symbol) {
                                    // It's not clear when this can happen, but if it does all we
                                    // do is fail to emit the @implements, which isn't so harmful.
                                    continue;
                                }
                                alias = type.symbol;
                            }
                            if (alias.flags & ts.SymbolFlags.Alias) {
                                alias = typeChecker.getAliasedSymbol(alias);
                            }
                            var typeTranslator_1 = this.newTypeTranslator(impl.expression);
                            if (typeTranslator_1.isBlackListed(alias)) {
                                continue;
                            }
                            if (alias.flags & ts.SymbolFlags.Class) {
                                if (!isClass) {
                                    // Only classes can extend classes in TS. Ignoring the heritage clause should be safe,
                                    // as interfaces are @record anyway, so should prevent property disambiguation.
                                    // Problem: validate that methods are there?
                                    continue;
                                }
                                tagName = 'extends';
                            }
                            else if (alias.flags & ts.SymbolFlags.Value) {
                                // If the symbol was already in the value namespace, then it will
                                // not be a type in the Closure output (because Closure collapses
                                // the type and value namespaces).  Just ignore the implements.
                                continue;
                            }
                            // typeToClosure includes nullability modifiers, so call symbolToString directly here.
                            docTags.push({ tagName: tagName, type: typeTranslator_1.symbolToString(sym, true) });
                        }
                    }
                    catch (e_6_1) { e_6 = { error: e_6_1 }; }
                    finally {
                        try {
                            if (_d && !_d.done && (_e = _c.return)) _e.call(_c);
                        }
                        finally { if (e_6) throw e_6.error; }
                    }
                }
            }
            catch (e_7_1) { e_7 = { error: e_7_1 }; }
            finally {
                try {
                    if (_b && !_b.done && (_f = _a.return)) _f.call(_a);
                }
                finally { if (e_7) throw e_7.error; }
            }
            var e_7, _f, e_6, _e;
        };
        /** Emits a type annotation in JSDoc, or {?} if the type is unavailable. */
        ClosureRewriter.prototype.emitJSDocType = function (node, additionalDocTag, type) {
            this.emit(' /**');
            if (additionalDocTag) {
                this.emit(' ' + additionalDocTag);
            }
            this.emit(" @type {" + this.typeToClosure(node, type) + "} */");
        };
        /**
         * Convert a TypeScript ts.Type into the equivalent Closure type.
         *
         * @param context The ts.Node containing the type reference; used for resolving symbols
         *     in context.
         * @param type The type to translate; if not provided, the Node's type will be used.
         * @param resolveAlias If true, do not emit aliases as their symbol, but rather as the resolved
         *     type underlying the alias. This should be true only when emitting the typedef itself.
         */
        ClosureRewriter.prototype.typeToClosure = function (context, type, resolveAlias) {
            if (this.host.untyped) {
                return '?';
            }
            var typeChecker = this.typeChecker;
            if (!type) {
                type = typeChecker.getTypeAtLocation(context);
            }
            return this.newTypeTranslator(context).translate(type, resolveAlias);
        };
        ClosureRewriter.prototype.newTypeTranslator = function (context) {
            var _this = this;
            var translator = new typeTranslator.TypeTranslator(this.typeChecker, context, this.host.typeBlackListPaths, this.symbolsToAliasedNames, function (sym) { return _this.ensureSymbolDeclared(sym); });
            translator.warn = function (msg) { return _this.debugWarn(context, msg); };
            return translator;
        };
        /**
         * debug logs a debug warning.  These should only be used for cases
         * where tsickle is making a questionable judgement about what to do.
         * By default, tsickle does not report any warnings to the caller,
         * and warnings are hidden behind a debug flag, as warnings are only
         * for tsickle to debug itself.
         */
        ClosureRewriter.prototype.debugWarn = function (node, messageText) {
            if (!this.host.logWarning)
                return;
            // Use a ts.Diagnosic so that the warning includes context and file offets.
            var diagnostic = {
                file: this.file,
                start: node.getStart(),
                length: node.getEnd() - node.getStart(),
                messageText: messageText,
                category: ts.DiagnosticCategory.Warning,
                code: 0,
            };
            this.host.logWarning(diagnostic);
        };
        return ClosureRewriter;
    }(rewriter_1.Rewriter));
    var FILEOVERVIEW_COMMENTS = new Set(['fileoverview', 'externs', 'modName', 'mods', 'pintomodule']);
    /** Annotator translates a .ts to a .ts with Closure annotations. */
    var Annotator = /** @class */ (function (_super) {
        __extends(Annotator, _super);
        function Annotator(typeChecker, file, host, tsHost, tsOpts, sourceMapper) {
            var _this = _super.call(this, typeChecker, file, host, sourceMapper) || this;
            _this.tsHost = tsHost;
            _this.tsOpts = tsOpts;
            /** Exported symbol names that have been generated by expanding an "export * from ...". */
            _this.generatedExports = new Set();
            /** Collection of Identifiers used in an `import {foo}` declaration with their Symbol */
            _this.importedNames = [];
            _this.templateSpanStackCount = 0;
            _this.polymerBehaviorStackCount = 0;
            /**
             * The set of module symbols forward declared in the local namespace (with goog.forwarDeclare).
             *
             * Symbols not imported must be declared, which is done by adding forward declares to
             * `extraImports` below.
             */
            _this.forwardDeclaredModules = new Set();
            _this.extraDeclares = '';
            _this.forwardDeclareCounter = 0;
            return _this;
        }
        Annotator.prototype.annotate = function () {
            this.visit(this.file);
            return this.getOutput(this.extraDeclares);
        };
        Annotator.prototype.ensureSymbolDeclared = function (sym) {
            var decl = this.findExportedDeclaration(sym);
            if (!decl)
                return;
            // Actually import the symbol.
            var sf = decl.getSourceFile();
            var moduleSymbol = this.typeChecker.getSymbolAtLocation(sf);
            if (!moduleSymbol) {
                return; // A source file might not have a symbol if it's not a module (no ES6 im/exports).
            }
            // Already imported?
            if (this.forwardDeclaredModules.has(moduleSymbol))
                return;
            // TODO(martinprobst): this should possibly use fileNameToModuleId.
            var text = this.getForwardDeclareText(sf.fileName, moduleSymbol);
            this.extraDeclares += text;
        };
        Annotator.prototype.getExportDeclarationNames = function (node) {
            var _this = this;
            switch (node.kind) {
                case ts.SyntaxKind.VariableStatement:
                    var varDecl = node;
                    return varDecl.declarationList.declarations.map(function (d) { return _this.getExportDeclarationNames(d)[0]; });
                case ts.SyntaxKind.VariableDeclaration:
                case ts.SyntaxKind.FunctionDeclaration:
                case ts.SyntaxKind.InterfaceDeclaration:
                case ts.SyntaxKind.ClassDeclaration:
                case ts.SyntaxKind.ModuleDeclaration:
                    var decl = node;
                    if (!decl.name || decl.name.kind !== ts.SyntaxKind.Identifier) {
                        break;
                    }
                    return [decl.name];
                case ts.SyntaxKind.TypeAliasDeclaration:
                    var typeAlias = node;
                    return [typeAlias.name];
                default:
                    break;
            }
            this.error(node, "unsupported export declaration " + ts.SyntaxKind[node.kind] + ": " + node.getText());
            return [];
        };
        /**
         * Emits an ES6 export for the ambient declaration behind node, if it is indeed exported.
         */
        Annotator.prototype.maybeEmitAmbientDeclarationExport = function (node) {
            // In TypeScript, `export declare` simply generates no code in the exporting module, but does
            // generate a regular import in the importing module.
            // For Closure Compiler, such declarations must still be exported, so that importing code in
            // other modules can reference them. Because tsickle generates global symbols for such types,
            // the appropriate semantics are referencing the global name.
            if (this.host.untyped || !util_1.hasModifierFlag(node, ts.ModifierFlags.Export)) {
                return;
            }
            var declNames = this.getExportDeclarationNames(node);
            try {
                for (var declNames_1 = __values(declNames), declNames_1_1 = declNames_1.next(); !declNames_1_1.done; declNames_1_1 = declNames_1.next()) {
                    var decl = declNames_1_1.value;
                    var sym = this.mustGetSymbolAtLocation(decl);
                    var isValue = sym.flags & ts.SymbolFlags.Value;
                    var declName = rewriter_1.getIdentifierText(decl);
                    if (node.kind === ts.SyntaxKind.VariableStatement) {
                        // For variables, TypeScript rewrites every reference to the variable name as an
                        // "exports." access, to maintain mutable ES6 exports semantics. Indirecting through the
                        // window object means we reference the correct global symbol. Closure Compiler does
                        // understand that "var foo" in externs corresponds to "window.foo".
                        this.emit("\nexports." + declName + " = window." + declName + ";\n");
                    }
                    else if (!isValue) {
                        // Do not emit re-exports for ModuleDeclarations.
                        // Ambient ModuleDeclarations are always referenced as global symbols, so they don't need to
                        // be exported.
                        if (node.kind === ts.SyntaxKind.ModuleDeclaration)
                            continue;
                        // Non-value objects do not exist at runtime, so we cannot access the symbol (it only
                        // exists in externs). Export them as a typedef, which forwards to the type in externs.
                        this.emit("\n/** @typedef {" + declName + "} */\nexports." + declName + ";\n");
                    }
                    else {
                        this.emit("\nexports." + declName + " = " + declName + ";\n");
                    }
                }
            }
            catch (e_8_1) { e_8 = { error: e_8_1 }; }
            finally {
                try {
                    if (declNames_1_1 && !declNames_1_1.done && (_a = declNames_1.return)) _a.call(declNames_1);
                }
                finally { if (e_8) throw e_8.error; }
            }
            var e_8, _a;
        };
        /**
         * Examines a ts.Node and decides whether to do special processing of it for output.
         *
         * @return True if the ts.Node has been handled, false if we should
         *     emit it as is and visit its children.
         */
        Annotator.prototype.maybeProcess = function (node) {
            var _this = this;
            if (util_1.hasModifierFlag(node, ts.ModifierFlags.Ambient) || util_1.isDtsFileName(this.file.fileName)) {
                // An ambient declaration declares types for TypeScript's benefit, so we want to skip Tsickle
                // conversion of its contents.
                this.writeRange(node, node.getFullStart(), node.getEnd());
                // ... but it might need to be exported for downstream importing code.
                this.maybeEmitAmbientDeclarationExport(node);
                return true;
            }
            if (this.currentDecoratorConverter) {
                this.currentDecoratorConverter.beforeProcessNode(node);
            }
            switch (node.kind) {
                case ts.SyntaxKind.SourceFile:
                    this.handleSourceFile(node);
                    return true;
                case ts.SyntaxKind.ImportDeclaration:
                    var importDecl = node;
                    (_a = this.importedNames).push.apply(_a, __spread(decorator.collectImportedNames(this.typeChecker, importDecl)));
                    // No need to forward declare side effect imports.
                    if (!importDecl.importClause)
                        break;
                    // Introduce a goog.forwardDeclare for the module, so that if TypeScript does not emit the
                    // module because it's only used in type positions, the JSDoc comments still reference a
                    // valid Closure level symbol.
                    var sym = this.typeChecker.getSymbolAtLocation(importDecl.moduleSpecifier);
                    // modules might not have a symbol if they are unused.
                    if (!sym)
                        break;
                    // Write the export declaration here so that forward declares come after it, and
                    // fileoverview comments do not get moved behind statements.
                    this.writeNode(importDecl);
                    this.forwardDeclare(importDecl.moduleSpecifier, /* default import? */ !!importDecl.importClause.name);
                    this.addSourceMapping(node);
                    return true;
                case ts.SyntaxKind.ExportDeclaration:
                    var exportDecl = node;
                    var exportedSymbols = [];
                    if (!exportDecl.exportClause && exportDecl.moduleSpecifier) {
                        // It's an "export * from ..." statement.
                        // Rewrite it to re-export each exported symbol directly.
                        exportedSymbols = this.expandSymbolsFromExportStar(exportDecl);
                        var exportSymbolsToEmit = exportedSymbols.filter(function (s) { return _this.shouldEmitExportSymbol(s.sym); });
                        this.writeLeadingTrivia(exportDecl);
                        // Only emit the export if any non-type symbols are exported; otherwise it is not needed,
                        // as type only exports are elided by TS anyway.
                        if (exportSymbolsToEmit.length) {
                            this.emit('export');
                            this.emit(" {" + exportSymbolsToEmit.map(function (e) { return rewriter_1.unescapeName(e.name); }).join(',') + "}");
                            this.emit(' from ');
                            this.visit(exportDecl.moduleSpecifier);
                            this.emit(';');
                            this.addSourceMapping(exportDecl);
                        }
                    }
                    else {
                        // Write the export declaration here so that forward declares come after it, and
                        // fileoverview comments do not get moved behind statements.
                        this.writeNode(exportDecl);
                        if (exportDecl.exportClause) {
                            exportedSymbols = this.getNamedSymbols(exportDecl.exportClause.elements);
                        }
                    }
                    if (exportDecl.moduleSpecifier) {
                        this.forwardDeclare(exportDecl.moduleSpecifier);
                    }
                    if (exportedSymbols.length) {
                        this.emitTypeDefExports(exportedSymbols);
                    }
                    this.addSourceMapping(node);
                    return true;
                case ts.SyntaxKind.InterfaceDeclaration:
                    this.emitInterface(node);
                    // Emit the TS interface verbatim, with no tsickle processing of properties.
                    this.writeRange(node, node.getFullStart(), node.getEnd());
                    return true;
                case ts.SyntaxKind.VariableDeclaration:
                    var varDecl = node;
                    // Only emit a type annotation when it's a plain variable and
                    // not a binding pattern, as Closure doesn't(?) have a syntax
                    // for annotating binding patterns.  See issue #128.
                    // Don't emit type annotation when the variable statement is a @polymerBehavior,
                    // as otherwise the polymer closure checker will fail.
                    // See b/64389806
                    if (this.polymerBehaviorStackCount === 0 &&
                        varDecl.name.kind === ts.SyntaxKind.Identifier) {
                        this.emitJSDocType(varDecl);
                    }
                    return false;
                case ts.SyntaxKind.ClassDeclaration:
                    var classNode = node;
                    this.visitClassDeclaration(classNode);
                    return true;
                case ts.SyntaxKind.PublicKeyword:
                case ts.SyntaxKind.PrivateKeyword:
                    // The "public"/"private" keywords are encountered in two places:
                    // 1) In class fields (which don't appear in the transformed output).
                    // 2) In "parameter properties", e.g.
                    //      constructor(/** @export */ public foo: string).
                    // In case 2 it's important to not emit that JSDoc in the generated
                    // constructor, as this is illegal for Closure.  It's safe to just
                    // always skip comments preceding the 'public' keyword.
                    // See test_files/parameter_properties.ts.
                    this.writeNode(node, /* skipComments */ true);
                    return true;
                case ts.SyntaxKind.Constructor:
                    var ctor = node;
                    this.emitFunctionType([ctor]);
                    // Write the "constructor(...) {" bit, but iterate through any
                    // parameters if given so that we can examine them more closely.
                    this.writeNodeFrom(ctor, ctor.getStart());
                    return true;
                case ts.SyntaxKind.ArrowFunction:
                    // It's difficult to annotate arrow functions due to a bug in
                    // TypeScript (see tsickle issue 57).  For now, just pass them
                    // through unannotated.
                    return false;
                case ts.SyntaxKind.FunctionDeclaration:
                case ts.SyntaxKind.MethodDeclaration:
                case ts.SyntaxKind.GetAccessor:
                case ts.SyntaxKind.SetAccessor:
                    var fnDecl = node;
                    var tags = decorators_1.hasExportingDecorator(node, this.typeChecker) ? [{ tagName: 'export' }] : [];
                    if (!fnDecl.body) {
                        // Two cases: abstract methods and overloaded methods/functions.
                        // Abstract methods are handled in emitTypeAnnotationsHandler.
                        // Overloads are union-ized into the shared type in emitFunctionType.
                        return false;
                    }
                    this.emitFunctionType([fnDecl], tags);
                    this.newTypeTranslator(fnDecl).blacklistTypeParameters(this.symbolsToAliasedNames, fnDecl.typeParameters);
                    this.writeNodeFrom(fnDecl, fnDecl.getStart());
                    return true;
                case ts.SyntaxKind.TypeAliasDeclaration:
                    this.writeNode(node);
                    this.visitTypeAlias(node);
                    return true;
                case ts.SyntaxKind.EnumDeclaration:
                    this.processEnum(node);
                    return true;
                case ts.SyntaxKind.TemplateSpan:
                    this.templateSpanStackCount++;
                    this.writeNode(node);
                    this.templateSpanStackCount--;
                    return true;
                case ts.SyntaxKind.TypeAssertionExpression:
                case ts.SyntaxKind.AsExpression:
                    // Both of these cases are AssertionExpressions.
                    var typeAssertion = node;
                    if (this.polymerBehaviorStackCount > 0) {
                        // Don't emit type casts for Polymer behaviors that are declared
                        // by calling the Polymer function
                        // as the Polymer closure plugin does not work when emitting them.
                        // See b/64389806.
                        // Note: This only matters in the transformer version of tsickle,
                        // as the non transformer version never emitted type casts due to
                        // https://github.com/Microsoft/TypeScript/issues/9873 (see below).
                        return false;
                    }
                    // When using a type casts in template expressions,
                    // closure requires another pair of parens, otherwise it will
                    // complain with "Misplaced type annotation. Type annotations are not allowed here."
                    if (this.templateSpanStackCount > 0) {
                        this.emit('(');
                    }
                    this.emitJSDocType(typeAssertion);
                    // When TypeScript emits JS, it removes one layer of "redundant"
                    // parens, but we need them for the Closure type assertion.  Work
                    // around this by using two parens.  See test_files/coerce.*.
                    // This is needed in both, the transformer and non transformer version.
                    // TODO: in the non transformer version, the comment is currently dropped
                    //  alltegether from pure assignments due to
                    //  https://github.com/Microsoft/TypeScript/issues/9873.
                    this.emit('((');
                    this.writeNode(node);
                    this.emit('))');
                    if (this.templateSpanStackCount > 0) {
                        this.emit(')');
                    }
                    return true;
                case ts.SyntaxKind.NonNullExpression:
                    var nnexpr = node;
                    var type = this.typeChecker.getTypeAtLocation(nnexpr.expression);
                    if (type.flags & ts.TypeFlags.Union) {
                        var nonNullUnion = type
                            .types.filter(function (t) { return (t.flags & (ts.TypeFlags.Null | ts.TypeFlags.Undefined)) === 0; });
                        var typeCopy = Object.assign({}, type);
                        typeCopy.types = nonNullUnion;
                        type = typeCopy;
                    }
                    // See comment above.
                    if (this.templateSpanStackCount > 0) {
                        this.emit('(');
                    }
                    this.emitJSDocType(nnexpr, undefined, type);
                    // See comment above.
                    this.emit('((');
                    this.writeNode(nnexpr.expression);
                    this.emit('))');
                    if (this.templateSpanStackCount > 0) {
                        this.emit(')');
                    }
                    return true;
                case ts.SyntaxKind.PropertyDeclaration:
                case ts.SyntaxKind.VariableStatement:
                    var docTags = this.getJSDoc(node) || [];
                    if (decorators_1.hasExportingDecorator(node, this.typeChecker)) {
                        docTags.push({ tagName: 'export' });
                    }
                    if (docTags.length > 0 && node.getFirstToken()) {
                        this.emit('\n');
                        this.emit(jsdoc.toString(docTags));
                        var isPolymerBehavior = docTags.some(function (t) { return t.tagName === 'polymerBehavior'; });
                        if (isPolymerBehavior) {
                            this.polymerBehaviorStackCount++;
                        }
                        this.writeNodeFrom(node, node.getStart());
                        if (isPolymerBehavior) {
                            this.polymerBehaviorStackCount--;
                        }
                        return true;
                    }
                    break;
                case ts.SyntaxKind.PropertyAssignment:
                    var pa = node;
                    if (isPolymerBehaviorPropertyInCallExpression(pa)) {
                        this.polymerBehaviorStackCount++;
                        this.writeNodeFrom(node, node.getStart());
                        this.polymerBehaviorStackCount--;
                        return true;
                    }
                    return false;
                case ts.SyntaxKind.ElementAccessExpression:
                    // Warn for quoted accesses to properties that have a symbol declared.
                    // Mixing quoted and non-quoted access to a symbol (x['foo'] and x.foo) risks breaking
                    // Closure Compiler renaming. Quoted access is more cumbersome to write than dotted access
                    // though, so chances are users did intend to avoid renaming. The better fix is to use
                    // `declare interface` though.
                    var eae = node;
                    if (!eae.argumentExpression ||
                        eae.argumentExpression.kind !== ts.SyntaxKind.StringLiteral) {
                        return false;
                    }
                    var quotedPropSym = this.typeChecker.getSymbolAtLocation(eae.argumentExpression);
                    // If it has a symbol, it's actually a regular declared property.
                    if (!quotedPropSym)
                        return false;
                    var declarationHasQuotes = !quotedPropSym.declarations || quotedPropSym.declarations.some(function (d) {
                        var decl = d;
                        if (!decl.name)
                            return false;
                        return decl.name.kind === ts.SyntaxKind.StringLiteral;
                    });
                    // If the property is declared with quotes, it should also be accessed with them.
                    if (declarationHasQuotes)
                        return false;
                    var propName = eae.argumentExpression.text;
                    // Properties containing non-JS identifier names can only be accessed with quotes.
                    if (!isValidClosurePropertyName(propName))
                        return false;
                    var symName = this.typeChecker.symbolToString(quotedPropSym);
                    this.debugWarn(eae, "Declared property " + symName + " accessed with quotes. " +
                        "This can lead to renaming bugs. A better fix is to use 'declare interface' " +
                        "on the declaration.");
                    // Previously, the code below changed the quoted into a non-quoted access.
                    // this.writeNode(eae.expression);
                    // this.emit(`.${propName}`);
                    return false;
                case ts.SyntaxKind.PropertyAccessExpression:
                    // Convert dotted accesses to types that have an index type declared to quoted accesses, to
                    // avoid Closure renaming one access but not the other.
                    // This can happen because TS allows dotted access to string index types.
                    var pae = node;
                    var t = this.typeChecker.getTypeAtLocation(pae.expression);
                    if (!t.getStringIndexType())
                        return false;
                    // Types can have string index signatures and declared properties (of the matching type).
                    // These properties have a symbol, as opposed to pure string index types.
                    var propSym = this.typeChecker.getSymbolAtLocation(pae.name);
                    // The decision to return below is a judgement call. Presumably, in most situations, dotted
                    // access to a property is correct, and should not be turned into quoted access even if
                    // there is a string index on the type. However it is possible to construct programs where
                    // this is incorrect, e.g. where user code assigns into a property through the index access
                    // in another location.
                    if (propSym)
                        return false;
                    this.debugWarn(pae, this.typeChecker.typeToString(t) +
                        " has a string index type but is accessed using dotted access. " +
                        "Quoting the access.");
                    this.writeNode(pae.expression);
                    this.emit('["');
                    this.writeNode(pae.name);
                    this.emit('"]');
                    return true;
                case ts.SyntaxKind.Decorator:
                    if (this.currentDecoratorConverter) {
                        return this.currentDecoratorConverter.maybeProcessDecorator(node);
                    }
                    return false;
                default:
                    break;
            }
            return false;
            var _a;
        };
        Annotator.prototype.shouldEmitExportSymbol = function (sym) {
            if (sym.flags & ts.SymbolFlags.Alias) {
                sym = this.typeChecker.getAliasedSymbol(sym);
            }
            if ((sym.flags & ts.SymbolFlags.Value) === 0) {
                // Note: We create explicit reexports via closure at another place in
                return false;
            }
            if (sym.flags & ts.SymbolFlags.ConstEnum) {
                return false;
            }
            return true;
        };
        Annotator.prototype.handleSourceFile = function (sf) {
            // Emit leading detached comments: comments separated by a \n\n from the document.
            // While handlers below generally emit comments preceding them, not all of them do in all
            // situations (e.g. JSDoc preceding a class).
            // This is symmetric with `getJSDoc` below not returning detached file level comments.
            var comments = ts.getLeadingCommentRanges(sf.text, 0) || [];
            var start = sf.getFullStart();
            for (var i = comments.length - 1; i >= 0; i--) {
                if (sf.text.substring(comments[i].end, comments[i].end + 2) === '\n\n') {
                    this.emit(sf.text.substring(0, comments[i].end + 2));
                    start = comments[i].end + 2;
                    break;
                }
            }
            this.writeNodeFrom(sf, start);
        };
        /**
         * Given a "export * from ..." statement, gathers the symbol names it actually
         * exports to be used in a statement like "export {foo, bar, baz} from ...".
         *
         * This is necessary because TS transpiles "export *" by just doing a runtime loop
         * over the target module's exports, which means Closure won't see the declarations/types
         * that are exported.
         */
        Annotator.prototype.expandSymbolsFromExportStar = function (exportDecl) {
            // You can't have an "export *" without a module specifier.
            var moduleSpecifier = exportDecl.moduleSpecifier;
            // Gather the names of local exports, to avoid reexporting any
            // names that are already locally exported.
            var moduleSymbol = this.typeChecker.getSymbolAtLocation(this.file);
            var moduleExports = moduleSymbol && moduleSymbol.exports || new Map();
            // Expand the export list, then filter it to the symbols we want to reexport.
            var exports = this.typeChecker.getExportsOfModule(this.mustGetSymbolAtLocation(moduleSpecifier));
            var reexports = new Set();
            try {
                for (var exports_1 = __values(exports), exports_1_1 = exports_1.next(); !exports_1_1.done; exports_1_1 = exports_1.next()) {
                    var sym = exports_1_1.value;
                    var name_3 = rewriter_1.unescapeName(sym.name);
                    if (moduleExports instanceof Map) {
                        if (moduleExports.has(name_3)) {
                            // This name is shadowed by a local definition, such as:
                            // - export var foo ...
                            // - export {foo} from ...
                            // - export {bar as foo} from ...
                            continue;
                        }
                    }
                    else {
                        // TODO(#634): check if this is a safe cast.
                        if (moduleExports.has(name_3))
                            continue;
                    }
                    if (this.generatedExports.has(name_3)) {
                        // Already exported via an earlier expansion of an "export * from ...".
                        continue;
                    }
                    this.generatedExports.add(name_3);
                    reexports.add(sym);
                }
            }
            catch (e_9_1) { e_9 = { error: e_9_1 }; }
            finally {
                try {
                    if (exports_1_1 && !exports_1_1.done && (_a = exports_1.return)) _a.call(exports_1);
                }
                finally { if (e_9) throw e_9.error; }
            }
            return Array.from(reexports.keys()).map(function (sym) {
                return { name: sym.name, sym: sym };
            });
            var e_9, _a;
        };
        /**
         * Write an `exports.` assignment for each type alias exported in the given `exports`.
         * TypeScript by itself does not export non-value symbols (e.g. interfaces, typedefs), as it
         * expects to remove those entirely for runtime. For Closure, types must be
         * exported as downstream code will import the type.
         *
         * The tsickle pass turns interfaces into values by generating a `function MyInterface() {}` for
         * them, so in the second conversion pass, TypeScript does export a value for them. However for
         * pure typedefs, tsickle only generates a property access with a JSDoc comment, so they need to
         * be exported explicitly here.
         */
        Annotator.prototype.emitTypeDefExports = function (exports) {
            if (this.host.untyped)
                return;
            try {
                for (var exports_2 = __values(exports), exports_2_1 = exports_2.next(); !exports_2_1.done; exports_2_1 = exports_2.next()) {
                    var exp = exports_2_1.value;
                    if (exp.sym.flags & ts.SymbolFlags.Alias)
                        exp.sym = this.typeChecker.getAliasedSymbol(exp.sym);
                    var isTypeAlias = ((exp.sym.flags & ts.SymbolFlags.TypeAlias) !== 0 &&
                        (exp.sym.flags & ts.SymbolFlags.Value) === 0) ||
                        (exp.sym.flags & ts.SymbolFlags.Interface) !== 0 &&
                            (exp.sym.flags & ts.SymbolFlags.Value) === 0;
                    if (!isTypeAlias)
                        continue;
                    var typeName = this.symbolsToAliasedNames.get(exp.sym) || exp.sym.name;
                    this.emit("/** @typedef {" + typeName + "} */\nexports." + exp.name + "; // re-export typedef\n");
                }
            }
            catch (e_10_1) { e_10 = { error: e_10_1 }; }
            finally {
                try {
                    if (exports_2_1 && !exports_2_1.done && (_a = exports_2.return)) _a.call(exports_2);
                }
                finally { if (e_10) throw e_10.error; }
            }
            var e_10, _a;
        };
        Annotator.prototype.getNamedSymbols = function (specifiers) {
            var _this = this;
            return specifiers.map(function (e) {
                return {
                    // e.name might be renaming symbol as in `export {Foo as Bar}`, where e.name would be 'Bar'
                    // and != sym.name. Store away the name so forwardDeclare below can emit the right name.
                    name: rewriter_1.getIdentifierText(e.name),
                    sym: _this.mustGetSymbolAtLocation(e.name),
                };
            });
        };
        /**
         * Emits a `goog.forwardDeclare` alias for each symbol from the given list.
         * @param specifier the import specifier, i.e. module path ("from '...'").
         */
        Annotator.prototype.forwardDeclare = function (specifier, isDefaultImport) {
            if (isDefaultImport === void 0) { isDefaultImport = false; }
            var importPath = es5processor.resolveIndexShorthand({ options: this.tsOpts, host: this.tsHost }, this.file.fileName, specifier.text);
            var moduleSymbol = this.typeChecker.getSymbolAtLocation(specifier);
            this.emit(this.getForwardDeclareText(importPath, moduleSymbol, isDefaultImport));
        };
        /**
         * Returns the `const x = goog.forwardDeclare...` text for an import of the given `importPath`.
         * This also registers aliases for symbols from the module that map to this forward declare.
         */
        Annotator.prototype.getForwardDeclareText = function (importPath, moduleSymbol, isDefaultImport) {
            if (isDefaultImport === void 0) { isDefaultImport = false; }
            if (this.host.untyped)
                return '';
            var nsImport = es5processor.extractGoogNamespaceImport(importPath);
            var forwardDeclarePrefix = "tsickle_forward_declare_" + ++this.forwardDeclareCounter;
            var moduleNamespace = nsImport !== null ? nsImport : this.host.pathToModuleName(this.file.fileName, importPath);
            // In TypeScript, importing a module for use in a type annotation does not cause a runtime load.
            // In Closure Compiler, goog.require'ing a module causes a runtime load, so emitting requires
            // here would cause a change in load order, which is observable (and can lead to errors).
            // Instead, goog.forwardDeclare types, which allows using them in type annotations without
            // causing a load. See below for the exception to the rule.
            var emitText = "const " + forwardDeclarePrefix + " = goog.forwardDeclare(\"" + moduleNamespace + "\");\n";
            // Scripts do not have a symbol. Scripts can still be imported, either as side effect imports or
            // with an empty import set ("{}"). TypeScript does not emit a runtime load for an import with
            // an empty list of symbols, but the import forces any global declarations from the library to
            // be visible, which is what users use this for. No symbols from the script need forward
            // declaration, so just return.
            if (!moduleSymbol)
                return '';
            this.forwardDeclaredModules.add(moduleSymbol);
            var exports = this.typeChecker.getExportsOfModule(moduleSymbol);
            var hasValues = exports.some(function (e) {
                var isValue = (e.flags & ts.SymbolFlags.Value) !== 0;
                var isConstEnum = (e.flags & ts.SymbolFlags.ConstEnum) !== 0;
                // const enums are inlined by TypeScript (if preserveConstEnums=false), so there is never a
                // value import generated for them. That means for the purpose of force-importing modules,
                // they do not count as values. If preserveConstEnums=true, this shouldn't hurt.
                return isValue && !isConstEnum;
            });
            if (!hasValues) {
                // Closure Compiler's toolchain will drop files that are never goog.require'd *before* type
                // checking (e.g. when using --closure_entry_point or similar tools). This causes errors
                // complaining about values not matching 'NoResolvedType', or modules not having a certain
                // member.
                // To fix, explicitly goog.require() modules that only export types. This should usually not
                // cause breakages due to load order (as no symbols are accessible from the module - though
                // contrived code could observe changes in side effects).
                // This is a heuristic - if the module exports some values, but those are never imported,
                // the file will still end up not being imported. Hopefully modules that export values are
                // imported for their value in some place.
                emitText += "goog.require(\"" + moduleNamespace + "\"); // force type-only module to be loaded\n";
            }
            try {
                for (var exports_3 = __values(exports), exports_3_1 = exports_3.next(); !exports_3_1.done; exports_3_1 = exports_3.next()) {
                    var sym = exports_3_1.value;
                    if (sym.flags & ts.SymbolFlags.Alias) {
                        sym = this.typeChecker.getAliasedSymbol(sym);
                    }
                    // goog: imports don't actually use the .default property that TS thinks they have.
                    var qualifiedName = nsImport && isDefaultImport ? forwardDeclarePrefix :
                        forwardDeclarePrefix + '.' + sym.name;
                    this.symbolsToAliasedNames.set(sym, qualifiedName);
                }
            }
            catch (e_11_1) { e_11 = { error: e_11_1 }; }
            finally {
                try {
                    if (exports_3_1 && !exports_3_1.done && (_a = exports_3.return)) _a.call(exports_3);
                }
                finally { if (e_11) throw e_11.error; }
            }
            return emitText;
            var e_11, _a;
        };
        Annotator.prototype.visitClassDeclaration = function (classDecl) {
            this.addSourceMapping(classDecl);
            var oldDecoratorConverter = this.currentDecoratorConverter;
            this.currentDecoratorConverter =
                new decorator.DecoratorClassVisitor(this.typeChecker, this, classDecl, this.importedNames);
            var docTags = this.getJSDoc(classDecl) || [];
            if (util_1.hasModifierFlag(classDecl, ts.ModifierFlags.Abstract)) {
                docTags.push({ tagName: 'abstract' });
            }
            if (!this.host.untyped) {
                this.maybeAddTemplateClause(docTags, classDecl);
                this.maybeAddHeritageClauses(docTags, classDecl);
            }
            this.emit('\n');
            if (docTags.length > 0)
                this.emit(jsdoc.toString(docTags));
            decorator.visitClassContentIncludingDecorators(classDecl, this, this.currentDecoratorConverter);
            this.emitTypeAnnotationsHelper(classDecl);
            this.currentDecoratorConverter = oldDecoratorConverter;
            return true;
        };
        Annotator.prototype.emitInterface = function (iface) {
            // If this symbol is both a type and a value, we cannot emit both into Closure's
            // single namespace.
            var sym = this.mustGetSymbolAtLocation(iface.name);
            if (sym.flags & ts.SymbolFlags.Value)
                return;
            var docTags = this.getJSDoc(iface) || [];
            docTags.push({ tagName: 'record' });
            if (!this.host.untyped) {
                this.maybeAddTemplateClause(docTags, iface);
                this.maybeAddHeritageClauses(docTags, iface);
            }
            this.emit('\n');
            this.emit(jsdoc.toString(docTags));
            if (util_1.hasModifierFlag(iface, ts.ModifierFlags.Export))
                this.emit('export ');
            var name = rewriter_1.getIdentifierText(iface.name);
            this.emit("function " + name + "() {}\n");
            this.emit("\n\nfunction " + name + "_tsickle_Closure_declarations() {\n");
            var memberNamespace = [name, 'prototype'];
            try {
                for (var _a = __values(iface.members), _b = _a.next(); !_b.done; _b = _a.next()) {
                    var elem = _b.value;
                    var isOptional = elem.questionToken != null;
                    this.visitProperty(memberNamespace, elem, isOptional);
                }
            }
            catch (e_12_1) { e_12 = { error: e_12_1 }; }
            finally {
                try {
                    if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                }
                finally { if (e_12) throw e_12.error; }
            }
            this.emit("}\n");
            var e_12, _c;
        };
        /**
         * emitTypeAnnotationsHelper produces a _tsickle_typeAnnotationsHelper() where
         * none existed in the original source. It's necessary in the case where
         * TypeScript syntax specifies there are additional properties on the class,
         * because to declare these in Closure you must declare these in a method
         * somewhere.
         */
        Annotator.prototype.emitTypeAnnotationsHelper = function (classDecl) {
            var _this = this;
            // Gather parameter properties from the constructor, if it exists.
            var ctors = [];
            var paramProps = [];
            var nonStaticProps = [];
            var staticProps = [];
            var abstractMethods = [];
            try {
                for (var _a = __values(classDecl.members), _b = _a.next(); !_b.done; _b = _a.next()) {
                    var member = _b.value;
                    if (member.kind === ts.SyntaxKind.Constructor) {
                        ctors.push(member);
                    }
                    else if (member.kind === ts.SyntaxKind.PropertyDeclaration) {
                        var prop = member;
                        var isStatic = util_1.hasModifierFlag(prop, ts.ModifierFlags.Static);
                        if (isStatic) {
                            staticProps.push(prop);
                        }
                        else {
                            nonStaticProps.push(prop);
                        }
                    }
                    else if (util_1.hasModifierFlag(member, ts.ModifierFlags.Abstract) &&
                        (member.kind === ts.SyntaxKind.MethodDeclaration ||
                            member.kind === ts.SyntaxKind.GetAccessor ||
                            member.kind === ts.SyntaxKind.SetAccessor)) {
                        abstractMethods.push(member);
                    }
                }
            }
            catch (e_13_1) { e_13 = { error: e_13_1 }; }
            finally {
                try {
                    if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                }
                finally { if (e_13) throw e_13.error; }
            }
            if (ctors.length > 0) {
                var ctor = ctors[0];
                paramProps = ctor.parameters.filter(function (p) { return util_1.hasModifierFlag(p, FIELD_DECLARATION_MODIFIERS); });
            }
            if (nonStaticProps.length === 0 && paramProps.length === 0 && staticProps.length === 0 &&
                abstractMethods.length === 0 &&
                !(this.currentDecoratorConverter && this.currentDecoratorConverter.foundDecorators())) {
                // There are no members so we don't need to emit any type
                // annotations helper.
                return;
            }
            if (!classDecl.name)
                return;
            var className = rewriter_1.getIdentifierText(classDecl.name);
            this.emit("\n\nfunction " + className + "_tsickle_Closure_declarations() {\n");
            if (this.currentDecoratorConverter) {
                this.currentDecoratorConverter.emitMetadataTypeAnnotationsHelpers();
            }
            staticProps.forEach(function (p) { return _this.visitProperty([className], p); });
            var memberNamespace = [className, 'prototype'];
            nonStaticProps.forEach(function (p) { return _this.visitProperty(memberNamespace, p); });
            paramProps.forEach(function (p) { return _this.visitProperty(memberNamespace, p); });
            try {
                for (var abstractMethods_1 = __values(abstractMethods), abstractMethods_1_1 = abstractMethods_1.next(); !abstractMethods_1_1.done; abstractMethods_1_1 = abstractMethods_1.next()) {
                    var fnDecl = abstractMethods_1_1.value;
                    var name_4 = this.propertyName(fnDecl);
                    if (!name_4) {
                        this.error(fnDecl, 'anonymous abstract function');
                        continue;
                    }
                    var tags = decorators_1.hasExportingDecorator(fnDecl, this.typeChecker) ? [{ tagName: 'export' }] : [];
                    var paramNames = this.emitFunctionType([fnDecl], tags);
                    // memberNamespace because abstract methods cannot be static in TypeScript.
                    this.emit(memberNamespace.join('.') + "." + name_4 + " = function(" + paramNames.join(', ') + ") {};\n");
                }
            }
            catch (e_14_1) { e_14 = { error: e_14_1 }; }
            finally {
                try {
                    if (abstractMethods_1_1 && !abstractMethods_1_1.done && (_d = abstractMethods_1.return)) _d.call(abstractMethods_1);
                }
                finally { if (e_14) throw e_14.error; }
            }
            this.emit("}\n");
            var e_13, _c, e_14, _d;
        };
        Annotator.prototype.propertyName = function (prop) {
            if (!prop.name)
                return null;
            switch (prop.name.kind) {
                case ts.SyntaxKind.Identifier:
                    return rewriter_1.getIdentifierText(prop.name);
                case ts.SyntaxKind.StringLiteral:
                    // E.g. interface Foo { 'bar': number; }
                    // If 'bar' is a name that is not valid in Closure then there's nothing we can do.
                    var text = prop.name.text;
                    if (!isValidClosurePropertyName(text))
                        return null;
                    return text;
                default:
                    return null;
            }
        };
        /**
         * @param optional If true, property is optional (e.g. written "foo?: string").
         */
        Annotator.prototype.visitProperty = function (namespace, prop, optional) {
            if (optional === void 0) { optional = false; }
            var name = this.propertyName(prop);
            if (!name) {
                this.emit("/* TODO: handle strange member:\n" + this.escapeForComment(prop.getText()) + "\n*/\n");
                return;
            }
            var type = this.typeToClosure(prop);
            // When a property is optional, e.g.
            //   foo?: string;
            // Then the TypeScript type of the property is string|undefined, the
            // typeToClosure translation handles it correctly, and string|undefined is
            // how you write an optional property in Closure.
            //
            // But in the special case of an optional property with type any:
            //   foo?: any;
            // The TypeScript type of the property is just "any" (because any includes
            // undefined as well) so our default translation of the type is just "?".
            // To mark the property as optional in Closure it must have "|undefined",
            // so the Closure type must be ?|undefined.
            if (optional && type === '?')
                type += '|undefined';
            var tags = this.getJSDoc(prop) || [];
            tags.push({ tagName: 'type', type: type });
            if (decorators_1.hasExportingDecorator(prop, this.typeChecker)) {
                tags.push({ tagName: 'export' });
            }
            // Avoid printing annotations that can conflict with @type
            // This avoids Closure's error "type annotation incompatible with other annotations"
            this.emit(jsdoc.toString(tags, new Set(['param', 'return'])));
            namespace = namespace.concat([name]);
            this.emit(namespace.join('.') + ";\n");
        };
        Annotator.prototype.visitTypeAlias = function (node) {
            if (this.host.untyped)
                return;
            // If the type is also defined as a value, skip emitting it. Closure collapses type & value
            // namespaces, the two emits would conflict if tsickle emitted both.
            var sym = this.mustGetSymbolAtLocation(node.name);
            if (sym.flags & ts.SymbolFlags.Value)
                return;
            // Write a Closure typedef, which involves an unused "var" declaration.
            // Note: in the case of an export, we cannot emit a literal "var" because
            // TypeScript drops exports that are never assigned to (and Closure
            // requires us to not assign to typedef exports).  Instead, emit the
            // "exports.foo;" line directly in that case.
            this.newTypeTranslator(node).blacklistTypeParameters(this.symbolsToAliasedNames, node.typeParameters);
            var typeStr = this.typeToClosure(node, undefined, true /* resolveAlias */);
            this.emit("\n/** @typedef {" + typeStr + "} */\n");
            if (util_1.hasModifierFlag(node, ts.ModifierFlags.Export)) {
                this.emit('exports.');
            }
            else {
                this.emit('var ');
            }
            this.emit(node.name.getText() + ";\n");
        };
        /**
         * getEnumType computes the Closure type of an enum, by iterating through the members
         * and gathering their types.
         */
        Annotator.prototype.getEnumType = function (enumDecl) {
            var hasNumber = false;
            var hasString = false;
            try {
                for (var _a = __values(enumDecl.members), _b = _a.next(); !_b.done; _b = _a.next()) {
                    var member = _b.value;
                    if (member.initializer) {
                        var type = this.typeChecker.getTypeAtLocation(member.initializer);
                        // Note: checking against 'NumberLike' instead of just 'Number' means this code
                        // handles both
                        //   MEMBER = 3,  // TypeFlags.NumberLiteral
                        // and
                        //   MEMBER = someFunction(),  // TypeFlags.Number
                        if (type.flags & ts.TypeFlags.NumberLike) {
                            hasNumber = true;
                        }
                        else if (type.flags & ts.TypeFlags.StringLike) {
                            hasString = true;
                        }
                        else {
                            // Enum contains something other than a string or a number; bail.
                            return '?';
                        }
                    }
                    else {
                        // Members without initializers default to numeric.
                        hasNumber = true;
                    }
                }
            }
            catch (e_15_1) { e_15 = { error: e_15_1 }; }
            finally {
                try {
                    if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                }
                finally { if (e_15) throw e_15.error; }
            }
            if (hasNumber && hasString) {
                return '?'; // Closure's new type inference doesn't support enums of unions.
            }
            else if (hasNumber) {
                return 'number';
            }
            else if (hasString) {
                return 'string';
            }
            else {
                // Perhaps an empty enum?
                return '?';
            }
            var e_15, _c;
        };
        /**
         * Processes an EnumDeclaration into a Closure type. Always emits a Closure type, even in untyped
         * mode, as that should be harmless (it only ever uses the number type).
         */
        Annotator.prototype.processEnum = function (node) {
            // Emit the enum declaration, which looks like:
            //   /** @enum {number} */
            //   const Foo = {BAR: 0, BAZ: 1, ...};
            //   export {Foo};  // even if originally exported on one line.
            // This declares an enum type for Closure Compiler (and Closure JS users of this TS code).
            // Splitting the enum into declaration and export is required so that local references to the
            // type resolve ("@type {Foo}").
            this.emit('\n');
            var name = node.name.getText();
            var enumType = this.getEnumType(node);
            this.emit("/** @enum {" + enumType + "} */\n");
            this.emit("const " + name + ": DontTypeCheckMe = {");
            // Emit enum values ('BAR: 0,').
            var enumIndex = 0;
            try {
                for (var _a = __values(node.members), _b = _a.next(); !_b.done; _b = _a.next()) {
                    var member = _b.value;
                    var memberName = member.name.getText();
                    // Emit any comments and leading whitespace on the enum value definition.
                    this.writeLeadingTrivia(member);
                    this.emit(memberName + ": ");
                    if (member.initializer) {
                        var enumConstValue = this.typeChecker.getConstantValue(member);
                        if (typeof enumConstValue === 'number') {
                            enumIndex = enumConstValue + 1;
                            this.emit(enumConstValue.toString());
                        }
                        else {
                            // Non-numeric enum value (string or an expression).
                            // Emit this initializer expression as-is.
                            // Note: if the member's initializer expression refers to another
                            // value within the enum (e.g. something like
                            //   enum Foo {
                            //     Field1,
                            //     Field2 = Field1 + something(),
                            //   }
                            // Then when we emit the initializer we produce invalid code because
                            // on the Closure side the reference to Field1 has to be namespaced,
                            // e.g. written "Foo.Field1 + something()".
                            // Hopefully this doesn't come up often -- if the enum instead has
                            // something like
                            //     Field2 = Field1 + 3,
                            // then it's still a constant expression and we inline the constant
                            // value in the above branch of this "if" statement.
                            this.visit(member.initializer);
                        }
                    }
                    else {
                        this.emit(enumIndex.toString());
                        enumIndex++;
                    }
                    this.emit(',');
                }
            }
            catch (e_16_1) { e_16 = { error: e_16_1 }; }
            finally {
                try {
                    if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                }
                finally { if (e_16) throw e_16.error; }
            }
            this.emit('};\n');
            var isExported = util_1.hasModifierFlag(node, ts.ModifierFlags.Export);
            if (isExported)
                this.emit("export {" + name + "};\n");
            if (util_1.hasModifierFlag(node, ts.ModifierFlags.Const)) {
                // By TypeScript semantics, const enums disappear after TS compilation.
                // We still need to generate the runtime value above to make Closure Compiler's type system
                // happy and allow refering to enums from JS code, but we should at least not emit string
                // value mappings.
                return;
            }
            // Emit the reverse mapping of foo[foo.BAR] = 'BAR'; lines for number enums.
            if (enumType === 'number') {
                try {
                    for (var _d = __values(node.members), _e = _d.next(); !_e.done; _e = _d.next()) {
                        var member = _e.value;
                        var memberName = member.name.getText();
                        this.emit(name + "[" + name + "." + memberName + "] = \"" + memberName + "\";\n");
                    }
                }
                catch (e_17_1) { e_17 = { error: e_17_1 }; }
                finally {
                    try {
                        if (_e && !_e.done && (_f = _d.return)) _f.call(_d);
                    }
                    finally { if (e_17) throw e_17.error; }
                }
            }
            var e_16, _c, e_17, _f;
        };
        return Annotator;
    }(ClosureRewriter));
    /** ExternsWriter generates Closure externs from TypeScript source. */
    var ExternsWriter = /** @class */ (function (_super) {
        __extends(ExternsWriter, _super);
        function ExternsWriter() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ExternsWriter.prototype.process = function () {
            var _this = this;
            this.findExternRoots().forEach(function (node) { return _this.visit(node); });
            return this.getOutput();
        };
        ExternsWriter.prototype.ensureSymbolDeclared = function (sym) {
            var decl = this.findExportedDeclaration(sym);
            if (!decl)
                return; // symbol does not need declaring.
            this.error(this.file, "Cannot reference a non-global symbol from an externs: " + sym.name + " declared at " + formatLocation(decl.getSourceFile(), decl.getStart()));
        };
        ExternsWriter.prototype.newTypeTranslator = function (context) {
            var tt = _super.prototype.newTypeTranslator.call(this, context);
            tt.isForExterns = true;
            return tt;
        };
        ExternsWriter.prototype.findExternRoots = function () {
            if (util_1.isDtsFileName(this.file.fileName)) {
                return [this.file];
            }
            return this.file.statements.filter(function (stmt) { return util_1.hasModifierFlag(stmt, ts.ModifierFlags.Ambient); });
        };
        /** visit is the main entry point.  It generates externs from a ts.Node. */
        ExternsWriter.prototype.visit = function (node, namespace) {
            if (namespace === void 0) { namespace = []; }
            switch (node.kind) {
                case ts.SyntaxKind.SourceFile:
                    var sourceFile = node;
                    try {
                        for (var _a = __values(sourceFile.statements), _b = _a.next(); !_b.done; _b = _a.next()) {
                            var stmt = _b.value;
                            this.visit(stmt, namespace);
                        }
                    }
                    catch (e_18_1) { e_18 = { error: e_18_1 }; }
                    finally {
                        try {
                            if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                        }
                        finally { if (e_18) throw e_18.error; }
                    }
                    break;
                case ts.SyntaxKind.ModuleDeclaration:
                    var decl = node;
                    switch (decl.name.kind) {
                        case ts.SyntaxKind.Identifier:
                            // E.g. "declare namespace foo {"
                            var name_5 = rewriter_1.getIdentifierText(decl.name);
                            if (name_5 === 'global') {
                                // E.g. "declare global { ... }".  Reset to the outer namespace.
                                namespace = [];
                            }
                            else {
                                if (this.isFirstDeclaration(decl)) {
                                    this.emit('/** @const */\n');
                                    this.writeExternsVariable(name_5, namespace, '{}');
                                }
                                namespace = namespace.concat(name_5);
                            }
                            if (decl.body)
                                this.visit(decl.body, namespace);
                            break;
                        case ts.SyntaxKind.StringLiteral:
                            // E.g. "declare module 'foo' {" (note the quotes).
                            // We still want to emit externs for this module, but
                            // Closure doesn't really provide a mechanism for
                            // module-scoped externs.  For now, ignore the enclosing
                            // namespace (because this is declaring a top-level module)
                            // and emit into a fake namespace.
                            // Declare the top-level "tsickle_declare_module".
                            this.emit('/** @const */\n');
                            this.writeExternsVariable('tsickle_declare_module', [], '{}');
                            namespace = ['tsickle_declare_module'];
                            // Declare the inner "tsickle_declare_module.foo", if it's not
                            // declared already elsewhere.
                            var importName = decl.name.text;
                            this.emit("// Derived from: declare module \"" + importName + "\"\n");
                            // We also don't care about the actual name of the module ("foo"
                            // in the above example), except that we want it to not conflict.
                            importName = importName.replace(/_/, '__').replace(/[^A-Za-z]/g, '_');
                            if (this.isFirstDeclaration(decl)) {
                                this.emit('/** @const */\n');
                                this.writeExternsVariable(importName, namespace, '{}');
                            }
                            // Declare the contents inside the "tsickle_declare_module.foo".
                            if (decl.body)
                                this.visit(decl.body, namespace.concat(importName));
                            break;
                        default:
                            this.errorUnimplementedKind(decl.name, 'externs generation of namespace');
                    }
                    break;
                case ts.SyntaxKind.ModuleBlock:
                    var block = node;
                    try {
                        for (var _d = __values(block.statements), _e = _d.next(); !_e.done; _e = _d.next()) {
                            var stmt = _e.value;
                            this.visit(stmt, namespace);
                        }
                    }
                    catch (e_19_1) { e_19 = { error: e_19_1 }; }
                    finally {
                        try {
                            if (_e && !_e.done && (_f = _d.return)) _f.call(_d);
                        }
                        finally { if (e_19) throw e_19.error; }
                    }
                    break;
                case ts.SyntaxKind.ImportEqualsDeclaration:
                    var importEquals = node;
                    var localName = rewriter_1.getIdentifierText(importEquals.name);
                    if (localName === 'ng') {
                        this.emit("\n/* Skipping problematic import ng = ...; */\n");
                        break;
                    }
                    if (importEquals.moduleReference.kind === ts.SyntaxKind.ExternalModuleReference) {
                        this.emit("\n/* TODO: import " + localName + " = require(...) */\n");
                        break;
                    }
                    var qn = rewriter_1.getEntityNameText(importEquals.moduleReference);
                    // @const so that Closure Compiler understands this is an alias.
                    if (namespace.length === 0)
                        this.emit('/** @const */\n');
                    this.writeExternsVariable(localName, namespace, qn);
                    break;
                case ts.SyntaxKind.ClassDeclaration:
                case ts.SyntaxKind.InterfaceDeclaration:
                    this.writeExternsType(node, namespace);
                    break;
                case ts.SyntaxKind.FunctionDeclaration:
                    var fnDecl = node;
                    var name_6 = fnDecl.name;
                    if (!name_6) {
                        this.error(fnDecl, 'anonymous function in externs');
                        break;
                    }
                    // Gather up all overloads of this function.
                    var sym = this.mustGetSymbolAtLocation(name_6);
                    var decls = sym.declarations.filter(function (d) { return d.kind === ts.SyntaxKind.FunctionDeclaration; });
                    // Only emit the first declaration of each overloaded function.
                    if (fnDecl !== decls[0])
                        break;
                    var params = this.emitFunctionType(decls);
                    this.writeExternsFunction(name_6, params, namespace);
                    break;
                case ts.SyntaxKind.VariableStatement:
                    try {
                        for (var _g = __values(node.declarationList.declarations), _h = _g.next(); !_h.done; _h = _g.next()) {
                            var decl_1 = _h.value;
                            this.writeExternsVariableDecl(decl_1, namespace);
                        }
                    }
                    catch (e_20_1) { e_20 = { error: e_20_1 }; }
                    finally {
                        try {
                            if (_h && !_h.done && (_j = _g.return)) _j.call(_g);
                        }
                        finally { if (e_20) throw e_20.error; }
                    }
                    break;
                case ts.SyntaxKind.EnumDeclaration:
                    this.writeExternsEnum(node, namespace);
                    break;
                case ts.SyntaxKind.TypeAliasDeclaration:
                    this.writeExternsTypeAlias(node, namespace);
                    break;
                default:
                    this.emit("\n/* TODO: " + ts.SyntaxKind[node.kind] + " in " + namespace.join('.') + " */\n");
                    break;
            }
            var e_18, _c, e_19, _f, e_20, _j;
        };
        /**
         * isFirstDeclaration returns true if decl is the first declaration
         * of its symbol.  E.g. imagine
         *   interface Foo { x: number; }
         *   interface Foo { y: number; }
         * we only want to emit the "@record" for Foo on the first one.
         */
        ExternsWriter.prototype.isFirstDeclaration = function (decl) {
            if (!decl.name)
                return true;
            var sym = this.mustGetSymbolAtLocation(decl.name);
            if (!sym.declarations || sym.declarations.length < 2)
                return true;
            return decl === sym.declarations[0];
        };
        ExternsWriter.prototype.writeExternsType = function (decl, namespace) {
            var name = decl.name;
            if (!name) {
                this.error(decl, 'anonymous type in externs');
                return;
            }
            var typeName = namespace.concat([name.getText()]).join('.');
            if (exports.closureExternsBlacklist.indexOf(typeName) >= 0)
                return;
            if (this.isFirstDeclaration(decl)) {
                var paramNames = [];
                var jsdocTags = [];
                var writeJsDoc = true;
                this.maybeAddHeritageClauses(jsdocTags, decl);
                if (decl.kind === ts.SyntaxKind.ClassDeclaration) {
                    jsdocTags.push({ tagName: 'constructor' });
                    jsdocTags.push({ tagName: 'struct' });
                    var ctors = decl
                        .members.filter(function (m) { return m.kind === ts.SyntaxKind.Constructor; });
                    if (ctors.length) {
                        writeJsDoc = false;
                        var firstCtor = ctors[0];
                        var ctorTags = [{ tagName: 'constructor' }, { tagName: 'struct' }];
                        if (ctors.length > 1) {
                            paramNames = this.emitFunctionType(ctors, ctorTags);
                        }
                        else {
                            paramNames = this.emitFunctionType([firstCtor], ctorTags);
                        }
                    }
                }
                else {
                    jsdocTags.push({ tagName: 'record' });
                    jsdocTags.push({ tagName: 'struct' });
                }
                if (writeJsDoc)
                    this.emit(jsdoc.toString(jsdocTags));
                this.writeExternsFunction(name, paramNames, namespace);
            }
            // Process everything except (MethodSignature|MethodDeclaration|Constructor)
            var methods = new Map();
            try {
                for (var _a = __values(decl.members), _b = _a.next(); !_b.done; _b = _a.next()) {
                    var member = _b.value;
                    switch (member.kind) {
                        case ts.SyntaxKind.PropertySignature:
                        case ts.SyntaxKind.PropertyDeclaration:
                            var prop = member;
                            if (prop.name.kind === ts.SyntaxKind.Identifier) {
                                this.emitJSDocType(prop);
                                if (util_1.hasModifierFlag(prop, ts.ModifierFlags.Static)) {
                                    this.emit("\n" + typeName + "." + prop.name.getText() + ";\n");
                                }
                                else {
                                    this.emit("\n" + typeName + ".prototype." + prop.name.getText() + ";\n");
                                }
                                continue;
                            }
                            // TODO: For now property names other than Identifiers are not handled; e.g.
                            //    interface Foo { "123bar": number }
                            break;
                        case ts.SyntaxKind.MethodSignature:
                        case ts.SyntaxKind.MethodDeclaration:
                            var method = member;
                            var isStatic = util_1.hasModifierFlag(method, ts.ModifierFlags.Static);
                            var methodSignature = method.name.getText() + "$$$" + (isStatic ? 'static' : 'instance');
                            if (methods.has(methodSignature)) {
                                methods.get(methodSignature).push(method);
                            }
                            else {
                                methods.set(methodSignature, [method]);
                            }
                            continue;
                        case ts.SyntaxKind.Constructor:
                            continue; // Handled above.
                        default:
                            // Members can include things like index signatures, for e.g.
                            //   interface Foo { [key: string]: number; }
                            // For now, just skip it.
                            break;
                    }
                    // If we get here, the member wasn't handled in the switch statement.
                    var memberName = namespace;
                    if (member.name) {
                        memberName = memberName.concat([member.name.getText()]);
                    }
                    this.emit("\n/* TODO: " + ts.SyntaxKind[member.kind] + ": " + memberName.join('.') + " */\n");
                }
            }
            catch (e_21_1) { e_21 = { error: e_21_1 }; }
            finally {
                try {
                    if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                }
                finally { if (e_21) throw e_21.error; }
            }
            try {
                // Handle method declarations/signatures separately, since we need to deal with overloads.
                for (var _d = __values(Array.from(methods.values())), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var methodVariants = _e.value;
                    var firstMethodVariant = methodVariants[0];
                    var parameterNames = void 0;
                    if (methodVariants.length > 1) {
                        parameterNames = this.emitFunctionType(methodVariants);
                    }
                    else {
                        parameterNames = this.emitFunctionType([firstMethodVariant]);
                    }
                    var methodNamespace = namespace.concat([name.getText()]);
                    // If the method is static, don't add the prototype.
                    if (!util_1.hasModifierFlag(firstMethodVariant, ts.ModifierFlags.Static)) {
                        methodNamespace.push('prototype');
                    }
                    this.writeExternsFunction(firstMethodVariant.name, parameterNames, methodNamespace);
                }
            }
            catch (e_22_1) { e_22 = { error: e_22_1 }; }
            finally {
                try {
                    if (_e && !_e.done && (_f = _d.return)) _f.call(_d);
                }
                finally { if (e_22) throw e_22.error; }
            }
            var e_21, _c, e_22, _f;
        };
        ExternsWriter.prototype.writeExternsVariableDecl = function (decl, namespace) {
            if (decl.name.kind === ts.SyntaxKind.Identifier) {
                var name_7 = rewriter_1.getIdentifierText(decl.name);
                if (exports.closureExternsBlacklist.indexOf(name_7) >= 0)
                    return;
                this.emitJSDocType(decl);
                this.emit('\n');
                this.writeExternsVariable(name_7, namespace);
            }
            else {
                this.errorUnimplementedKind(decl.name, 'externs for variable');
            }
        };
        ExternsWriter.prototype.writeExternsVariable = function (name, namespace, value) {
            var qualifiedName = namespace.concat([name]).join('.');
            if (namespace.length === 0)
                this.emit("var ");
            this.emit(qualifiedName);
            if (value)
                this.emit(" = " + value);
            this.emit(';\n');
        };
        ExternsWriter.prototype.writeExternsFunction = function (name, params, namespace) {
            var paramsStr = params.join(', ');
            if (namespace.length > 0) {
                var fqn = namespace.join('.');
                if (name.kind === ts.SyntaxKind.Identifier) {
                    fqn += '.'; // computed names include [ ] in their getText() representation.
                }
                fqn += name.getText();
                this.emit(fqn + " = function(" + paramsStr + ") {};\n");
            }
            else {
                if (name.kind !== ts.SyntaxKind.Identifier) {
                    this.error(name, 'Non-namespaced computed name in externs');
                }
                this.emit("function " + name.getText() + "(" + paramsStr + ") {}\n");
            }
        };
        ExternsWriter.prototype.writeExternsEnum = function (decl, namespace) {
            var name = rewriter_1.getIdentifierText(decl.name);
            this.emit('\n/** @const */\n');
            this.writeExternsVariable(name, namespace, '{}');
            namespace = namespace.concat([name]);
            try {
                for (var _a = __values(decl.members), _b = _a.next(); !_b.done; _b = _a.next()) {
                    var member = _b.value;
                    var memberName = void 0;
                    switch (member.name.kind) {
                        case ts.SyntaxKind.Identifier:
                            memberName = rewriter_1.getIdentifierText(member.name);
                            break;
                        case ts.SyntaxKind.StringLiteral:
                            var text = member.name.text;
                            if (isValidClosurePropertyName(text))
                                memberName = text;
                            break;
                        default:
                            break;
                    }
                    if (!memberName) {
                        this.emit("\n/* TODO: " + ts.SyntaxKind[member.name.kind] + ": " + member.name.getText() + " */\n");
                        continue;
                    }
                    this.emit('/** @const {number} */\n');
                    this.writeExternsVariable(memberName, namespace);
                }
            }
            catch (e_23_1) { e_23 = { error: e_23_1 }; }
            finally {
                try {
                    if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                }
                finally { if (e_23) throw e_23.error; }
            }
            var e_23, _c;
        };
        ExternsWriter.prototype.writeExternsTypeAlias = function (decl, namespace) {
            var typeStr = this.typeToClosure(decl, undefined, true /* resolveAlias */);
            this.emit("\n/** @typedef {" + typeStr + "} */\n");
            this.writeExternsVariable(rewriter_1.getIdentifierText(decl.name), namespace);
        };
        return ExternsWriter;
    }(ClosureRewriter));
    function isPolymerBehaviorPropertyInCallExpression(pa) {
        var parentParent = pa.parent && pa.parent.parent;
        if (pa.name.kind !== ts.SyntaxKind.Identifier ||
            pa.name.text !== 'behaviors' || !pa.parent || !pa.parent.parent ||
            pa.parent.parent.kind !== ts.SyntaxKind.CallExpression) {
            return false;
        }
        var expr = parentParent.expression;
        return expr.kind === ts.SyntaxKind.Identifier && expr.text === 'Polymer';
    }
    function annotate(typeChecker, file, host, tsHost, tsOpts, sourceMapper) {
        return new Annotator(typeChecker, file, host, tsHost, tsOpts, sourceMapper).annotate();
    }
    exports.annotate = annotate;
    function writeExterns(typeChecker, file, host) {
        return new ExternsWriter(typeChecker, file, host).process();
    }
    exports.writeExterns = writeExterns;
    /** Concatenate all generated externs definitions together into a string. */
    function getGeneratedExterns(externs) {
        var allExterns = exports.EXTERNS_HEADER;
        try {
            for (var _a = __values(Object.keys(externs)), _b = _a.next(); !_b.done; _b = _a.next()) {
                var fileName = _b.value;
                allExterns += "// externs from " + fileName + ":\n";
                allExterns += externs[fileName];
            }
        }
        catch (e_24_1) { e_24 = { error: e_24_1 }; }
        finally {
            try {
                if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
            }
            finally { if (e_24) throw e_24.error; }
        }
        return allExterns;
        var e_24, _c;
    }
    exports.getGeneratedExterns = getGeneratedExterns;
    function mergeEmitResults(emitResults) {
        var diagnostics = [];
        var emitSkipped = true;
        var emittedFiles = [];
        var externs = {};
        var modulesManifest = new modules_manifest_1.ModulesManifest();
        try {
            for (var emitResults_1 = __values(emitResults), emitResults_1_1 = emitResults_1.next(); !emitResults_1_1.done; emitResults_1_1 = emitResults_1.next()) {
                var er = emitResults_1_1.value;
                diagnostics.push.apply(diagnostics, __spread(er.diagnostics));
                emitSkipped = emitSkipped || er.emitSkipped;
                emittedFiles.push.apply(emittedFiles, __spread(er.emittedFiles));
                Object.assign(externs, er.externs);
                modulesManifest.addManifest(er.modulesManifest);
            }
        }
        catch (e_25_1) { e_25 = { error: e_25_1 }; }
        finally {
            try {
                if (emitResults_1_1 && !emitResults_1_1.done && (_a = emitResults_1.return)) _a.call(emitResults_1);
            }
            finally { if (e_25) throw e_25.error; }
        }
        return { diagnostics: diagnostics, emitSkipped: emitSkipped, emittedFiles: emittedFiles, externs: externs, modulesManifest: modulesManifest };
        var e_25, _a;
    }
    exports.mergeEmitResults = mergeEmitResults;
    function emitWithTsickle(program, host, tsHost, tsOptions, targetSourceFile, writeFile, cancellationToken, emitOnlyDtsFiles, customTransformers) {
        if (customTransformers === void 0) { customTransformers = {}; }
        var tsickleDiagnostics = [];
        var typeChecker = program.getTypeChecker();
        var tsickleSourceTransformers = [];
        if (host.transformTypesToClosure) {
            // Note: tsickle.annotate can also lower decorators in the same run.
            tsickleSourceTransformers.push(transformer_sourcemap_1.createTransformerFromSourceMap(function (sourceFile, sourceMapper) {
                var _a = annotate(typeChecker, sourceFile, host, tsHost, tsOptions, sourceMapper), output = _a.output, diagnostics = _a.diagnostics;
                tsickleDiagnostics.push.apply(tsickleDiagnostics, __spread(diagnostics));
                return output;
            }));
            // Only add @suppress {checkTypes} comments when also adding type annotations.
            tsickleSourceTransformers.push(fileoverview_comment_transformer_1.transformFileoverviewComment);
            tsickleSourceTransformers.push(class_decorator_downlevel_transformer_1.classDecoratorDownlevelTransformer(typeChecker, tsickleDiagnostics));
        }
        else if (host.transformDecorators) {
            tsickleSourceTransformers.push(transformer_sourcemap_1.createTransformerFromSourceMap(function (sourceFile, sourceMapper) {
                var _a = decorator.convertDecorators(typeChecker, sourceFile, sourceMapper), output = _a.output, diagnostics = _a.diagnostics;
                tsickleDiagnostics.push.apply(tsickleDiagnostics, __spread(diagnostics));
                return output;
            }));
            tsickleSourceTransformers.push(class_decorator_downlevel_transformer_1.classDecoratorDownlevelTransformer(typeChecker, tsickleDiagnostics));
        }
        // // For debugging: transformer that just emits the same text.
        // beforeTsTransformers.push(createTransformer(host, typeChecker, (sourceFile, sourceMapper) => {
        //   sourceMapper.addMapping(sourceFile, {position: 0, line: 0, column: 0}, {position: 0, line: 0,
        //   column: 0}, sourceFile.text.length); return sourceFile.text;
        // }));
        var tsickleTransformers = transformer_util_1.createCustomTransformers({ before: tsickleSourceTransformers });
        var tsTransformers = {
            before: __spread((customTransformers.beforeTsickle || []), (tsickleTransformers.before || []).map(function (tf) { return skipTransformForSourceFileIfNeeded(host, tf); }), (customTransformers.beforeTs || [])),
            after: __spread((customTransformers.afterTs || []), (tsickleTransformers.after || []).map(function (tf) { return skipTransformForSourceFileIfNeeded(host, tf); }))
        };
        var writeFileDelegate = writeFile || tsHost.writeFile.bind(tsHost);
        var modulesManifest = new modules_manifest_1.ModulesManifest();
        var writeFileImpl = function (fileName, content, writeByteOrderMark, onError, sourceFiles) {
            if (path.extname(fileName) !== '.map') {
                if (tsOptions.inlineSourceMap) {
                    content = combineInlineSourceMaps(program, fileName, content);
                }
                else {
                    content = source_map_utils_1.removeInlineSourceMap(content);
                }
                content = es5processor.convertCommonJsToGoogModuleIfNeeded(host, modulesManifest, fileName, content);
            }
            else {
                content = combineSourceMaps(program, fileName, content);
            }
            if (host.addDtsClutzAliases && util_1.isDtsFileName(fileName) && sourceFiles) {
                content = addClutzAliases(fileName, content, sourceFiles, typeChecker, host);
            }
            writeFileDelegate(fileName, content, writeByteOrderMark, onError, sourceFiles);
        };
        var _a = program.emit(targetSourceFile, writeFileImpl, cancellationToken, emitOnlyDtsFiles, tsTransformers), tsDiagnostics = _a.diagnostics, emitSkipped = _a.emitSkipped, emittedFiles = _a.emittedFiles;
        var externs = {};
        if (host.transformTypesToClosure) {
            var sourceFiles = targetSourceFile ? [targetSourceFile] : program.getSourceFiles();
            sourceFiles.forEach(function (sf) {
                if (util_1.isDtsFileName(sf.fileName) && host.shouldSkipTsickleProcessing(sf.fileName)) {
                    return;
                }
                var _a = writeExterns(typeChecker, sf, host), output = _a.output, diagnostics = _a.diagnostics;
                if (output) {
                    externs[sf.fileName] = output;
                }
                if (diagnostics) {
                    tsickleDiagnostics.push.apply(tsickleDiagnostics, __spread(diagnostics));
                }
            });
        }
        // All diagnostics (including warnings) are treated as errors.
        // If the host decides to ignore warnings, just discard them.
        // Warnings include stuff like "don't use @type in your jsdoc"; tsickle
        // warns and then fixes up the code to be Closure-compatible anyway.
        tsickleDiagnostics = tsickleDiagnostics.filter(function (d) { return d.category === ts.DiagnosticCategory.Error ||
            !host.shouldIgnoreWarningsForPath(d.file.fileName); });
        return {
            modulesManifest: modulesManifest,
            emitSkipped: emitSkipped,
            emittedFiles: emittedFiles || [],
            diagnostics: __spread(tsDiagnostics, tsickleDiagnostics),
            externs: externs
        };
    }
    exports.emitWithTsickle = emitWithTsickle;
    function areAnyDeclarationsFromSourceFile(declarations, sourceFile) {
        try {
            for (var declarations_1 = __values(declarations), declarations_1_1 = declarations_1.next(); !declarations_1_1.done; declarations_1_1 = declarations_1.next()) {
                var decl = declarations_1_1.value;
                if (decl.getSourceFile() === sourceFile) {
                    return true;
                }
            }
        }
        catch (e_26_1) { e_26 = { error: e_26_1 }; }
        finally {
            try {
                if (declarations_1_1 && !declarations_1_1.done && (_a = declarations_1.return)) _a.call(declarations_1);
            }
            finally { if (e_26) throw e_26.error; }
        }
        return false;
        var e_26, _a;
    }
    function addToMultiMap(map, key, value) {
        var array = map.get(key);
        if (array) {
            array.push(value);
        }
        else {
            map.set(key, [value]);
        }
    }
    /**
     * A tsickle produced declaration file might be consumed be referenced by Clutz
     * produced .d.ts files, which use symbol names based on Closure's internal
     * naming conventions, so we need to provide aliases for all the exported symbols
     * in the Clutz naming convention.
     */
    function addClutzAliases(fileName, dtsFileContent, sourceFiles, typeChecker, host) {
        var reexportsByNamespace = new Map();
        try {
            for (var sourceFiles_1 = __values(sourceFiles), sourceFiles_1_1 = sourceFiles_1.next(); !sourceFiles_1_1.done; sourceFiles_1_1 = sourceFiles_1.next()) {
                var sf = sourceFiles_1_1.value;
                var moduleSymbol = typeChecker.getSymbolAtLocation(sf);
                var moduleExports = moduleSymbol && typeChecker.getExportsOfModule(moduleSymbol);
                if (!moduleExports) {
                    return dtsFileContent;
                }
                // pathToModuleName expects the file name to end in .js
                var jsFileName = fileName.replace('.d.ts', '.js');
                var moduleName = host.pathToModuleName('', jsFileName);
                var clutzModuleName = moduleName.replace(/\./g, '$');
                try {
                    // moduleExports is a ts.Map<ts.Symbol> which is an es6 Map, but has a
                    // different type for no reason
                    for (var moduleExports_1 = __values(moduleExports), moduleExports_1_1 = moduleExports_1.next(); !moduleExports_1_1.done; moduleExports_1_1 = moduleExports_1.next()) {
                        var symbol = moduleExports_1_1.value;
                        // We only want to add clutz aliases in the file the symbol was originally
                        // exported from, not in any files where the symbol was reexported, since
                        // the alias will refer to a symbol that might not be present in the reexporting
                        // file.  If there are no declarations, be conservative and emit the aliases.
                        var declarations = symbol.getDeclarations();
                        if (declarations && !areAnyDeclarationsFromSourceFile(declarations, sf)) {
                            continue;
                        }
                        // Want to alias the symbol to match what clutz would produce, so clutz .d.ts's
                        // can reference symbols from typescript .d.ts's. See examples at:
                        // https://github.com/angular/clutz/tree/master/src/test/java/com/google/javascript/clutz
                        // The first symbol name is that currently produced by clutz, and the second
                        // is what incremental clutz will produce.
                        var reexports = [];
                        reexports.push({
                            namespace: 'ಠ_ಠ.clutz',
                            clutzSymbolName: "module$contents$" + clutzModuleName + "_" + symbol.name,
                            aliasedSymbolName: symbol.name
                        });
                        reexports.push({
                            namespace: 'ಠ_ಠ.clutz.module$exports$' + clutzModuleName,
                            clutzSymbolName: symbol.name,
                            aliasedSymbolName: "module$contents$" + clutzModuleName + "_" + symbol.name
                        });
                        var _a = getGenericTypeParameters(symbol), params = _a.params, paramsWithContraint = _a.paramsWithContraint;
                        if (symbol.flags & ts.SymbolFlags.Class) {
                            // classes need special care to match clutz, which seperates class types into a
                            // type for the static properties and a type for the instance properties
                            reexports.push({
                                namespace: 'ಠ_ಠ.clutz',
                                clutzSymbolName: "module$contents$" + clutzModuleName + "_" + symbol.name + "_Instance",
                                aliasedSymbolName: symbol.name
                            });
                            reexports.push({
                                namespace: 'ಠ_ಠ.clutz.module$exports$' + clutzModuleName,
                                clutzSymbolName: symbol.name + '_Instance',
                                aliasedSymbolName: "module$contents$" + clutzModuleName + "_" + symbol.name
                            });
                        }
                        if (symbol.flags & ts.SymbolFlags.Type || symbol.flags & ts.SymbolFlags.Class) {
                            try {
                                for (var reexports_1 = __values(reexports), reexports_1_1 = reexports_1.next(); !reexports_1_1.done; reexports_1_1 = reexports_1.next()) {
                                    var _b = reexports_1_1.value, namespace = _b.namespace, clutzSymbolName = _b.clutzSymbolName, aliasedSymbolName = _b.aliasedSymbolName;
                                    addToMultiMap(reexportsByNamespace, namespace, "type " + clutzSymbolName + paramsWithContraint + " = " + aliasedSymbolName + params + ";");
                                }
                            }
                            catch (e_27_1) { e_27 = { error: e_27_1 }; }
                            finally {
                                try {
                                    if (reexports_1_1 && !reexports_1_1.done && (_c = reexports_1.return)) _c.call(reexports_1);
                                }
                                finally { if (e_27) throw e_27.error; }
                            }
                        }
                        if (symbol.flags & ts.SymbolFlags.Value || symbol.flags & ts.SymbolFlags.Class) {
                            try {
                                for (var reexports_2 = __values(reexports), reexports_2_1 = reexports_2.next(); !reexports_2_1.done; reexports_2_1 = reexports_2.next()) {
                                    var _d = reexports_2_1.value, namespace = _d.namespace, clutzSymbolName = _d.clutzSymbolName, aliasedSymbolName = _d.aliasedSymbolName;
                                    addToMultiMap(reexportsByNamespace, namespace, "const " + clutzSymbolName + ": typeof " + aliasedSymbolName + ";");
                                }
                            }
                            catch (e_28_1) { e_28 = { error: e_28_1 }; }
                            finally {
                                try {
                                    if (reexports_2_1 && !reexports_2_1.done && (_e = reexports_2.return)) _e.call(reexports_2);
                                }
                                finally { if (e_28) throw e_28.error; }
                            }
                        }
                    }
                }
                catch (e_29_1) { e_29 = { error: e_29_1 }; }
                finally {
                    try {
                        if (moduleExports_1_1 && !moduleExports_1_1.done && (_f = moduleExports_1.return)) _f.call(moduleExports_1);
                    }
                    finally { if (e_29) throw e_29.error; }
                }
            }
        }
        catch (e_30_1) { e_30 = { error: e_30_1 }; }
        finally {
            try {
                if (sourceFiles_1_1 && !sourceFiles_1_1.done && (_g = sourceFiles_1.return)) _g.call(sourceFiles_1);
            }
            finally { if (e_30) throw e_30.error; }
        }
        if (reexportsByNamespace.size) {
            dtsFileContent += 'declare global {\n';
            try {
                for (var reexportsByNamespace_1 = __values(reexportsByNamespace), reexportsByNamespace_1_1 = reexportsByNamespace_1.next(); !reexportsByNamespace_1_1.done; reexportsByNamespace_1_1 = reexportsByNamespace_1.next()) {
                    var _h = __read(reexportsByNamespace_1_1.value, 2), namespace = _h[0], rexps = _h[1];
                    dtsFileContent += "\tnamespace " + namespace + " {\n";
                    try {
                        for (var rexps_1 = __values(rexps), rexps_1_1 = rexps_1.next(); !rexps_1_1.done; rexps_1_1 = rexps_1.next()) {
                            var rexp = rexps_1_1.value;
                            dtsFileContent += "\t\t" + rexp + "\n";
                        }
                    }
                    catch (e_31_1) { e_31 = { error: e_31_1 }; }
                    finally {
                        try {
                            if (rexps_1_1 && !rexps_1_1.done && (_j = rexps_1.return)) _j.call(rexps_1);
                        }
                        finally { if (e_31) throw e_31.error; }
                    }
                    dtsFileContent += '\t}\n';
                }
            }
            catch (e_32_1) { e_32 = { error: e_32_1 }; }
            finally {
                try {
                    if (reexportsByNamespace_1_1 && !reexportsByNamespace_1_1.done && (_k = reexportsByNamespace_1.return)) _k.call(reexportsByNamespace_1);
                }
                finally { if (e_32) throw e_32.error; }
            }
            dtsFileContent += '}\n';
        }
        return dtsFileContent;
        var e_30, _g, e_29, _f, e_27, _c, e_28, _e, e_32, _k, e_31, _j;
    }
    /**
     * Returns 2 strings specifying the generic type arguments for the symbol.  The constrained params
     * include any `T extends foo` arguments, the regular params are just a list of the type symbols,
     * since we need the constraints on the LHS of the alias declaration, but can't have them on the
     * RHS.
     */
    function getGenericTypeParameters(symbol) {
        if (!symbol.declarations) {
            return { params: '', paramsWithContraint: '' };
        }
        // All declarations have to have matching generic types, so we're safe just looking at
        // the first one.
        if (!symbol.declarations[0]) {
            return { params: '', paramsWithContraint: '' };
        }
        var declaration = symbol.declarations[0];
        if ([
            ts.SyntaxKind.FunctionDeclaration, ts.SyntaxKind.ConstructorKeyword,
            ts.SyntaxKind.ClassDeclaration, ts.SyntaxKind.InterfaceDeclaration,
            ts.SyntaxKind.TypeAliasDeclaration
        ].indexOf(declaration.kind) === -1) {
            return { params: '', paramsWithContraint: '' };
        }
        var declarationWithTypeParameters = declaration;
        if (!declarationWithTypeParameters.typeParameters) {
            return { params: '', paramsWithContraint: '' };
        }
        var paramList = [];
        var constrainedParamList = [];
        try {
            for (var _a = __values(declarationWithTypeParameters.typeParameters), _b = _a.next(); !_b.done; _b = _a.next()) {
                var param = _b.value;
                var constrainedParam = param.name.getText();
                if (param.constraint) {
                    constrainedParam += " extends " + param.constraint.getText();
                }
                if (param.default) {
                    constrainedParam += " = " + param.default.getText();
                }
                constrainedParamList.push(constrainedParam);
                paramList.push(param.name.getText());
            }
        }
        catch (e_33_1) { e_33 = { error: e_33_1 }; }
        finally {
            try {
                if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
            }
            finally { if (e_33) throw e_33.error; }
        }
        var params = "<" + paramList.join(',') + ">";
        var paramsWithContraint = "<" + constrainedParamList.join(',') + ">";
        return { params: params, paramsWithContraint: paramsWithContraint };
        var e_33, _c;
    }
    function skipTransformForSourceFileIfNeeded(host, delegateFactory) {
        return function (context) {
            var delegate = delegateFactory(context);
            return function (sourceFile) {
                if (host.shouldSkipTsickleProcessing(sourceFile.fileName)) {
                    return sourceFile;
                }
                return delegate(sourceFile);
            };
        };
    }
    function combineInlineSourceMaps(program, filePath, compiledJsWithInlineSourceMap) {
        if (util_1.isDtsFileName(filePath)) {
            return compiledJsWithInlineSourceMap;
        }
        var sourceMapJson = source_map_utils_1.extractInlineSourceMap(compiledJsWithInlineSourceMap);
        compiledJsWithInlineSourceMap = source_map_utils_1.removeInlineSourceMap(compiledJsWithInlineSourceMap);
        var composedSourceMap = combineSourceMaps(program, filePath, sourceMapJson);
        return source_map_utils_1.setInlineSourceMap(compiledJsWithInlineSourceMap, composedSourceMap);
    }
    function combineSourceMaps(program, filePath, tscSourceMapText) {
        var tscSourceMap = source_map_utils_1.parseSourceMap(tscSourceMapText);
        if (tscSourceMap.sourcesContent) {
            // strip incoming sourcemaps from the sources in the sourcemap
            // to reduce the size of the sourcemap.
            tscSourceMap.sourcesContent = tscSourceMap.sourcesContent.map(function (content) {
                if (source_map_utils_1.containsInlineSourceMap(content)) {
                    content = source_map_utils_1.removeInlineSourceMap(content);
                }
                return content;
            });
        }
        var fileDir = path.dirname(filePath);
        var tscSourceMapGenerator;
        try {
            for (var _a = __values(tscSourceMap.sources), _b = _a.next(); !_b.done; _b = _a.next()) {
                var sourceFileName = _b.value;
                var sourceFile = program.getSourceFile(path.resolve(fileDir, sourceFileName));
                if (!sourceFile || !source_map_utils_1.containsInlineSourceMap(sourceFile.text)) {
                    continue;
                }
                var preexistingSourceMapText = source_map_utils_1.extractInlineSourceMap(sourceFile.text);
                if (!tscSourceMapGenerator) {
                    tscSourceMapGenerator = source_map_1.SourceMapGenerator.fromSourceMap(new source_map_1.SourceMapConsumer(tscSourceMap));
                }
                tscSourceMapGenerator.applySourceMap(new source_map_1.SourceMapConsumer(source_map_utils_1.parseSourceMap(preexistingSourceMapText, sourceFileName)));
            }
        }
        catch (e_34_1) { e_34 = { error: e_34_1 }; }
        finally {
            try {
                if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
            }
            finally { if (e_34) throw e_34.error; }
        }
        return tscSourceMapGenerator ? tscSourceMapGenerator.toString() : tscSourceMapText;
        var e_34, _c;
    }
});
//# sourceMappingURL=data:application/json;base64,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