/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/// <amd-module name="tsickle/src/typescript" />
/**
 * @fileoverview Abstraction over the TypeScript API that makes multiple
 * versions of TypeScript appear to be interoperable. Any time a breaking change
 * in TypeScript affects Tsickle code, we should extend this shim to present an
 * unbroken API.
 * All code in tsickle should import from this location, not from 'typescript'.
 */
import * as ts from 'typescript';
export { __String, addSyntheticTrailingComment, AssertionExpression, BinaryExpression, Block, CallExpression, CancellationToken, ClassDeclaration, ClassElement, ClassLikeDeclaration, CommentRange, CompilerHost, CompilerOptions, ConstructorDeclaration, createArrayLiteral, createArrayTypeNode, createArrowFunction, createAssignment, createBinary, createCall, createCompilerHost, createFunctionTypeNode, createIdentifier, createIndexSignature, createKeywordTypeNode, createLiteral, createLiteralTypeNode, createNodeArray, createNotEmittedStatement, createNull, createObjectLiteral, createParameter, createProgram, createProperty, createPropertyAccess, createPropertyAssignment, createPropertySignature, createSourceFile, createStatement, createToken, createTypeLiteralNode, createTypeReferenceNode, createUnionTypeNode, createVariableDeclaration, createVariableDeclarationList, createVariableStatement, CustomTransformers, Declaration, DeclarationStatement, DeclarationWithTypeParameters, Decorator, Diagnostic, DiagnosticCategory, ElementAccessExpression, EmitFlags, EmitResult, EntityName, EnumDeclaration, EnumMember, ExportDeclaration, ExportSpecifier, Expression, ExpressionStatement, flattenDiagnosticMessageText, forEachChild, formatDiagnostics, FormatDiagnosticsHost, FunctionDeclaration, FunctionLikeDeclaration, GetAccessorDeclaration, getCombinedModifierFlags, getLeadingCommentRanges, getLineAndCharacterOfPosition, getMutableClone, getOriginalNode, getPreEmitDiagnostics, getSyntheticLeadingComments, getSyntheticTrailingComments, getTrailingCommentRanges, Identifier, ImportDeclaration, ImportEqualsDeclaration, ImportSpecifier, IndexKind, InterfaceDeclaration, isArrowFunction, isBinaryExpression, isCallExpression, isExportDeclaration, isExpressionStatement, isExternalModule, isIdentifier, isImportDeclaration, isLiteralExpression, isLiteralTypeNode, isObjectLiteralExpression, isPropertyAccessExpression, isPropertyAssignment, isQualifiedName, isStringLiteral, isTypeReferenceNode, isVariableStatement, MethodDeclaration, ModifierFlags, ModuleBlock, ModuleDeclaration, ModuleKind, ModuleResolutionHost, NamedDeclaration, NamedImports, Node, NodeArray, NodeFlags, NonNullExpression, NotEmittedStatement, ObjectFlags, ObjectLiteralElementLike, ObjectLiteralExpression, ObjectType, ParameterDeclaration, parseCommandLine, parseJsonConfigFileContent, Program, PropertyAccessExpression, PropertyAssignment, PropertyDeclaration, PropertyName, PropertySignature, QualifiedName, readConfigFile, resolveModuleName, ScriptTarget, SetAccessorDeclaration, setCommentRange, setEmitFlags, setOriginalNode, setSourceMapRange, setSyntheticLeadingComments, setSyntheticTrailingComments, setTextRange, Signature, SignatureDeclaration, SignatureKind, SourceFile, Statement, StringLiteral, Symbol, SymbolFlags, SymbolWriter, SyntaxKind, SynthesizedComment, sys, Token, TransformationContext, Transformer, TransformerFactory, Type, TypeAliasDeclaration, TypeChecker, TypeElement, TypeFlags, TypeNode, TypeParameterDeclaration, TypeReference, TypeReferenceNode, UnionType, updateBlock, updateConstructor, updateGetAccessor, updateMethod, updateParameter, updateSetAccessor, updateSourceFileNode, VariableDeclaration, VariableStatement, visitEachChild, visitFunctionBody, visitLexicalEnvironment, visitNode, Visitor, visitParameterList, WriteFileCallback } from 'typescript';
export declare const SyntaxKindJSDocSignature: ts.SyntaxKind;
export declare function getEmitFlags(node: ts.Node): ts.EmitFlags | undefined;
export declare let updateProperty: typeof ts.updateProperty;
