/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("tsickle/src/annotator_host", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * Returns a mangled version of the module name (resolved file name) for source file.
     *
     * The mangled name is safe to use as a JavaScript identifier. It is used as a globally unique
     * prefix to scope symbols in externs file (see externs.ts).
     */
    function moduleNameAsIdentifier(host, fileName) {
        return host.pathToModuleName('', fileName).replace(/\./g, '$');
    }
    exports.moduleNameAsIdentifier = moduleNameAsIdentifier;
});
//# sourceMappingURL=data:application/json;base64,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