/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("tsickle/src/path", ["require", "exports", "typescript"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * @fileoverview Path manipulation functions.
     * These are the functions exposed by nodejs in the 'path' module.
     *
     * But we actually use the TypeScript path-manipulation logic because:
     * 1) we want the exact same behaviors as TS;
     * 2) we don't depend on node's 'path' module when running under a browser
     * So we poke into their private API for these.
     */
    const ts = require("typescript");
    function isAbsolute(path) {
        return ts.isRootedDiskPath(path);
    }
    exports.isAbsolute = isAbsolute;
    function join(p1, p2) {
        return ts.combinePaths(p1, p2);
    }
    exports.join = join;
    function dirname(path) {
        return ts.getDirectoryPath(path);
    }
    exports.dirname = dirname;
    function relative(base, rel) {
        return ts.convertToRelativePath(rel, base, p => p);
    }
    exports.relative = relative;
    function normalize(path) {
        return ts.resolvePath(path);
    }
    exports.normalize = normalize;
});
//# sourceMappingURL=data:application/json;base64,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