var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var ts = require('typescript');
var Lint = require('tslint/lib/lint');
var Rule = (function (_super) {
    __extends(Rule, _super);
    function Rule() {
        _super.apply(this, arguments);
    }
    Rule.prototype.apply = function (sourceFile) {
        var walker = new NoUnexpectedMultilineWalker(sourceFile, this.getOptions());
        return this.applyWithWalker(walker);
    };
    Rule.FAILURE_STRING = {
        func: 'unexpected newline between function and ( of function call',
        prop: 'unexpected newline between object and [ of property access'
    };
    return Rule;
})(Lint.Rules.AbstractRule);
exports.Rule = Rule;
var NoUnexpectedMultilineWalker = (function (_super) {
    __extends(NoUnexpectedMultilineWalker, _super);
    function NoUnexpectedMultilineWalker() {
        _super.apply(this, arguments);
    }
    NoUnexpectedMultilineWalker.prototype.visitNode = function (node) {
        this.validateMultiline(node);
        _super.prototype.visitNode.call(this, node);
    };
    NoUnexpectedMultilineWalker.prototype.getMessage = function (node) {
        return node.kind === 168 ? Rule.FAILURE_STRING.func : Rule.FAILURE_STRING.prop;
    };
    NoUnexpectedMultilineWalker.prototype.getPosition = function (node) {
        return node.getSourceFile().getLineAndCharacterOfPosition(node.getStart());
    };
    NoUnexpectedMultilineWalker.prototype.validateMultiline = function (node) {
        var parent = node.parent;
        if (parent) {
            var before_1 = parent.getChildAt(parent.getChildren().indexOf(node) - 1);
            var paren = parent.getChildAt(parent.getChildren().indexOf(node) - 2);
            if (before_1 && paren) {
                if (this.getPosition(before_1).line !== this.getPosition(paren).line) {
                    this.addFailure(this.createFailure(node.getStart(), node.getWidth(), this.getMessage(node)));
                }
            }
        }
    };
    return NoUnexpectedMultilineWalker;
})(Lint.RuleWalker);
