var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var ts = require('typescript');
var Lint = require('tslint/lib/lint');
var Rule = (function (_super) {
    __extends(Rule, _super);
    function Rule() {
        _super.apply(this, arguments);
    }
    Rule.prototype.apply = function (sourceFile) {
        var walker = new ValidTypeofWalker(sourceFile, this.getOptions());
        return this.applyWithWalker(walker);
    };
    Rule.FAILURE_STRING = 'invalid typeof comparison value';
    return Rule;
})(Lint.Rules.AbstractRule);
exports.Rule = Rule;
var ValidTypeofWalker = (function (_super) {
    __extends(ValidTypeofWalker, _super);
    function ValidTypeofWalker() {
        _super.apply(this, arguments);
        this.VALID_TYPES = ['symbol', 'undefined', 'object', 'boolean', 'number', 'string', 'function'];
        this.OPERATORS = [30, 32, 31, 33];
    }
    ValidTypeofWalker.prototype.visitNode = function (node) {
        if (node.kind === 176) {
            this.validateTypeOf(node);
        }
        _super.prototype.visitNode.call(this, node);
    };
    ValidTypeofWalker.prototype.validateTypeOf = function (node) {
        if (node.parent.kind === 181) {
            var parent_1 = node.parent;
            if (this.OPERATORS.indexOf(parent_1.operatorToken.kind) !== -1) {
                var sibling = parent_1.left === node ? parent_1.right : parent_1.left;
                if (sibling.kind === 9 && this.VALID_TYPES.indexOf(sibling.text) === -1) {
                    this.addFailure(this.createFailure(node.getStart(), node.getWidth(), Rule.FAILURE_STRING));
                }
            }
        }
    };
    return ValidTypeofWalker;
})(Lint.RuleWalker);
