"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var ErrorTolerantWalker_1 = require('./ErrorTolerantWalker');
var SyntaxKind_1 = require('./SyntaxKind');
var AstUtils_1 = require('./AstUtils');
var Scope = (function () {
    function Scope(parent) {
        this.symbols = {};
        this.parent = parent;
    }
    Scope.prototype.addFunctionSymbol = function (symbolString) {
        this.symbols[symbolString] = SyntaxKind_1.SyntaxKind.current().FunctionType;
    };
    Scope.prototype.addNonFunctionSymbol = function (symbolString) {
        this.symbols[symbolString] = SyntaxKind_1.SyntaxKind.current().Unknown;
    };
    Scope.prototype.isFunctionSymbol = function (symbolString) {
        if (this.symbols[symbolString] === SyntaxKind_1.SyntaxKind.current().FunctionType) {
            return true;
        }
        if (this.symbols[symbolString] === SyntaxKind_1.SyntaxKind.current().Unknown) {
            return false;
        }
        if (this.parent != null) {
            return this.parent.isFunctionSymbol(symbolString);
        }
        return false;
    };
    Scope.prototype.addParameters = function (parameters) {
        var _this = this;
        parameters.forEach(function (parm) {
            if (AstUtils_1.AstUtils.isDeclarationFunctionType(parm)) {
                _this.addFunctionSymbol(parm.name.getText());
            }
            else {
                _this.addNonFunctionSymbol(parm.name.getText());
            }
        });
    };
    Scope.prototype.addGlobalScope = function (node, sourceFile, options) {
        var _this = this;
        var refCollector = new GlobalReferenceCollector(sourceFile, options);
        refCollector.visitNode(node);
        refCollector.functionIdentifiers.forEach(function (identifier) { _this.addFunctionSymbol(identifier); });
        refCollector.nonFunctionIdentifiers.forEach(function (identifier) { _this.addNonFunctionSymbol(identifier); });
    };
    return Scope;
}());
exports.Scope = Scope;
var GlobalReferenceCollector = (function (_super) {
    __extends(GlobalReferenceCollector, _super);
    function GlobalReferenceCollector() {
        _super.apply(this, arguments);
        this.functionIdentifiers = [];
        this.nonFunctionIdentifiers = [];
    }
    GlobalReferenceCollector.prototype.visitModuleDeclaration = function (node) { };
    GlobalReferenceCollector.prototype.visitClassDeclaration = function (node) { };
    GlobalReferenceCollector.prototype.visitArrowFunction = function (node) { };
    GlobalReferenceCollector.prototype.visitFunctionExpression = function (node) { };
    GlobalReferenceCollector.prototype.visitNode = function (node) {
        _super.prototype.visitNode.call(this, node);
    };
    GlobalReferenceCollector.prototype.visitVariableDeclaration = function (node) {
        if (AstUtils_1.AstUtils.isDeclarationFunctionType(node)) {
            this.functionIdentifiers.push(node.name.getText());
        }
        else {
            this.nonFunctionIdentifiers.push(node.name.getText());
        }
    };
    return GlobalReferenceCollector;
}(ErrorTolerantWalker_1.ErrorTolerantWalker));
//# sourceMappingURL=Scope.js.map