"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Lint = require('tslint/lib/lint');
var BannedTermWalker = require('./utils/BannedTermWalker');
var Rule = (function (_super) {
    __extends(Rule, _super);
    function Rule() {
        _super.apply(this, arguments);
    }
    Rule.prototype.apply = function (sourceFile) {
        var walker = new BannedTermWalker(sourceFile, this.getOptions(), Rule.FAILURE_STRING, Rule.BANNED_TERMS);
        return this.applyWithWalker(walker);
    };
    Rule.FAILURE_STRING = 'Forbidden reference to reserved keyword: ';
    Rule.BANNED_TERMS = [
        'break', 'case', 'catch', 'class',
        'const', 'continue', 'debugger', 'default',
        'delete', 'do', 'else', 'enum', 'export',
        'extends', 'false', 'finally', 'for',
        'function', 'if', 'import', 'in',
        'instanceof', 'new', 'null', 'return',
        'super', 'switch', 'this', 'throw',
        'true', 'try', 'typeof', 'var',
        'void', 'while', 'with',
        'as', 'implements', 'interface', 'let',
        'package', 'private', 'protected',
        'public', 'static', 'yield',
        'any', 'boolean', 'constructor',
        'declare', 'get', 'module',
        'require', 'number', 'set',
        'string', 'symbol', 'type',
        'from', 'of'
    ];
    return Rule;
}(Lint.Rules.AbstractRule));
exports.Rule = Rule;
//# sourceMappingURL=noReservedKeywordsRule.js.map