"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var ts = require("typescript");
var Lint = require("tslint");
var tsutils_1 = require("tsutils");
var UNSPECIFIED_BROWSER_VERSION = 'unspecified version';
var JSDOC_BROWSERSPECIFIC = '@browserspecific';
var COMMENT_BROWSERSPECIFIC = 'Browser Specific:';
var FAILURE_BROWSER_STRING = 'Unsupported browser';
var FAILURE_VERSION_STRING = 'Unsupported browser version';
var Rule = (function (_super) {
    __extends(Rule, _super);
    function Rule() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Rule.prototype.apply = function (sourceFile) {
        return this.applyWithWalker(new NoUnsupportedBrowserCodeRuleWalker(sourceFile, this.getOptions()));
    };
    return Rule;
}(Lint.Rules.AbstractRule));
Rule.metadata = {
    ruleName: 'no-unsupported-browser-code',
    type: 'maintainability',
    description: 'Avoid writing browser-specific code for unsupported browser versions',
    options: null,
    optionsDescription: '',
    typescriptOnly: true,
    issueClass: 'Non-SDL',
    issueType: 'Warning',
    severity: 'Low',
    level: 'Opportunity for Excellence',
    group: 'Clarity'
};
exports.Rule = Rule;
var NoUnsupportedBrowserCodeRuleWalker = (function (_super) {
    __extends(NoUnsupportedBrowserCodeRuleWalker, _super);
    function NoUnsupportedBrowserCodeRuleWalker(sourceFile, options) {
        var _this = _super.call(this, sourceFile, options) || this;
        _this.supportedBrowsers = _this.parseSupportedBrowsers();
        return _this;
    }
    NoUnsupportedBrowserCodeRuleWalker.prototype.visitSourceFile = function (node) {
        var _this = this;
        tsutils_1.forEachTokenWithTrivia(node, function (text, tokenSyntaxKind, range) {
            var regex;
            if (tokenSyntaxKind === ts.SyntaxKind.MultiLineCommentTrivia) {
                regex = new RegExp(JSDOC_BROWSERSPECIFIC + "\\s*(.*)", 'gi');
            }
            else if (tokenSyntaxKind === ts.SyntaxKind.SingleLineCommentTrivia) {
                regex = new RegExp(COMMENT_BROWSERSPECIFIC + "\\s*(.*)", 'gi');
            }
            else {
                return;
            }
            var match;
            var tokenText = text.substring(range.pos, range.end);
            while ((match = regex.exec(tokenText))) {
                var browser = _this.parseBrowserString(match[1]);
                _this.findUnsupportedBrowserFailures(browser, range.pos, range.end - range.pos);
            }
        });
    };
    NoUnsupportedBrowserCodeRuleWalker.prototype.parseBrowserString = function (browser) {
        var regex = /([a-zA-Z ]*)(>=|<=|<|>)?\s*(\d*)/i;
        var match = browser.match(regex);
        return {
            name: match[1].trim(),
            comparison: match[2] || '=',
            version: parseInt(match[3], 10) || UNSPECIFIED_BROWSER_VERSION
        };
    };
    NoUnsupportedBrowserCodeRuleWalker.prototype.parseSupportedBrowsers = function () {
        var _this = this;
        var result = {};
        this.getOptions().forEach(function (option) {
            if (option instanceof Array) {
                option.forEach(function (browserString) {
                    var browser = _this.parseBrowserString(browserString);
                    result[browser.name.toLowerCase()] = browser;
                });
            }
        });
        return result;
    };
    NoUnsupportedBrowserCodeRuleWalker.prototype.isSupportedBrowser = function (targetBrowser) {
        return targetBrowser.name.toLowerCase() in this.supportedBrowsers;
    };
    NoUnsupportedBrowserCodeRuleWalker.prototype.isSupportedBrowserVersion = function (targetBrowser) {
        var supportedBrowser = this.supportedBrowsers[targetBrowser.name.toLowerCase()];
        if (supportedBrowser.version === UNSPECIFIED_BROWSER_VERSION) {
            return true;
        }
        switch (supportedBrowser.comparison) {
            case '>':
                return targetBrowser.version > supportedBrowser.version;
            case '>=':
                return targetBrowser.version >= supportedBrowser.version;
            case '<':
                return targetBrowser.version < supportedBrowser.version;
            case '<=':
                return targetBrowser.version <= supportedBrowser.version;
            case '=':
                return targetBrowser.version === supportedBrowser.version;
            default:
                return false;
        }
    };
    NoUnsupportedBrowserCodeRuleWalker.prototype.findUnsupportedBrowserFailures = function (targetBrowser, startPos, length) {
        if (!this.isSupportedBrowser(targetBrowser)) {
            this.addFailureAt(startPos, length, FAILURE_BROWSER_STRING + ": " + targetBrowser.name);
        }
        else if (!this.isSupportedBrowserVersion(targetBrowser)) {
            this.addFailureAt(startPos, length, FAILURE_VERSION_STRING + ": " + targetBrowser.name + " " + targetBrowser.version);
        }
    };
    return NoUnsupportedBrowserCodeRuleWalker;
}(Lint.RuleWalker));
//# sourceMappingURL=noUnsupportedBrowserCodeRule.js.map