import * as Lint from "../lint";
import * as ts from "typescript";
export declare class Rule extends Lint.Rules.AbstractRule {
    apply(sourceFile: ts.SourceFile): Lint.RuleFailure[];
}
export declare class MemberOrderingWalker extends Lint.RuleWalker {
    private previousMember;
    private memberStack;
    visitClassDeclaration(node: ts.ClassDeclaration): void;
    visitInterfaceDeclaration(node: ts.InterfaceDeclaration): void;
    visitMethodDeclaration(node: ts.MethodDeclaration): void;
    visitMethodSignature(node: ts.SignatureDeclaration): void;
    visitConstructorDeclaration(node: ts.ConstructorDeclaration): void;
    visitPropertyDeclaration(node: ts.PropertyDeclaration): void;
    visitPropertySignature(node: ts.PropertyDeclaration): void;
    visitTypeLiteral(node: ts.TypeLiteralNode): void;
    private resetPreviousModifiers();
    private checkModifiersAndSetPrevious(node, currentMember);
    private canAppearAfter(previousMember, currentMember);
    private newMemberList();
    private pushMember(node);
    private checkMemberOrder();
    private hasOrderOption();
    private getOrder();
}
