"use strict";
var fs = require("fs");
var path = require("path");
var findup = require("findup-sync");
exports.CONFIG_FILENAME = "tslint.json";
exports.DEFAULT_CONFIG = {
    "rules": {
        "class-name": true,
        "comment-format": [true, "check-space"],
        "indent": [true, "spaces"],
        "no-duplicate-variable": true,
        "no-eval": true,
        "no-internal-module": true,
        "no-trailing-whitespace": true,
        "no-var-keyword": true,
        "one-line": [true, "check-open-brace", "check-whitespace"],
        "quotemark": [true, "double"],
        "semicolon": true,
        "triple-equals": [true, "allow-null-check"],
        "typedef-whitespace": [true, {
                "call-signature": "nospace",
                "index-signature": "nospace",
                "parameter": "nospace",
                "property-declaration": "nospace",
                "variable-declaration": "nospace"
            }],
        "variable-name": [true, "ban-keywords"],
        "whitespace": [true,
            "check-branch",
            "check-decl",
            "check-operator",
            "check-separator",
            "check-type"
        ],
    }
};
var moduleDirectory = path.dirname(module.filename);
function findConfiguration(configFile, inputFileLocation) {
    if (configFile == null) {
        configFile = findup("package.json", { cwd: inputFileLocation, nocase: true });
        if (configFile) {
            var content = require(configFile);
            if (content.tslintConfig) {
                return content.tslintConfig;
            }
        }
        var homeDir = getHomeDir();
        if (!homeDir) {
            return undefined;
        }
        var defaultPath = path.join(homeDir, exports.CONFIG_FILENAME);
        configFile = findup(exports.CONFIG_FILENAME, { cwd: inputFileLocation, nocase: true }) || defaultPath;
    }
    if (fs.existsSync(configFile)) {
        var fileData = fs.readFileSync(configFile, "utf8");
        fileData = fileData.replace(/^\uFEFF/, "");
        return JSON.parse(fileData);
    }
    else {
        return exports.DEFAULT_CONFIG;
    }
}
exports.findConfiguration = findConfiguration;
function getHomeDir() {
    var environment = global.process.env;
    var paths = [
        environment.USERPROFILE,
        environment.HOME,
        environment.HOMEPATH,
        environment.HOMEDRIVE + environment.HOMEPATH
    ];
    for (var _i = 0, paths_1 = paths; _i < paths_1.length; _i++) {
        var homePath = paths_1[_i];
        if (homePath != null && fs.existsSync(homePath)) {
            return homePath;
        }
    }
}
function getRelativePath(directory) {
    if (directory != null) {
        return path.relative(moduleDirectory, directory);
    }
}
exports.getRelativePath = getRelativePath;
function getRulesDirectories(directories) {
    var rulesDirectories = [];
    if (directories != null) {
        if (typeof directories === "string") {
            rulesDirectories = [getRelativePath(directories)];
        }
        else {
            rulesDirectories = directories.map(function (dir) { return getRelativePath(dir); });
        }
    }
    return rulesDirectories;
}
exports.getRulesDirectories = getRulesDirectories;
