"use strict";
var RuleFailurePosition = (function () {
    function RuleFailurePosition(position, lineAndCharacter) {
        this.position = position;
        this.lineAndCharacter = lineAndCharacter;
    }
    RuleFailurePosition.prototype.getPosition = function () {
        return this.position;
    };
    RuleFailurePosition.prototype.getLineAndCharacter = function () {
        return this.lineAndCharacter;
    };
    RuleFailurePosition.prototype.toJson = function () {
        return {
            character: this.lineAndCharacter.character,
            line: this.lineAndCharacter.line,
            position: this.position
        };
    };
    RuleFailurePosition.prototype.equals = function (ruleFailurePosition) {
        var ll = this.lineAndCharacter;
        var rr = ruleFailurePosition.lineAndCharacter;
        return this.position === ruleFailurePosition.position
            && ll.line === rr.line
            && ll.character === rr.character;
    };
    return RuleFailurePosition;
}());
exports.RuleFailurePosition = RuleFailurePosition;
var RuleFailure = (function () {
    function RuleFailure(sourceFile, start, end, failure, ruleName) {
        this.sourceFile = sourceFile;
        this.fileName = sourceFile.fileName;
        this.startPosition = this.createFailurePosition(start);
        this.endPosition = this.createFailurePosition(end);
        this.failure = failure;
        this.ruleName = ruleName;
    }
    RuleFailure.prototype.getFileName = function () {
        return this.fileName;
    };
    RuleFailure.prototype.getRuleName = function () {
        return this.ruleName;
    };
    RuleFailure.prototype.getStartPosition = function () {
        return this.startPosition;
    };
    RuleFailure.prototype.getEndPosition = function () {
        return this.endPosition;
    };
    RuleFailure.prototype.getFailure = function () {
        return this.failure;
    };
    RuleFailure.prototype.toJson = function () {
        return {
            endPosition: this.endPosition.toJson(),
            failure: this.failure,
            name: this.fileName,
            ruleName: this.ruleName,
            startPosition: this.startPosition.toJson()
        };
    };
    RuleFailure.prototype.equals = function (ruleFailure) {
        return this.failure === ruleFailure.getFailure()
            && this.fileName === ruleFailure.getFileName()
            && this.startPosition.equals(ruleFailure.getStartPosition())
            && this.endPosition.equals(ruleFailure.getEndPosition());
    };
    RuleFailure.prototype.createFailurePosition = function (position) {
        var lineAndCharacter = this.sourceFile.getLineAndCharacterOfPosition(position);
        return new RuleFailurePosition(position, lineAndCharacter);
    };
    return RuleFailure;
}());
exports.RuleFailure = RuleFailure;
