import * as ts from "typescript";
import { IOptions } from "../../lint";
import { RuleFailure } from "../rule/rule";
import { SyntaxWalker } from "./syntaxWalker";
export declare class RuleWalker extends SyntaxWalker {
    private limit;
    private position;
    private options;
    private failures;
    private sourceFile;
    private disabledIntervals;
    private ruleName;
    constructor(sourceFile: ts.SourceFile, options: IOptions);
    getSourceFile(): ts.SourceFile;
    getFailures(): RuleFailure[];
    getLimit(): number;
    getOptions(): any;
    hasOption(option: string): boolean;
    skip(node: ts.Node): void;
    createFailure(start: number, width: number, failure: string): RuleFailure;
    addFailure(failure: RuleFailure): void;
    private existsFailure(failure);
}
