"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var ts = require("typescript");
var Lint = require("../lint");
var Rule = (function (_super) {
    __extends(Rule, _super);
    function Rule() {
        _super.apply(this, arguments);
    }
    Rule.prototype.apply = function (sourceFile) {
        return this.applyWithWalker(new NoInvalidThisWalker(sourceFile, this.getOptions()));
    };
    Rule.FAILURE_STRING = "the \"this\" keyword is disallowed outside of a class body";
    return Rule;
}(Lint.Rules.AbstractRule));
exports.Rule = Rule;
var NoInvalidThisWalker = (function (_super) {
    __extends(NoInvalidThisWalker, _super);
    function NoInvalidThisWalker() {
        _super.apply(this, arguments);
    }
    NoInvalidThisWalker.prototype.createScope = function (node) {
        var isClassScope = node.kind === ts.SyntaxKind.ClassDeclaration || node.kind === ts.SyntaxKind.ClassExpression;
        return {
            inClass: isClassScope,
        };
    };
    NoInvalidThisWalker.prototype.validateThisKeyword = function (node) {
        if (!this.getAllScopes().some(function (scope) { return scope.inClass; })) {
            this.addFailure(this.createFailure(node.getStart(), node.getWidth(), Rule.FAILURE_STRING));
        }
    };
    NoInvalidThisWalker.prototype.visitNode = function (node) {
        if (node.kind === ts.SyntaxKind.ThisKeyword) {
            this.validateThisKeyword(node);
        }
        _super.prototype.visitNode.call(this, node);
    };
    return NoInvalidThisWalker;
}(Lint.ScopeAwareRuleWalker));
