/**
 * @license
 * Copyright 2013 Palantir Technologies, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as ts from "typescript";
import * as Lint from "../index";
export declare class Rule extends Lint.Rules.TypedRule {
    static metadata: Lint.IRuleMetadata;
    static FAILURE_STRING_EXIST: string;
    static ARGUMENT_CLASSES: string;
    static ARGUMENT_FUNCTIONS: string;
    static ARGUMENT_METHODS: string;
    static ARGUMENT_PROPERTIES: string;
    static defaultArguments: string[];
    applyWithProgram(sourceFile: ts.SourceFile, program: ts.Program): Lint.RuleFailure[];
    private getNodesToCheck(ruleArguments);
}
export declare class CompletedDocsWalker extends Lint.ProgramAwareRuleWalker {
    private nodesToCheck;
    setNodesToCheck(nodesToCheck: string[]): void;
    visitClassDeclaration(node: ts.ClassDeclaration): void;
    visitFunctionDeclaration(node: ts.FunctionDeclaration): void;
    visitPropertyDeclaration(node: ts.PropertyDeclaration): void;
    visitMethodDeclaration(node: ts.MethodDeclaration): void;
    private checkComments(node, nodeToCheck);
    private createDocumentationFailure(node, nodeToCheck);
}
