/**
 * @license
 * Copyright 2016 Palantir Technologies, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
export declare const rules: {
    "adjacent-overload-signatures": boolean;
    "align": (string | boolean)[];
    "array-type": (string | boolean)[];
    "arrow-parens": boolean;
    "class-name": boolean;
    "comment-format": (string | boolean)[];
    "curly": boolean;
    "cyclomatic-complexity": boolean;
    "eofline": boolean;
    "forin": boolean;
    "indent": (string | boolean)[];
    "interface-name": (string | boolean)[];
    "jsdoc-format": boolean;
    "label-position": boolean;
    "max-classes-per-file": (number | boolean)[];
    "max-line-length": (number | boolean)[];
    "member-access": boolean;
    "member-ordering": (boolean | {
        "order": string;
    })[];
    "new-parens": boolean;
    "no-any": boolean;
    "no-arg": boolean;
    "no-bitwise": boolean;
    "no-conditional-assignment": boolean;
    "no-consecutive-blank-lines": boolean;
    "no-console": (string | boolean)[];
    "no-construct": boolean;
    "no-debugger": boolean;
    "no-empty": boolean;
    "no-eval": boolean;
    "no-internal-module": boolean;
    "no-namespace": boolean;
    "no-parameter-properties": boolean;
    "no-reference": boolean;
    "no-shadowed-variable": boolean;
    "no-string-literal": boolean;
    "no-switch-case-fall-through": boolean;
    "no-trailing-whitespace": boolean;
    "no-unsafe-finally": boolean;
    "no-unused-expression": boolean;
    "no-unused-new": boolean;
    "no-use-before-declare": boolean;
    "no-var-keyword": boolean;
    "no-var-requires": boolean;
    "object-literal-key-quotes": (string | boolean)[];
    "object-literal-shorthand": boolean;
    "object-literal-sort-keys": boolean;
    "one-line": (string | boolean)[];
    "one-variable-per-declaration": (string | boolean)[];
    "only-arrow-functions": (string | boolean)[];
    "ordered-imports": (boolean | {
        "import-sources-order": string;
        "named-imports-order": string;
    })[];
    "prefer-for-of": boolean;
    "quotemark": (string | boolean)[];
    "radix": boolean;
    "semicolon": (string | boolean)[];
    "switch-default": boolean;
    "trailing-comma": (boolean | {
        "multiline": string;
        "singleline": string;
    })[];
    "triple-equals": (string | boolean)[];
    "typedef": boolean;
    "typedef-whitespace": (boolean | {
        "call-signature": string;
        "index-signature": string;
        "parameter": string;
        "property-declaration": string;
        "variable-declaration": string;
    })[];
    "use-isnan": boolean;
    "variable-name": (string | boolean)[];
    "whitespace": (string | boolean)[];
};
export declare const jsRules: {
    "align": (string | boolean)[];
    "class-name": boolean;
    "curly": boolean;
    "eofline": boolean;
    "forin": boolean;
    "indent": (string | boolean)[];
    "jsdoc-format": boolean;
    "label-position": boolean;
    "max-line-length": (number | boolean)[];
    "new-parens": boolean;
    "no-arg": boolean;
    "no-bitwise": boolean;
    "no-conditional-assignment": boolean;
    "no-consecutive-blank-lines": boolean;
    "no-console": (string | boolean)[];
    "no-construct": boolean;
    "no-debugger": boolean;
    "no-duplicate-variable": boolean;
    "no-empty": boolean;
    "no-eval": boolean;
    "no-reference": boolean;
    "no-shadowed-variable": boolean;
    "no-string-literal": boolean;
    "no-switch-case-fall-through": boolean;
    "no-trailing-whitespace": boolean;
    "no-unused-expression": boolean;
    "no-unused-new": boolean;
    "no-use-before-declare": boolean;
    "object-literal-sort-keys": boolean;
    "one-line": (string | boolean)[];
    "one-variable-per-declaration": (string | boolean)[];
    "quotemark": (string | boolean)[];
    "radix": boolean;
    "semicolon": (string | boolean)[];
    "switch-default": boolean;
    "trailing-comma": (boolean | {
        "multiline": string;
        "singleline": string;
    })[];
    "triple-equals": (string | boolean)[];
    "use-isnan": boolean;
    "variable-name": (string | boolean)[];
    "whitespace": (string | boolean)[];
};
