import type { Container, ICoordinates, IRgb, Particle, RecursivePartial } from "tsparticles-engine";
import { RotateDirection, Vector } from "tsparticles-engine";
import type { Absorbers } from "./Absorbers";
import type { IAbsorber } from "./Options/Interfaces/IAbsorber";
import type { IAbsorberSizeLimit } from "./Options/Interfaces/IAbsorberSizeLimit";
declare type OrbitingParticle = Particle & {
    absorberOrbit?: Vector;
    absorberOrbitDirection?: RotateDirection;
    needsNewPosition?: boolean;
};
export declare class AbsorberInstance {
    private readonly absorbers;
    private readonly container;
    color: IRgb;
    limit: IAbsorberSizeLimit;
    mass: number;
    readonly name?: string;
    opacity: number;
    position: Vector;
    size: number;
    private dragging;
    private readonly initialPosition?;
    private readonly options;
    constructor(absorbers: Absorbers, container: Container, options: RecursivePartial<IAbsorber>, position?: ICoordinates);
    attract(particle: OrbitingParticle): void;
    draw(context: CanvasRenderingContext2D): void;
    resize(): void;
    private calcPosition;
    private updateParticlePosition;
}
export {};
