import type { IContainerPlugin, ICoordinates, IOptions, Particle, RecursivePartial, SingleOrMultiple } from "tsparticles-engine";
import { Absorber } from "./Options/Classes/Absorber";
import type { AbsorberContainer } from "./AbsorberContainer";
import { AbsorberInstance } from "./AbsorberInstance";
import type { IAbsorber } from "./Options/Interfaces/IAbsorber";
import type { IAbsorberOptions } from "./Options/Interfaces/IAbsorberOptions";
export declare class Absorbers implements IContainerPlugin {
    private readonly container;
    absorbers: SingleOrMultiple<Absorber>;
    array: AbsorberInstance[];
    interactivityAbsorbers: SingleOrMultiple<Absorber>;
    constructor(container: AbsorberContainer);
    addAbsorber(options: RecursivePartial<IAbsorber>, position?: ICoordinates): AbsorberInstance;
    draw(context: CanvasRenderingContext2D): void;
    handleClickMode(mode: string): void;
    init(options?: RecursivePartial<IOptions & IAbsorberOptions>): void;
    particleUpdate(particle: Particle): void;
    removeAbsorber(absorber: AbsorberInstance): void;
    resize(): void;
    stop(): void;
}
