(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "tsparticles-engine", "./AbsorberSize"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Absorber = void 0;
    const tsparticles_engine_1 = require("tsparticles-engine");
    const AbsorberSize_1 = require("./AbsorberSize");
    class Absorber {
        constructor() {
            this.color = new tsparticles_engine_1.OptionsColor();
            this.color.value = "#000000";
            this.draggable = false;
            this.opacity = 1;
            this.destroy = true;
            this.orbits = false;
            this.size = new AbsorberSize_1.AbsorberSize();
        }
        load(data) {
            if (data === undefined) {
                return;
            }
            if (data.color !== undefined) {
                this.color = tsparticles_engine_1.OptionsColor.create(this.color, data.color);
            }
            if (data.draggable !== undefined) {
                this.draggable = data.draggable;
            }
            this.name = data.name;
            if (data.opacity !== undefined) {
                this.opacity = data.opacity;
            }
            if (data.position !== undefined) {
                this.position = {};
                if (data.position.x !== undefined) {
                    this.position.x = (0, tsparticles_engine_1.setRangeValue)(data.position.x);
                }
                if (data.position.y !== undefined) {
                    this.position.y = (0, tsparticles_engine_1.setRangeValue)(data.position.y);
                }
            }
            if (data.size !== undefined) {
                this.size.load(data.size);
            }
            if (data.destroy !== undefined) {
                this.destroy = data.destroy;
            }
            if (data.orbits !== undefined) {
                this.orbits = data.orbits;
            }
        }
    }
    exports.Absorber = Absorber;
});
