"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmitterRate = void 0;
const tsparticles_engine_1 = require("tsparticles-engine");
class EmitterRate {
    constructor() {
        this.quantity = 1;
        this.delay = 0.1;
    }
    load(data) {
        if (data === undefined) {
            return;
        }
        if (data.quantity !== undefined) {
            this.quantity = (0, tsparticles_engine_1.setRangeValue)(data.quantity);
        }
        if (data.delay !== undefined) {
            this.delay = (0, tsparticles_engine_1.setRangeValue)(data.delay);
        }
    }
}
exports.EmitterRate = EmitterRate;
