import type { Container, ICoordinates, IDelta, IDimension, IHsl, RecursivePartial } from "tsparticles-engine";
import { Emitter } from "./Options/Classes/Emitter";
import type { Emitters } from "./Emitters";
import type { EmittersEngine } from "./EmittersEngine";
import type { IEmitter } from "./Options/Interfaces/IEmitter";
import type { IEmitterSize } from "./Options/Interfaces/IEmitterSize";
export declare class EmitterInstance {
    #private;
    private readonly emitters;
    private readonly container;
    fill: boolean;
    readonly name?: string;
    options: Emitter;
    position?: ICoordinates;
    size: IEmitterSize;
    spawnColor?: IHsl;
    private currentDuration;
    private currentEmitDelay;
    private currentSpawnDelay;
    private duration?;
    private emitDelay?;
    private readonly immortal;
    private readonly initialPosition?;
    private lifeCount;
    private readonly particlesOptions;
    private paused;
    private readonly shape?;
    private spawnDelay?;
    constructor(engine: EmittersEngine, emitters: Emitters, container: Container, options: RecursivePartial<IEmitter>, position?: ICoordinates);
    externalPause(): void;
    externalPlay(): void;
    getPosition(): ICoordinates | undefined;
    getSize(): IDimension;
    pause(): void;
    play(): void;
    resize(): void;
    update(delta: IDelta): void;
    private calcPosition;
    private destroy;
    private emit;
    private emitParticles;
    private prepareToDie;
    private setColorAnimation;
}
