import type { IContainerPlugin, ICoordinates, IDelta, IOptions, RecursivePartial, SingleOrMultiple } from "tsparticles-engine";
import { Emitter } from "./Options/Classes/Emitter";
import type { EmitterContainer } from "./EmitterContainer";
import { EmitterInstance } from "./EmitterInstance";
import type { EmittersEngine } from "./EmittersEngine";
import type { IEmitter } from "./Options/Interfaces/IEmitter";
import type { IEmitterModeOptions } from "./Options/Interfaces/IEmitterModeOptions";
import type { IEmitterOptions } from "./Options/Interfaces/IEmitterOptions";
export declare class Emitters implements IContainerPlugin {
    #private;
    private readonly container;
    array: EmitterInstance[];
    emitters: SingleOrMultiple<Emitter>;
    interactivityEmitters: IEmitterModeOptions;
    constructor(engine: EmittersEngine, container: EmitterContainer);
    addEmitter(options: RecursivePartial<IEmitter>, position?: ICoordinates): EmitterInstance;
    handleClickMode(mode: string): void;
    init(options?: RecursivePartial<IOptions & IEmitterOptions>): void;
    pause(): void;
    play(): void;
    removeEmitter(emitter: EmitterInstance): void;
    resize(): void;
    stop(): void;
    update(delta: IDelta): void;
}
