import { AnimatableColor } from "tsparticles-engine";
import type { IOptionLoader, IParticlesOptions, IRangedCoordinates, MoveDirection, MoveDirectionAlt, RecursivePartial, SingleOrMultiple } from "tsparticles-engine";
import { EmitterLife } from "./EmitterLife";
import { EmitterRate } from "./EmitterRate";
import { EmitterShapeType } from "../../Enums/EmitterShapeType";
import { EmitterSize } from "./EmitterSize";
import type { IEmitter } from "../Interfaces/IEmitter";
export declare class Emitter implements IEmitter, IOptionLoader<IEmitter> {
    autoPlay: boolean;
    direction?: MoveDirection | keyof typeof MoveDirection | MoveDirectionAlt | number;
    domId?: string;
    fill: boolean;
    life: EmitterLife;
    name?: string;
    particles?: SingleOrMultiple<RecursivePartial<IParticlesOptions>>;
    position?: RecursivePartial<IRangedCoordinates>;
    rate: EmitterRate;
    shape: EmitterShapeType | keyof typeof EmitterShapeType;
    size?: EmitterSize;
    spawnColor?: AnimatableColor;
    startCount: number;
    constructor();
    load(data?: RecursivePartial<IEmitter>): void;
}
