import type { IAnimatableColor, IParticlesOptions, IRangedCoordinates, MoveDirection, MoveDirectionAlt, RecursivePartial, SingleOrMultiple } from "tsparticles-engine";
import type { EmitterShapeType } from "../../Enums/EmitterShapeType";
import type { IEmitterLife } from "./IEmitterLife";
import type { IEmitterRate } from "./IEmitterRate";
import type { IEmitterSize } from "./IEmitterSize";
export interface IEmitter {
    autoPlay: boolean;
    direction?: MoveDirection | keyof typeof MoveDirection | MoveDirectionAlt | number;
    domId?: string;
    fill: boolean;
    life: IEmitterLife;
    name?: string;
    particles?: SingleOrMultiple<RecursivePartial<IParticlesOptions>>;
    position?: RecursivePartial<IRangedCoordinates>;
    rate: IEmitterRate;
    shape: EmitterShapeType | keyof typeof EmitterShapeType;
    size?: IEmitterSize;
    spawnColor?: IAnimatableColor;
    startCount: number;
}
