var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "tsparticles-engine", "./Options/Classes/Emitter", "./EmitterInstance"], factory);
    }
})(function (require, exports) {
    "use strict";
    var _Emitters_engine;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Emitters = void 0;
    const tsparticles_engine_1 = require("tsparticles-engine");
    const Emitter_1 = require("./Options/Classes/Emitter");
    const EmitterInstance_1 = require("./EmitterInstance");
    class Emitters {
        constructor(engine, container) {
            this.container = container;
            _Emitters_engine.set(this, void 0);
            __classPrivateFieldSet(this, _Emitters_engine, engine, "f");
            this.array = [];
            this.emitters = [];
            this.interactivityEmitters = {
                random: {
                    count: 1,
                    enable: false,
                },
                value: [],
            };
            container.getEmitter = (idxOrName) => idxOrName === undefined || typeof idxOrName === "number"
                ? this.array[idxOrName || 0]
                : this.array.find((t) => t.name === idxOrName);
            container.addEmitter = (options, position) => this.addEmitter(options, position);
            container.removeEmitter = (idxOrName) => {
                const emitter = container.getEmitter(idxOrName);
                if (emitter) {
                    this.removeEmitter(emitter);
                }
            };
            container.playEmitter = (idxOrName) => {
                const emitter = container.getEmitter(idxOrName);
                if (emitter) {
                    emitter.externalPlay();
                }
            };
            container.pauseEmitter = (idxOrName) => {
                const emitter = container.getEmitter(idxOrName);
                if (emitter) {
                    emitter.externalPause();
                }
            };
        }
        addEmitter(options, position) {
            const emitterOptions = new Emitter_1.Emitter();
            emitterOptions.load(options);
            const emitter = new EmitterInstance_1.EmitterInstance(__classPrivateFieldGet(this, _Emitters_engine, "f"), this, this.container, emitterOptions, position);
            this.array.push(emitter);
            return emitter;
        }
        handleClickMode(mode) {
            const emitterOptions = this.emitters, modeEmitters = this.interactivityEmitters;
            if (mode === "emitter") {
                let emittersModeOptions;
                if (modeEmitters && modeEmitters.value instanceof Array) {
                    if (modeEmitters.value.length > 0 && modeEmitters.random.enable) {
                        emittersModeOptions = [];
                        const usedIndexes = [];
                        for (let i = 0; i < modeEmitters.random.count; i++) {
                            const idx = (0, tsparticles_engine_1.arrayRandomIndex)(modeEmitters.value);
                            if (usedIndexes.includes(idx) && usedIndexes.length < modeEmitters.value.length) {
                                i--;
                                continue;
                            }
                            usedIndexes.push(idx);
                            emittersModeOptions.push((0, tsparticles_engine_1.itemFromArray)(modeEmitters.value, idx));
                        }
                    }
                    else {
                        emittersModeOptions = modeEmitters.value;
                    }
                }
                else {
                    emittersModeOptions = modeEmitters === null || modeEmitters === void 0 ? void 0 : modeEmitters.value;
                }
                const emittersOptions = emittersModeOptions !== null && emittersModeOptions !== void 0 ? emittersModeOptions : emitterOptions, ePosition = this.container.interactivity.mouse.clickPosition;
                if (emittersOptions instanceof Array) {
                    for (const emitterOptions of emittersOptions) {
                        this.addEmitter(emitterOptions, ePosition);
                    }
                }
                else {
                    this.addEmitter((0, tsparticles_engine_1.deepExtend)({}, emittersOptions), ePosition);
                }
            }
        }
        init(options) {
            var _a, _b, _c, _d, _e, _f, _g, _h;
            if (!options) {
                return;
            }
            if (options.emitters) {
                if (options.emitters instanceof Array) {
                    this.emitters = options.emitters.map((s) => {
                        const tmp = new Emitter_1.Emitter();
                        tmp.load(s);
                        return tmp;
                    });
                }
                else {
                    if (this.emitters instanceof Array) {
                        this.emitters = new Emitter_1.Emitter();
                    }
                    this.emitters.load(options.emitters);
                }
            }
            const interactivityEmitters = (_b = (_a = options.interactivity) === null || _a === void 0 ? void 0 : _a.modes) === null || _b === void 0 ? void 0 : _b.emitters;
            if (interactivityEmitters) {
                if (interactivityEmitters instanceof Array) {
                    this.interactivityEmitters = {
                        random: {
                            count: 1,
                            enable: true,
                        },
                        value: interactivityEmitters.map((s) => {
                            const tmp = new Emitter_1.Emitter();
                            tmp.load(s);
                            return tmp;
                        }),
                    };
                }
                else {
                    const emitterMode = interactivityEmitters;
                    if (emitterMode.value !== undefined) {
                        if (emitterMode.value instanceof Array) {
                            this.interactivityEmitters = {
                                random: {
                                    count: (_c = this.interactivityEmitters.random.count) !== null && _c !== void 0 ? _c : 1,
                                    enable: (_d = this.interactivityEmitters.random.enable) !== null && _d !== void 0 ? _d : false,
                                },
                                value: emitterMode.value.map((s) => {
                                    const tmp = new Emitter_1.Emitter();
                                    tmp.load(s);
                                    return tmp;
                                }),
                            };
                        }
                        else {
                            const tmp = new Emitter_1.Emitter();
                            tmp.load(emitterMode.value);
                            this.interactivityEmitters = {
                                random: {
                                    count: (_e = this.interactivityEmitters.random.count) !== null && _e !== void 0 ? _e : 1,
                                    enable: (_f = this.interactivityEmitters.random.enable) !== null && _f !== void 0 ? _f : false,
                                },
                                value: tmp,
                            };
                        }
                    }
                    else {
                        const tmp = new Emitter_1.Emitter();
                        tmp.load(interactivityEmitters);
                        this.interactivityEmitters = {
                            random: {
                                count: (_g = this.interactivityEmitters.random.count) !== null && _g !== void 0 ? _g : 1,
                                enable: (_h = this.interactivityEmitters.random.enable) !== null && _h !== void 0 ? _h : false,
                            },
                            value: tmp,
                        };
                    }
                }
            }
            if (this.emitters instanceof Array) {
                for (const emitterOptions of this.emitters) {
                    this.addEmitter(emitterOptions);
                }
            }
            else {
                this.addEmitter(this.emitters);
            }
        }
        pause() {
            for (const emitter of this.array) {
                emitter.pause();
            }
        }
        play() {
            for (const emitter of this.array) {
                emitter.play();
            }
        }
        removeEmitter(emitter) {
            const index = this.array.indexOf(emitter);
            if (index >= 0) {
                this.array.splice(index, 1);
            }
        }
        resize() {
            for (const emitter of this.array) {
                emitter.resize();
            }
        }
        stop() {
            this.array = [];
        }
        update(delta) {
            for (const emitter of this.array) {
                emitter.update(delta);
            }
        }
    }
    exports.Emitters = Emitters;
    _Emitters_engine = new WeakMap();
});
