var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "./Shapes/Circle/CircleShape", "./Options/Classes/Emitter", "./Emitters", "./ShapeManager", "./Shapes/Square/SquareShape", "tsparticles-engine", "./EmitterContainer", "./EmittersEngine", "./Enums/EmitterClickMode", "./Enums/EmitterShapeType", "./Options/Interfaces/IEmitterOptions"], factory);
    }
})(function (require, exports) {
    "use strict";
    var _EmittersPlugin_engine;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.loadEmittersPlugin = void 0;
    const CircleShape_1 = require("./Shapes/Circle/CircleShape");
    const Emitter_1 = require("./Options/Classes/Emitter");
    const Emitters_1 = require("./Emitters");
    const ShapeManager_1 = require("./ShapeManager");
    const SquareShape_1 = require("./Shapes/Square/SquareShape");
    const tsparticles_engine_1 = require("tsparticles-engine");
    class EmittersPlugin {
        constructor(engine) {
            _EmittersPlugin_engine.set(this, void 0);
            __classPrivateFieldSet(this, _EmittersPlugin_engine, engine, "f");
            this.id = "emitters";
        }
        getPlugin(container) {
            return new Emitters_1.Emitters(__classPrivateFieldGet(this, _EmittersPlugin_engine, "f"), container);
        }
        loadOptions(options, source) {
            var _a, _b, _c, _d, _e, _f;
            if (!this.needsPlugin(options) && !this.needsPlugin(source)) {
                return;
            }
            const optionsCast = options;
            if (source === null || source === void 0 ? void 0 : source.emitters) {
                if ((source === null || source === void 0 ? void 0 : source.emitters) instanceof Array) {
                    optionsCast.emitters = source === null || source === void 0 ? void 0 : source.emitters.map((s) => {
                        const tmp = new Emitter_1.Emitter();
                        tmp.load(s);
                        return tmp;
                    });
                }
                else {
                    let emitterOptions = optionsCast.emitters;
                    if ((emitterOptions === null || emitterOptions === void 0 ? void 0 : emitterOptions.load) === undefined) {
                        optionsCast.emitters = emitterOptions = new Emitter_1.Emitter();
                    }
                    emitterOptions.load(source === null || source === void 0 ? void 0 : source.emitters);
                }
            }
            const interactivityEmitters = (_b = (_a = source === null || source === void 0 ? void 0 : source.interactivity) === null || _a === void 0 ? void 0 : _a.modes) === null || _b === void 0 ? void 0 : _b.emitters;
            if (interactivityEmitters) {
                if (interactivityEmitters instanceof Array) {
                    optionsCast.interactivity.modes.emitters = {
                        random: {
                            count: 1,
                            enable: true,
                        },
                        value: interactivityEmitters.map((s) => {
                            const tmp = new Emitter_1.Emitter();
                            tmp.load(s);
                            return tmp;
                        }),
                    };
                }
                else {
                    const emitterMode = interactivityEmitters;
                    if (emitterMode.value !== undefined) {
                        if (emitterMode.value instanceof Array) {
                            optionsCast.interactivity.modes.emitters = {
                                random: {
                                    count: (_c = emitterMode.random.count) !== null && _c !== void 0 ? _c : 1,
                                    enable: (_d = emitterMode.random.enable) !== null && _d !== void 0 ? _d : false,
                                },
                                value: emitterMode.value.map((s) => {
                                    const tmp = new Emitter_1.Emitter();
                                    tmp.load(s);
                                    return tmp;
                                }),
                            };
                        }
                        else {
                            const tmp = new Emitter_1.Emitter();
                            tmp.load(emitterMode.value);
                            optionsCast.interactivity.modes.emitters = {
                                random: {
                                    count: (_e = emitterMode.random.count) !== null && _e !== void 0 ? _e : 1,
                                    enable: (_f = emitterMode.random.enable) !== null && _f !== void 0 ? _f : false,
                                },
                                value: tmp,
                            };
                        }
                    }
                    else {
                        const emitterOptions = (optionsCast.interactivity.modes.emitters = {
                            random: {
                                count: 1,
                                enable: false,
                            },
                            value: new Emitter_1.Emitter(),
                        });
                        emitterOptions.value.load(interactivityEmitters);
                    }
                }
            }
        }
        needsPlugin(options) {
            var _a, _b, _c;
            if (!options) {
                return false;
            }
            const emitters = options.emitters;
            return ((emitters instanceof Array && !!emitters.length) ||
                emitters !== undefined ||
                (!!((_c = (_b = (_a = options.interactivity) === null || _a === void 0 ? void 0 : _a.events) === null || _b === void 0 ? void 0 : _b.onClick) === null || _c === void 0 ? void 0 : _c.mode) &&
                    (0, tsparticles_engine_1.isInArray)("emitter", options.interactivity.events.onClick.mode)));
        }
    }
    _EmittersPlugin_engine = new WeakMap();
    async function loadEmittersPlugin(engine) {
        if (!engine.emitterShapeManager) {
            engine.emitterShapeManager = new ShapeManager_1.ShapeManager(engine);
        }
        if (!engine.addEmitterShape) {
            engine.addEmitterShape = (name, shape) => {
                var _a;
                (_a = engine.emitterShapeManager) === null || _a === void 0 ? void 0 : _a.addShape(name, shape);
            };
        }
        const plugin = new EmittersPlugin(engine);
        await engine.addPlugin(plugin);
        engine.addEmitterShape("circle", new CircleShape_1.CircleShape());
        engine.addEmitterShape("square", new SquareShape_1.SquareShape());
    }
    exports.loadEmittersPlugin = loadEmittersPlugin;
    __exportStar(require("./EmitterContainer"), exports);
    __exportStar(require("./EmittersEngine"), exports);
    __exportStar(require("./Enums/EmitterClickMode"), exports);
    __exportStar(require("./Enums/EmitterShapeType"), exports);
    __exportStar(require("./Options/Interfaces/IEmitterOptions"), exports);
});
