import { OptionsColor, stringToAlpha } from "tsparticles-engine";
/**
 * @category Polygon Mask Plugin
 */
export class PolygonMaskDrawStroke {
    constructor() {
        this.color = new OptionsColor();
        this.width = 0.5;
        this.opacity = 1;
    }
    load(data) {
        var _a;
        if (!data) {
            return;
        }
        this.color = OptionsColor.create(this.color, data.color);
        if (typeof this.color.value === "string") {
            this.opacity = (_a = stringToAlpha(this.color.value)) !== null && _a !== void 0 ? _a : this.opacity;
        }
        if (data.opacity !== undefined) {
            this.opacity = data.opacity;
        }
        if (data.width !== undefined) {
            this.width = data.width;
        }
    }
}
