"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolygonMaskDrawStroke = void 0;
const tsparticles_engine_1 = require("tsparticles-engine");
class PolygonMaskDrawStroke {
    constructor() {
        this.color = new tsparticles_engine_1.OptionsColor();
        this.width = 0.5;
        this.opacity = 1;
    }
    load(data) {
        var _a;
        if (!data) {
            return;
        }
        this.color = tsparticles_engine_1.OptionsColor.create(this.color, data.color);
        if (typeof this.color.value === "string") {
            this.opacity = (_a = (0, tsparticles_engine_1.stringToAlpha)(this.color.value)) !== null && _a !== void 0 ? _a : this.opacity;
        }
        if (data.opacity !== undefined) {
            this.opacity = data.opacity;
        }
        if (data.width !== undefined) {
            this.width = data.width;
        }
    }
}
exports.PolygonMaskDrawStroke = PolygonMaskDrawStroke;
