import type { Container, Engine, IContainerPlugin, ICoordinates, IDelta, IDimension } from "tsparticles-engine";
import type { IPolygonMaskOptions } from "./types";
import type { ISvgPath } from "./Interfaces/ISvgPath";
import { OutModeDirection } from "tsparticles-engine";
import type { Particle } from "tsparticles-engine";
import { PolygonMask } from "./Options/Classes/PolygonMask";
import type { RecursivePartial } from "tsparticles-engine";
export declare class PolygonMaskInstance implements IContainerPlugin {
    #private;
    private readonly container;
    dimension: IDimension;
    offset?: ICoordinates;
    readonly options: PolygonMask;
    readonly path2DSupported: boolean;
    paths?: ISvgPath[];
    raw?: ICoordinates[];
    redrawTimeout?: number;
    private polygonMaskMoveRadius;
    constructor(container: Container, engine: Engine);
    clickPositionValid(position: ICoordinates): boolean;
    draw(context: CanvasRenderingContext2D): void;
    initAsync(options?: RecursivePartial<IPolygonMaskOptions>): Promise<void>;
    particleBounce(particle: Particle, delta: IDelta, direction: OutModeDirection): boolean;
    particlePosition(position?: ICoordinates): ICoordinates | undefined;
    particlesInitialization(): boolean;
    resize(): void;
    stop(): void;
    private checkInsidePolygon;
    private createPath2D;
    private downloadSvgPath;
    private drawPoints;
    private getEquidistantPointByIndex;
    private getPointByIndex;
    private getRandomPoint;
    private getRandomPointByLength;
    private initRawData;
    private parseSvgPath;
    private polygonBounce;
    private randomPoint;
}
