"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadLinksPreset = void 0;
const tsparticles_move_base_1 = require("tsparticles-move-base");
const tsparticles_shape_circle_1 = require("tsparticles-shape-circle");
const tsparticles_updater_color_1 = require("tsparticles-updater-color");
const tsparticles_updater_opacity_1 = require("tsparticles-updater-opacity");
const tsparticles_updater_out_modes_1 = require("tsparticles-updater-out-modes");
const tsparticles_interaction_particles_links_1 = require("tsparticles-interaction-particles-links");
const tsparticles_updater_size_1 = require("tsparticles-updater-size");
const options_1 = require("./options");
async function loadLinksPreset(engine) {
    await (0, tsparticles_move_base_1.loadBaseMover)(engine);
    await (0, tsparticles_shape_circle_1.loadCircleShape)(engine);
    await (0, tsparticles_updater_color_1.loadColorUpdater)(engine);
    await (0, tsparticles_interaction_particles_links_1.loadParticlesLinksInteraction)(engine);
    await (0, tsparticles_updater_out_modes_1.loadOutModesUpdater)(engine);
    await (0, tsparticles_updater_opacity_1.loadOpacityUpdater)(engine);
    await (0, tsparticles_updater_size_1.loadSizeUpdater)(engine);
    await engine.addPreset("links", options_1.options);
}
exports.loadLinksPreset = loadLinksPreset;
